/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import sam.gui.GUIManager;
import sam.gui.Icon;

public class ObjectIcon
extends Icon
implements Observer {
    protected Dimension size;
    protected boolean flash;
    protected Updater updater;

    public void startFlash() {
        if (this.updater == null) {
            this.updater = new Updater(1);
            try {
                this.updater.start();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void stopFlash() {
        try {
            this.updater.isAlive();
            this.updater.stop();
            try {
                this.updater.join();
            }
            catch (Exception exception) {}
            this.updater = null;
            this.flash = false;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.size = this.getSize();
        if (this.size.width == 0 || this.size.height == 0) {
            this.size = this.getImageSize();
        }
    }

    public int percentWidth(double d) {
        return (int)((double)this.size.width * d);
    }

    public int percentHeight(double d) {
        return (int)((double)this.size.height * d);
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    public ObjectIcon(String string, int n, int n2) {
        super(string, n, n2);
    }

    public ObjectIcon(String string) {
        super(string, -1, GUIManager.getIconHeight(5));
    }

    public ObjectIcon() {
    }

    protected class Updater
    extends Thread {
        private int sleepDuration;

        Updater(int n) {
            ObjectIcon.this = ObjectIcon.this;
            this.setDuration(n);
        }

        public void setDuration(int n) {
            this.sleepDuration = n * 1000;
        }

        public void setMicroDuration(int n) {
            this.sleepDuration = n;
        }

        public int getDuration() {
            return this.sleepDuration / 1000;
        }

        public void run() {
            while (this.isAlive()) {
                try {
                    Thread.sleep(this.sleepDuration);
                }
                catch (Exception exception) {}
                ObjectIcon.this.flash = !ObjectIcon.this.flash;
                ObjectIcon.this.repaint();
            }
        }
    }
}

