/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import jclass.bwt.JCGroupBox;
import sam.authority.AuthorityManager;
import sam.gui.StatusPanel;
import sam.model.CatalogEntry;
import sam.resource.ResourceManager;

public class CatEntryStatus
extends StatusPanel {
    private CatalogEntry entry;
    private Checkbox unavailBox;
    boolean oldUnavailState;

    public boolean apply() {
        if (this.isEditable() && this.oldUnavailState != this.unavailBox.getState()) {
            this.entry.getMedia().setUnavailable(this.unavailBox.getState());
        }
        return true;
    }

    public void setup() {
        if (this.isInitialized()) {
            this.removeAll();
        }
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        this.addField(ResourceManager.getString("Slot number"), Integer.toString(this.entry.getEa().getElementAddress()));
        this.addEndLine();
        JCGroupBox jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Catalog Entry Attributes") + " "));
        GridLayout gridLayout = new GridLayout(3, 2);
        jCGroupBox.setLayout(gridLayout);
        Checkbox checkbox = new Checkbox(ResourceManager.getString("Unknown state"), this.entry.unknownState());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("In use"), this.entry.isInUse());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Occupied"), this.entry.isOccupied());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        this.unavailBox = new Checkbox(ResourceManager.getString("Unavailable"), this.entry.isUnavailable());
        try {
            this.unavailBox.setEnabled(AuthorityManager.isOperatorLevel() && this.entry.getMedia().isLabeled());
        }
        catch (Exception exception) {
            this.unavailBox.setEnabled(false);
        }
        this.oldUnavailState = this.unavailBox.getState();
        jCGroupBox.add((Component)this.unavailBox);
        checkbox = new Checkbox(ResourceManager.getString("Import/export"), this.entry.isImportExport());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        this.addComponent((Component)jCGroupBox);
        this.addEndLine();
        if (!this.isEditable()) {
            this.unavailBox.setEnabled(false);
        }
        this.setInitialized(true);
    }

    public CatEntryStatus(CatalogEntry catalogEntry) {
        this.entry = catalogEntry;
    }
}

