/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCProgressMeter;
import sam.authority.AuthorityManager;
import sam.gui.StatusPanel;
import sam.model.Media;
import sam.model.TapeMedia;
import sam.resource.ResourceManager;

public class MediaStatus
extends StatusPanel {
    private Media media;
    private JCProgressMeter meter;
    private Checkbox badMediaBox;
    private Checkbox readOnlyBox;
    private Checkbox recycleBox;
    private boolean oldBadMediaState;
    private boolean oldReadOnlyState;
    private boolean oldRecycleState;

    public boolean apply() {
        if (this.isEditable()) {
            if (this.oldBadMediaState != this.badMediaBox.getState()) {
                this.media.setDamaged(this.badMediaBox.getState());
            }
            if (this.oldReadOnlyState != this.readOnlyBox.getState()) {
                this.media.setReadOnly(this.readOnlyBox.getState());
            }
            if (this.oldRecycleState != this.recycleBox.getState()) {
                this.media.setRecycle(this.recycleBox.getState());
            }
        }
        return true;
    }

    public void setup() {
        if (this.isInitialized()) {
            this.removeAll();
        }
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        this.addField(ResourceManager.getString("VSN"), this.media.getName());
        this.addField(ResourceManager.getString("Type"), this.media.getTypeString());
        if (this.media.isBarcoded()) {
            this.addField(ResourceManager.getString("Barcode"), this.media.getBarcode());
        }
        this.addEndLine();
        if (!this.media.isCleaning() && !this.media.isUnformatted()) {
            this.options.fill = 0;
            this.addField(ResourceManager.getString("Capacity"), Long.toString(this.media.getCapacity()));
            this.addEndLine();
            this.options.fill = 2;
            this.addLabel(ResourceManager.getString("Storage used"));
            this.meter = new JCProgressMeter((int)this.media.getPercentageFull(), 0, 100);
            this.meter.setBarSpacing(0);
            this.meter.setBarCount(100);
            this.meter.setLabelPosition(4);
            this.addComponent((Component)this.meter);
            this.addEndLine();
            if (this.media instanceof TapeMedia) {
                this.addField(ResourceManager.getString("Block size"), Integer.toString(this.media.getSectorSize() / 1024));
            }
        }
        this.addField(ResourceManager.getString("Access count"), Integer.toString(this.media.getAccessCount()));
        this.addEndLine();
        JCGroupBox jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Media Attributes") + " "));
        GridLayout gridLayout = new GridLayout(3, 3);
        jCGroupBox.setLayout(gridLayout);
        Checkbox checkbox = new Checkbox(ResourceManager.getString("Labeled"), this.media.isLabeled());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        this.badMediaBox = new Checkbox(ResourceManager.getString("Damaged"), this.media.isMarkedDamaged());
        this.badMediaBox.setEnabled(AuthorityManager.isRootLevel());
        this.oldBadMediaState = this.badMediaBox.getState();
        jCGroupBox.add((Component)this.badMediaBox);
        checkbox = new Checkbox(ResourceManager.getString("Cleaning"), this.media.isCleaning());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Barcoded"), this.media.isBarcoded());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Write Protected"), this.media.isWriteProtected());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        this.readOnlyBox = new Checkbox(ResourceManager.getString("Read-only"), this.media.isReadOnly());
        this.readOnlyBox.setEnabled(AuthorityManager.isOperatorLevel());
        this.oldReadOnlyState = this.readOnlyBox.getState();
        jCGroupBox.add((Component)this.readOnlyBox);
        this.recycleBox = new Checkbox(ResourceManager.getString("Recycle"), this.media.isMarkedRecycle());
        this.recycleBox.setEnabled(AuthorityManager.isRootLevel());
        this.oldRecycleState = this.recycleBox.getState();
        jCGroupBox.add((Component)this.recycleBox);
        this.addComponent((Component)jCGroupBox);
        this.addEndLine();
        this.options.fill = 0;
        if (!this.media.isCleaning() && !this.media.isUnformatted()) {
            this.addField(ResourceManager.getString("Label time"), this.media.getLabelDate().toLocaleString());
            this.addEndLine();
        }
        this.addField(ResourceManager.getString("Mount time"), this.media.getMountDate().toLocaleString());
        this.addEndLine();
        this.addField(ResourceManager.getString("Modification time"), this.media.getModificationDate().toLocaleString());
        this.addEndLine();
        this.options.fill = 2;
        if (!this.isEditable()) {
            this.badMediaBox.setEnabled(false);
            this.readOnlyBox.setEnabled(false);
            this.recycleBox.setEnabled(false);
        }
        this.setInitialized(true);
    }

    public MediaStatus(Media media) {
        this.media = media;
    }
}

