/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.dialog;

import sam.gui.CatalogDisplay;
import sam.gui.DeviceMediaDisplay;
import sam.gui.DialogBox;
import sam.gui.status.LabelPanel;
import sam.model.Catalog;
import sam.model.CatalogEntry;
import sam.model.Robot;
import sam.model.TableEntry;
import sam.resource.ResourceManager;

public class LabelDialog
extends DialogBox {
    private Robot robot;

    public void show(TableEntry tableEntry) {
        CatalogEntry catalogEntry = (CatalogEntry)tableEntry;
        this.setTitle(String.valueOf(ResourceManager.getString("Label")) + ": " + ResourceManager.getString("slot number") + " " + catalogEntry.getSlotNumber());
        this.addPanel(new LabelPanel(this.robot, catalogEntry.getMedia(), catalogEntry.getSlotNumber()));
        this.addButtons(5);
        super.show();
    }

    public LabelDialog(CatalogDisplay catalogDisplay) {
        super(ResourceManager.getString("Label"), catalogDisplay);
        this.robot = ((Catalog)catalogDisplay.getDataTable()).getParent();
    }

    public LabelDialog(DeviceMediaDisplay deviceMediaDisplay) {
        super(String.valueOf(ResourceManager.getString("Label")) + ": " + deviceMediaDisplay.getMedia().getName(), deviceMediaDisplay);
        this.addPanel(new LabelPanel(deviceMediaDisplay.getDevice(), deviceMediaDisplay.getMedia()));
        this.addButtons(5);
    }
}

