/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCProgressMeter;
import sam.authority.AuthorityManager;
import sam.gui.SliderDisplay;
import sam.gui.StatusPanel;
import sam.model.MassStorage;
import sam.model.RawDisk;
import sam.resource.ResourceManager;

public class FSStatus
extends StatusPanel {
    private MassStorage fileSystem;
    private JCProgressMeter meter;
    private SliderDisplay minThreshold;
    private SliderDisplay maxThreshold;
    private SliderDisplay maxReadahead;
    private SliderDisplay maxWritebehind;

    public boolean apply() {
        if (this.isEditable() && this.fileSystem.isMounted()) {
            this.fileSystem.setReadahead(this.maxReadahead.getValue());
            this.fileSystem.setWritebehind(this.maxWritebehind.getValue());
            this.fileSystem.setThreshold(this.minThreshold.getValue(), this.maxThreshold.getValue());
        }
        return true;
    }

    public void setup() {
        RawDisk[] rawDiskArray;
        if (this.isInitialized()) {
            this.removeAll();
        }
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        if (this.fileSystem.isMounted()) {
            this.options.fill = 0;
            this.addField(ResourceManager.getString("Mount path"), this.fileSystem.getMountPath());
            this.addEndLine();
            this.addField(ResourceManager.getString("Capacity"), Long.toString(this.fileSystem.getCapacity()));
            this.addEndLine();
            this.options.fill = 2;
            this.addLabel(ResourceManager.getString("Storage used"));
            this.meter = new JCProgressMeter((int)this.fileSystem.getPercentageFull(), 0, 100);
            this.meter.setBarSpacing(0);
            this.meter.setBarCount(100);
            this.meter.setLabelPosition(4);
            this.addComponent((Component)this.meter);
            this.addEndLine();
            this.minThreshold = new SliderDisplay(ResourceManager.getString("Low Water Mark"), 0, 100, this.fileSystem.getMinThreshold(), 5);
            this.minThreshold.setEnabled(AuthorityManager.isRootLevel());
            this.addComponent(this.minThreshold);
            this.addEndLine();
            this.maxThreshold = new SliderDisplay(ResourceManager.getString("High Water Mark"), 0, 100, this.fileSystem.getMaxThreshold(), 5);
            this.maxThreshold.setEnabled(AuthorityManager.isRootLevel());
            this.addComponent(this.maxThreshold);
            this.addEndLine();
            this.maxReadahead = new SliderDisplay(ResourceManager.getString("Max Readahead"), 0, 32678, this.fileSystem.getReadahead(), 16);
            this.maxReadahead.setEnabled(AuthorityManager.isRootLevel());
            this.addComponent(this.maxReadahead);
            this.addEndLine();
            this.maxWritebehind = new SliderDisplay(ResourceManager.getString("Max Writebehind"), 8, 32768, this.fileSystem.getWritebehind(), 20);
            this.maxWritebehind.setEnabled(AuthorityManager.isRootLevel());
            this.addComponent(this.maxWritebehind);
            this.addEndLine();
        }
        if ((rawDiskArray = this.fileSystem.getDiskPartitions()) != null) {
            JCGroupBox jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Disk Partitions") + " "));
            GridLayout gridLayout = new GridLayout(rawDiskArray.length, 1);
            jCGroupBox.setLayout(gridLayout);
            int n = 0;
            while (n < rawDiskArray.length) {
                Label label = new Label("  " + rawDiskArray[n].getPartitionName());
                label.setBackground(Color.white);
                jCGroupBox.add((Component)label);
                ++n;
            }
            this.addComponent((Component)jCGroupBox);
            this.addEndLine();
        }
        if (!this.isEditable()) {
            this.maxReadahead.setEnabled(false);
            this.maxWritebehind.setEnabled(false);
            this.minThreshold.setEnabled(false);
            this.maxThreshold.setEnabled(false);
        }
        this.setInitialized(true);
    }

    public FSStatus(MassStorage massStorage) {
        this.fileSystem = massStorage;
    }
}

