/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.JCTextCursorEvent;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextListener;
import jclass.bwt.LabelConverter;
import jclass.bwt.TextComponentConverter;
import jclass.util.JCEnvironment;
import jclass.util.JCVector;

public abstract class JCTextComponent
extends JCComponent
implements JCTextInterface,
Runnable {
    private boolean TRACE = false;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int CASE_AS_IS = 0;
    public static final int CASE_LOWER = 1;
    public static final int CASE_UPPER = 2;
    public static final int SELECT_NONE = 0;
    public static final int SELECT_CHAR = 1;
    public static final int SELECT_WORD = 2;
    public static final int SELECT_LINE = 3;
    public static final int SELECT_PARAGRAPH = 4;
    public static final int SELECT_ALL = 5;
    protected ResourceBundle li;
    protected PopupMenu popup_menu;
    transient Thread cursor_thread;
    int cursor_pos;
    boolean cursor_state = false;
    boolean cursor_visible = true;
    boolean paint_cursor = true;
    boolean display_cursor = true;
    boolean show_cursor = true;
    int disabled_repaint_count;
    int action_count;
    boolean needs_repaint = false;
    boolean do_repaint = true;
    Window window;
    int num_char;
    int max_length = Integer.MAX_VALUE;
    int columns = 20;
    char[] text = new char[4];
    int alignment = 0;
    int select_start;
    int select_end;
    int select_anchor;
    int selection_type;
    protected int horiz_origin;
    protected int vert_origin;
    protected JCVector cursorListeners = new JCVector(0);
    protected JCVector valueListeners = new JCVector(0);
    boolean editable = true;
    boolean overstrike = false;
    boolean changed = false;
    int string_case = 0;
    Color selected_fg;
    Color selected_bg;
    transient FontMetrics fm;
    transient Event last_event;
    protected int cursor_blink_rate = 500;
    Rectangle rect = new Rectangle();
    int[] select_list = new int[]{1, 2, 3, 5};
    boolean last_state = false;
    boolean last_overstrike = false;
    int last_x = -999;
    int last_y;
    int last_cursor_width;
    static final boolean JBUILDER = System.getProperty("java.version").indexOf("Borland") != -1;
    boolean first = true;
    private static Point p1 = new Point(0, 0);
    private static Point p2 = new Point(0, 0);
    boolean pasting = false;

    public JCTextComponent() {
        this(null, null);
    }

    public JCTextComponent(Applet applet, String string) {
        super(applet, string);
        if (this.getClass().getName().equals("jclass.bwt.JCTextComponent")) {
            this.getParameters(applet);
        }
        this.shadow_type = 8;
        if (JCComponent.use_system_colors) {
            this.setBackground(SystemColor.text);
            this.setForeground(SystemColor.textText);
            this.selected_bg = SystemColor.textHighlight;
            this.selected_fg = SystemColor.textHighlightText;
        }
        if (this.TRACE) {
            System.out.println("Locale = " + Locale.getDefault());
        }
        this.li = ResourceBundle.getBundle("jclass.bwt.resources.LocaleInfo", Locale.getDefault());
    }

    protected void getParameters() {
        super.getParameters();
        TextComponentConverter.getParams(this);
    }

    public void setFont(Font font) {
        if (this.getPeer() != null) {
            this.fm = this.getToolkit().getFontMetrics(font);
        }
        super.setFont(font);
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        LabelConverter.checkAlignment(n);
        this.alignment = n;
        this.repaint();
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public int getLastPosition() {
        return this.num_char;
    }

    public int getSelectionStart() {
        return this.select_start;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        return this.select_end;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public synchronized String getText() {
        return new String(this.text, 0, this.num_char);
    }

    char[] getTextChars() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            this.vert_origin = 0;
            this.horiz_origin = 0;
            this.replaceRange(string, 0, this.num_char);
            this.changed = false;
            return;
        }
    }

    public int getNumChar() {
        return this.num_char;
    }

    public int getMaximumLength() {
        return this.max_length;
    }

    public void setMaximumLength(int n) {
        this.max_length = n;
    }

    protected boolean deleteSelection() {
        return this.deleteRange(this.select_start, this.select_end);
    }

    protected boolean deleteRange(int n, int n2) {
        if (n >= n2) {
            return true;
        }
        String string = "";
        boolean bl = this.replaceRangeInternal(string, n, n2);
        return bl;
    }

    protected void cancelSelection() {
        if (this.select_start >= this.select_end) {
            return;
        }
        int n = this.select_start;
        int n2 = this.select_end;
        this.select_start = this.select_end = this.cursor_pos;
        this.repaintPositions(n, n2);
    }

    public synchronized void insert(String string, int n) {
        this.replaceRange(string, n, n);
    }

    public void append(String string) {
        this.select(this.num_char);
        this.replaceRange(string, this.num_char, this.num_char);
    }

    public int getStringCase() {
        return this.string_case;
    }

    public void setStringCase(int n) {
        TextComponentConverter.checkStringCase(n);
        if (n != this.string_case) {
            this.string_case = n;
            if (n != 0) {
                this.replaceRange(this.getText(), 0, this.num_char);
            }
        }
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceRangeInternal(string, n, n2);
    }

    boolean replaceRangeInternal(String string, int n, int n2) {
        this.startAction(null);
        if (string == null) {
            string = "";
        }
        if (this.string_case == 1) {
            string = string.toLowerCase();
        } else if (this.string_case == 2) {
            string = string.toUpperCase();
        }
        boolean bl = this.replace(string, n, n2);
        this.endAction();
        return bl;
    }

    protected void replaceTextInternal(String string, int n, int n2) {
        int n3 = string != null ? string.length() : 0;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            if (n2 - n > 0) {
                System.arraycopy(this.text, n2, this.text, n, this.num_char - n2);
                this.num_char -= n2 - n;
            }
            if (n3 > 0) {
                if (this.num_char + n3 + n >= this.text.length) {
                    char[] cArray = new char[Math.max(this.num_char * 2, this.num_char + n3 + n + 1)];
                    System.arraycopy(this.text, 0, cArray, 0, this.num_char);
                    this.text = cArray;
                }
                if (this.num_char > n) {
                    System.arraycopy(this.text, n, this.text, n + n3, this.num_char - n);
                }
                string.getChars(0, n3, this.text, n);
                if (this.alignment == 0) {
                    this.positionToPoint(n, p1);
                    this.positionToPoint(n2, p2);
                }
                this.select_start = this.select_end = (n += n3);
                this.num_char += n3;
                if (this.alignment != 0) {
                    this.positionToPoint(n - n3, p1);
                    this.positionToPoint(n2, p2);
                }
                bl = this.do_repaint;
            }
        }
        if (bl && this.getPeer() != null) {
            serializable = new Rectangle(this.positionToPoint(n, null));
            ((Rectangle)serializable).add(this.positionToPoint(n2, null));
            if (this.alignment != 0) {
                ((Rectangle)serializable).x = this.getDrawingArea().x;
            }
            Graphics graphics = this.getGraphics();
            this.repaint(graphics, ((Rectangle)serializable).x - this.horiz_origin, ((Rectangle)serializable).y - this.vert_origin, this.size().width, ((Rectangle)serializable).height + this.fm.getHeight());
        }
    }

    protected void updateScrollbars() {
    }

    protected boolean replace(String string, int n, int n2) {
        int n3;
        int n4 = n3 = string != null ? string.length() : 0;
        if (this.last_event != null && this.max_length < Integer.MAX_VALUE && this.num_char + n3 - (n2 - n) > this.max_length) {
            this.beep();
            return false;
        }
        JCTextEvent jCTextEvent = null;
        Rectangle rectangle = null;
        if (this.valueListeners.size() > 0) {
            jCTextEvent = new JCTextEvent(this, n, n2, string);
            jCTextEvent.is_deletion = this.last_event != null && (this.last_event.key == 8 || this.last_event.key == 127) ? true : n2 - n > 0 && n3 < n2 - n;
            int n5 = 0;
            while (n5 < this.valueListeners.size()) {
                ((JCTextListener)this.valueListeners.elementAt(n5)).textValueChangeBegin(jCTextEvent);
                ++n5;
            }
            if (!jCTextEvent.doit) {
                return false;
            }
            n = jCTextEvent.start;
            n2 = jCTextEvent.end;
            string = jCTextEvent.text;
        }
        if (this.last_event == null) {
            this.changed = false;
        }
        if (string == null) {
            string = "";
        }
        if (this.getPeer() != null) {
            rectangle = new Rectangle(this.positionToPoint(n, null));
            rectangle.add(this.positionToPoint(n2, null));
            if (this.alignment != 0) {
                rectangle.x = this.getDrawingArea().x;
            }
        }
        this.replaceTextInternal(string, n, n2);
        this.setCursorPosition(n + n3);
        this.select_start = this.select_end = this.cursor_pos;
        if (this.getPeer() != null) {
            rectangle.add(this.positionToPoint(this.cursor_pos, null));
            Graphics graphics = this.getGraphics();
            this.repaint(graphics, rectangle.x - this.horiz_origin, rectangle.y - this.vert_origin, this.size().width, rectangle.height + this.fm.getHeight());
        }
        if (jCTextEvent != null) {
            int n6 = 0;
            while (n6 < this.valueListeners.size()) {
                ((JCTextListener)this.valueListeners.elementAt(n6)).textValueChangeEnd(jCTextEvent);
                ++n6;
            }
        }
        return true;
    }

    protected int checkCursorPosition(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > this.num_char) {
            return this.num_char;
        }
        return n;
    }

    public int getCursorPosition() {
        return this.cursor_pos;
    }

    public void setCursorPosition(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("cursor position less than zero.");
        }
        JCTextCursorEvent jCTextCursorEvent = null;
        if (this.last_event == null) {
            this.startAction(null);
        }
        if (this.cursor_pos == n) {
            this.endAction();
            return;
        }
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            n = this.checkCursorPosition(n);
            if (this.cursorListeners.size() > 0) {
                jCTextCursorEvent = new JCTextCursorEvent(this, this.cursor_pos, n);
                int n2 = 0;
                while (n2 < this.cursorListeners.size()) {
                    ((JCTextCursorListener)this.cursorListeners.elementAt(n2)).textCursorMoveBegin(jCTextCursorEvent);
                    ++n2;
                }
                if (!jCTextCursorEvent.doit) {
                    Object var4_6 = null;
                    return;
                }
                n = this.checkCursorPosition(jCTextCursorEvent.new_pos);
            }
            this.cursor_pos = n;
        }
        if (this.last_event == null) {
            this.select(this.cursor_pos);
        }
        this.endAction();
        if (jCTextCursorEvent != null) {
            int n3 = 0;
            while (n3 < this.cursorListeners.size()) {
                ((JCTextCursorListener)this.cursorListeners.elementAt(n3)).textCursorMoveEnd(jCTextCursorEvent);
                ++n3;
            }
        }
    }

    public int getCaretPosition() {
        return this.getCursorPosition();
    }

    public void setCaretPosition(int n) {
        this.setCursorPosition(n);
    }

    public boolean getShowCursorPosition() {
        return this.display_cursor;
    }

    public void setShowCursorPosition(boolean bl) {
        this.display_cursor = bl;
        if (this.show_cursor) {
            this.showPosition(this.cursor_pos);
        }
    }

    public void setOverstrike(boolean bl) {
        this.overstrike = bl;
    }

    public boolean getOverstrike() {
        return this.overstrike;
    }

    public synchronized String getSelectedText() {
        return new String(this.text, this.select_start, this.select_end - this.select_start);
    }

    public void selectAll() {
        this.select(0, this.num_char);
    }

    public void select(int n, int n2) {
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            this.select(n, n2, 0);
        }
        this.last_event = new Event(null, 0, null);
        this.setCursorPosition(n);
    }

    void select(int n) {
        this.select(n, n);
    }

    protected boolean isWordDelimiter(char c) {
        return !Character.isJavaLetterOrDigit(c);
    }

    protected boolean isLineDelimiter(char c) {
        return c == '\n' || c == '\r';
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void select(int var1_1, int var2_2, int var3_3) {
        block16: {
            block17: {
                if (var1_1 > var2_2) {
                    var4_4 = var1_1;
                    var1_1 = var2_2;
                    var2_2 = var4_4;
                }
                var1_1 = Math.max(0, Math.min(var1_1, this.num_char));
                var2_2 = Math.max(0, Math.min(var2_2, this.num_char));
                var4_4 = var1_1;
                var5_5 = var2_2;
                cfr_temp_0 = 0;
lbl10:
                // 2 sources

                while (true) {
                    switch (cfr_temp_0 == 0 ? var3_3 : cfr_temp_0) {
                        case 2: {
                            ** break;
                        }
                        case 5: {
                            var1_1 = 0;
                            var2_2 = this.num_char;
                            break block16;
                        }
                        default: {
                            break block16;
                        }
lbl20:
                        // 1 sources

                        while (true) {
                            if (var1_1 <= 0 || this.isWordDelimiter(this.text[var1_1 - 1])) {
                                while (true) {
                                    if (var2_2 >= this.num_char || this.isWordDelimiter(this.text[var2_2])) {
                                        if (var1_1 == var4_4 && var2_2 == var5_5 && this.getSelectionType(var3_3 + 1) == 3) {
                                            var1_1 = 0;
                                            var2_2 = this.num_char;
                                            ** break;
                                        }
                                        break block16;
                                    }
                                    ++var2_2;
                                }
                            }
                            --var1_1;
                        }
lbl33:
                        // 1 sources

                        while (true) {
                            cfr_temp_0 = 3;
                            --var1_1;
                            break;
                        }
                        case 3: 
                    }
                    break;
                }
                break block17;
                ** while (true)
            }
            ** while (var1_1 > 0 && !this.isLineDelimiter((char)this.text[var1_1 - 1]))
lbl41:
            // 2 sources

            while (var2_2 < this.num_char && !this.isLineDelimiter(this.text[var2_2])) {
                ++var2_2;
            }
        }
        if (var1_1 == this.select_start && var2_2 == this.select_end) {
            return;
        }
        var4_4 = this.select_start;
        var5_5 = this.select_end;
        this.select_start = var1_1;
        this.select_end = var2_2;
        if (var2_2 >= var4_4 && var1_1 <= var5_5) {
            this.repaintPositions(var4_4, var1_1);
            this.repaintPositions(var5_5, var2_2);
            return;
        }
        this.repaintPositions(var4_4, var5_5);
        this.repaintPositions(this.select_start, this.select_end);
    }

    public abstract int positionToX(int var1);

    public int positionToY(int n) {
        return this.getDrawingArea().y;
    }

    public void addTextListener(JCTextListener jCTextListener) {
        this.valueListeners.add(jCTextListener);
    }

    public void removeTextListener(JCTextListener jCTextListener) {
        this.valueListeners.removeElement(jCTextListener);
    }

    public void addTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.cursorListeners.add(jCTextCursorListener);
    }

    public void removeTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.cursorListeners.removeElement(jCTextCursorListener);
    }

    void paintCursor(boolean bl, Graphics graphics, int n, int n2) {
        int n3 = this.fm.getHeight();
        n2 += n3 - 1;
        if (!bl && (JBUILDER || this.window instanceof Dialog)) {
            this.repaint(new Rectangle(n, n2 - n3 + 1, 1, n3));
            return;
        }
        if (this.window instanceof Dialog) {
            graphics.setPaintMode();
            graphics.setColor(this.getForeground());
            graphics.drawLine(n, n2 - n3 + 1, n, n2);
            return;
        }
        graphics.drawLine(n, n2 - n3 + 1, n, n2);
    }

    protected void paintCursor(boolean bl) {
        if (!(this.isShowing() && this.paint_cursor && this.has_focus)) {
            return;
        }
        this.getDrawingArea(this.rect);
        int n = this.last_x;
        int n2 = this.last_y;
        if (this.isShowing() && this.display_cursor && bl != this.last_state) {
            Graphics graphics;
            try {
                graphics = this.getGraphics();
            }
            catch (Exception exception) {
                return;
            }
            if (graphics == null) {
                return;
            }
            Object object = JCComponent.LOCK;
            synchronized (object) {
                if (bl) {
                    n = this.positionToX(this.cursor_pos);
                    n2 = this.positionToY(this.cursor_pos);
                }
                int n3 = this.shadow + this.highlight;
                graphics.clipRect(n3, n3, this.size().width - 2 * n3, this.size().height - 2 * n3);
                graphics.translate(-this.horiz_origin, -this.vert_origin);
                graphics.setXORMode(this.getBackground());
                if (!bl && this.last_overstrike != this.overstrike) {
                    boolean bl2 = this.overstrike;
                    this.overstrike = this.last_overstrike;
                    this.paintCursor(bl, graphics, n, n2);
                    this.overstrike = bl2;
                } else {
                    this.paintCursor(bl, graphics, n, n2);
                }
                graphics.dispose();
            }
        }
        this.last_state = bl;
        if (bl) {
            this.last_x = n;
            this.last_y = n2;
        }
        this.last_overstrike = this.overstrike;
    }

    public void run() {
        this.paintCursor(true);
        while (true) {
            try {
                Thread.sleep(this.cursor_blink_rate);
            }
            catch (Throwable throwable) {
                return;
            }
            if (!Thread.currentThread().isAlive() || this.cursor_thread == null) {
                return;
            }
            this.cursor_visible = !this.cursor_visible;
            this.paintCursor(this.cursor_visible);
        }
    }

    int leftMargin() {
        return this.getDrawingArea().x;
    }

    int rightMargin() {
        return this.insets.right + 2 * (this.highlight + this.shadow);
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            this.editable = bl;
            if (this.editable) {
                this.traversable = true;
            }
        }
        this.repaint();
    }

    public Color getSelectedBackground() {
        if (this.selected_bg != null) {
            return this.selected_bg;
        }
        return this.getForeground();
    }

    public void setSelectedBackground(Color color) {
        this.selected_bg = color;
    }

    public Color getSelectedForeground() {
        if (this.selected_fg != null) {
            return this.selected_fg;
        }
        return this.getBackground();
    }

    public void setSelectedForeground(Color color) {
        this.selected_fg = color;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        this.columns = n;
    }

    public int[] getSelectionList() {
        return this.select_list;
    }

    public void setSelectionList(int[] nArray) {
        this.select_list = nArray;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public abstract void showPosition(int var1);

    private void setFm() {
        this.fm = this.getFont() != null ? this.getToolkit().getFontMetrics(this.getFont()) : null;
    }

    protected int preferredHeight() {
        this.setFm();
        if (this.fm != null) {
            return this.fm.getHeight();
        }
        return 30;
    }

    protected int preferredWidth() {
        if (this.fm != null) {
            return this.columns * this.fm.charWidth('N');
        }
        return this.columns * 10;
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            super.addNotify();
            this.setFm();
        }
        this.window = BWTUtil.getWindow(this);
        this.enable11Events(32L);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            if (n == this.location().x && n2 == this.location().y && n3 == this.size().width && n4 == this.size().height) {
                Object var6_6 = null;
                return;
            }
        }
        super.reshape(n, n2, n3, n4);
        jCTextComponent = this;
        synchronized (jCTextComponent) {
            if (this.getPeer() != null) {
                if (this.first && this.show_cursor) {
                    this.showPosition(this.cursor_pos);
                }
                this.first = false;
            }
            return;
        }
    }

    public void repaint() {
        if (!this.isFrozen()) {
            super.repaint();
            this.needs_repaint = false;
            return;
        }
        this.needs_repaint = true;
    }

    void setSelectedBg(Graphics graphics) {
        graphics.setColor(this.selected_bg != null ? this.selected_bg : this.getForeground());
    }

    void setSelectedFg(Graphics graphics) {
        graphics.setColor(this.selected_fg != null ? this.selected_fg : this.getBackground());
    }

    public abstract int pointToPosition(int var1, int var2);

    protected Point positionToPoint(int n, Point point) {
        if (point != null) {
            point.x = this.positionToX(n);
            point.y = this.positionToY(n);
            return null;
        }
        return new Point(this.positionToX(n), this.positionToY(n));
    }

    protected void repaintPositions(int n, int n2) {
        if (n == n2) {
            return;
        }
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            this.positionToPoint(n, p1);
            this.positionToPoint(n2, p2);
        }
        this.repaintPositions(p1, p2);
    }

    protected synchronized void repaintPositions(Point point, Point point2) {
        if (point.equals(point2)) {
            return;
        }
        point.x -= this.horiz_origin;
        point2.x -= this.horiz_origin;
        int n = Math.min(point.x, point2.x);
        int n2 = Math.min(point.y, point2.y);
        Graphics graphics = this.getGraphics();
        this.repaint(graphics, n, n2, Math.max(point.x, point2.x) - n, Math.max(point.y, point2.y) - n2 + this.fm.getHeight());
        graphics.dispose();
    }

    public void beep() {
        this.getToolkit().beep();
    }

    public boolean pasteFromClipboard(Event event) {
        if (!this.editable) {
            return false;
        }
        this.deleteSelection();
        String string = this.readClipboard();
        if (this.overstrike) {
            this.replaceRange(string, this.cursor_pos, this.cursor_pos + string.length());
        } else {
            this.insert(string, this.cursor_pos);
        }
        return true;
    }

    protected synchronized void writeClipboard(String string) {
        if (this.TRACE) {
            System.out.println("Writing to clipboard");
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.getText().substring(this.select_start, this.select_end));
        clipboard.setContents(stringSelection, stringSelection);
    }

    protected String readClipboard() {
        String string;
        block3: {
            string = null;
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) break block3;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public void cutToClipboard(Event event) {
        if (this.select_start < this.select_end) {
            this.copyToClipboard(event);
            this.deleteSelection();
        }
    }

    public void copyToClipboard(Event event) {
        if (this.select_start < this.select_end) {
            this.writeClipboard(this.getText().substring(this.select_start, this.select_end));
        }
    }

    protected int getSelectionType(int n) {
        int n2 = Math.max(0, Math.min(this.select_list.length - 1, n - 1));
        return this.select_list[n2];
    }

    void startAction(Event event) {
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            ++this.action_count;
            if (this.action_count > 1) {
                Object var3_3 = null;
                return;
            }
            this.last_event = event;
        }
        this.paintCursor(false);
        this.paint_cursor = false;
        this.blinkCursor(false);
        this.freeze();
    }

    void endAction() {
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            if (this.action_count > 0) {
                --this.action_count;
                if (this.action_count > 0) {
                    Object var2_2 = null;
                    return;
                }
            }
            this.paint_cursor = true;
            this.last_event = null;
            this.unfreeze();
        }
        if (this.needs_repaint) {
            this.repaint();
        }
        this.updateScrollbars();
        if (this.show_cursor) {
            this.showPosition(this.cursor_pos);
        }
        this.paintCursor(true);
        this.blinkCursor(true);
    }

    protected void selectStart(Event event) {
        int n;
        this.startAction(event);
        this.select_anchor = n = this.pointToPosition(event.x, event.y);
        this.selection_type = this.getSelectionType(event.clickCount);
        this.select(n, n, this.selection_type);
        this.setCursorPosition(n);
        this.endAction();
    }

    protected void selectExtend(Event event) {
        this.startAction(event);
        int n = this.pointToPosition(event.x, event.y);
        this.select(this.select_anchor, n, this.selection_type);
        this.setCursorPosition(n);
        this.endAction();
    }

    protected void selectEnd(Event event) {
        this.startAction(event);
        this.setCursorPosition(this.select_start);
        this.endAction();
    }

    protected void paste(Event event) {
        this.startAction(event);
        this.setCursorPosition(this.pointToPosition(event.x, event.y));
        this.pasting = true;
        boolean bl = this.pasteFromClipboard(event);
        this.endAction();
        if (!bl) {
            this.beep();
            return;
        }
        this.changed = true;
    }

    protected void freeze() {
        ++this.disabled_repaint_count;
    }

    protected void unfreeze() {
        if (this.disabled_repaint_count > 0) {
            --this.disabled_repaint_count;
        }
    }

    protected boolean isFrozen() {
        return this.disabled_repaint_count != 0;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        super.mouseDown(event, n, n2);
        if (BWTUtil.getMouseButton(event) == 2) {
            this.paste(event);
            return true;
        }
        if (BWTUtil.getMouseButton(event) == 3) {
            this.createPopup(this, n, n2);
        } else {
            if (BWTUtil.getMouseButton(event) != 1) {
                return false;
            }
            if (event.shiftDown()) {
                this.selectExtend(event);
            } else {
                this.selectStart(event);
            }
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.pasting) {
            return true;
        }
        this.selectExtend(event);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (BWTUtil.getMouseButton(event) == 3) {
            return false;
        }
        if (!this.pasting) {
            this.selectEnd(event);
        }
        this.pasting = false;
        return true;
    }

    protected void scrollHome(Event event) {
        if (event.shiftDown()) {
            if (this.select_start != this.select_end && this.cursor_pos > this.select_start) {
                this.select(0, this.select_start, 1);
            } else {
                this.select(0, this.select_end, 1);
            }
        } else {
            this.select(0);
        }
        this.setCursorPosition(0);
    }

    protected void scrollEnd(Event event) {
        if (event.shiftDown()) {
            if (this.select_start != this.select_end && this.cursor_pos < this.select_end) {
                this.select(this.select_end, this.num_char, 1);
            } else {
                this.select(this.select_start, this.num_char, 1);
            }
        } else {
            this.select(this.num_char);
        }
        this.setCursorPosition(this.num_char);
    }

    protected void scrollLineEnd(Event event) {
        this.scrollEnd(event);
    }

    protected void scrollLineBegin(Event event) {
        this.scrollHome(event);
    }

    protected void moveForwardChar(Event event) {
        if (this.cursor_pos == this.num_char) {
            return;
        }
        this.startAction(event);
        if (event.shiftDown()) {
            int n = this.select_start;
            int n2 = this.select_end;
            int n3 = this.cursor_pos < n2 ? (n = Math.min(this.num_char, n + 1)) : (n2 = Math.min(this.num_char, n2 + 1));
            this.setCursorPosition(n3);
            this.select(n, n2, 0);
        } else {
            this.select(this.cursor_pos + 1);
        }
        this.endAction();
    }

    protected void moveBackwardChar(Event event) {
        if (this.cursor_pos == 0) {
            return;
        }
        this.startAction(event);
        if (event.shiftDown()) {
            int n = this.select_start;
            int n2 = this.select_end;
            int n3 = this.cursor_pos > n ? (n2 = Math.max(0, n2 - 1)) : (n = Math.max(0, n - 1));
            this.select(n, n2, 0);
            this.setCursorPosition(n3);
        } else {
            this.select(this.cursor_pos - 1);
        }
        this.endAction();
    }

    protected boolean insertChar(Event event, int n) {
        if (!this.editable) {
            return false;
        }
        this.startAction(event);
        char[] cArray = new char[]{(char)n};
        int n2 = this.cursor_pos;
        int n3 = this.cursor_pos;
        if (this.select_end > this.select_start) {
            n2 = this.select_start;
            n3 = this.select_end;
        }
        if (this.overstrike && n3 < this.num_char) {
            ++n3;
        }
        if (this.replaceRangeInternal(new String(cArray), n2, n3)) {
            this.changed = true;
        }
        this.endAction();
        return true;
    }

    protected boolean deleteChar(Event event, boolean bl) {
        if (!this.editable) {
            return false;
        }
        boolean bl2 = false;
        this.startAction(event);
        if (this.select_start < this.select_end) {
            bl2 = this.deleteRange(this.select_start, this.select_end);
        } else if (!bl && this.cursor_pos > 0) {
            bl2 = this.deleteRange(this.cursor_pos - 1, this.cursor_pos);
        } else if (bl && this.cursor_pos < this.num_char) {
            bl2 = this.deleteRange(this.cursor_pos, this.cursor_pos + 1);
        }
        if (bl2) {
            this.changed = true;
        }
        this.endAction();
        return true;
    }

    protected boolean deletePreviousChar(Event event) {
        return this.deleteChar(event, false);
    }

    protected boolean deleteCurrentChar(Event event) {
        return this.deleteChar(event, true);
    }

    protected void toggleOverstrike(Event event) {
        this.overstrike = !this.overstrike;
    }

    public boolean keyDown(Event event, int n) {
        boolean bl = true;
        boolean bl2 = true;
        this.last_event = event;
        if (this.TRACE) {
            System.out.println("keyDown(" + event + ", " + n + ")");
        }
        if (event.controlDown()) {
            if (this.cmpKeyStroke("HomeKey", n)) {
                this.scrollLineBegin(event);
            } else if (this.cmpKeyStroke("CopyKey", n)) {
                this.copyToClipboard(event);
            } else if (this.cmpKeyStroke("DeleteKey", n)) {
                bl = this.deleteCurrentChar(event);
            } else if (this.cmpKeyStroke("EndKey", n)) {
                this.scrollLineEnd(event);
            } else if (this.cmpKeyStroke("BackSpaceKey", n)) {
                bl = this.deletePreviousChar(event);
            } else if (this.cmpKeyStroke("OverStrikeKey", n)) {
                this.toggleOverstrike(event);
            } else if (this.cmpKeyStroke("CutKey", n)) {
                this.cutToClipboard(event);
            } else if (this.cmpKeyStroke("PasteKey", n)) {
                bl = this.pasteFromClipboard(event);
            } else if (n == 1000) {
                this.scrollHome(event);
            } else if (n == 1001) {
                this.scrollEnd(event);
            } else {
                bl2 = false;
            }
        } else if (n == 1007) {
            this.moveForwardChar(event);
        } else if (n == 1006) {
            this.moveBackwardChar(event);
        } else if (n == 8) {
            bl = this.deletePreviousChar(event);
        } else if (n == 127) {
            bl = this.deleteCurrentChar(event);
        } else if (n == 1000) {
            this.scrollLineBegin(event);
        } else if (n == 1001) {
            this.scrollLineEnd(event);
        } else if (n == 9) {
            bl2 = false;
        } else if (event.id != 403) {
            bl = this.insertChar(event, n);
        } else {
            bl2 = false;
        }
        if (!bl) {
            this.beep();
        }
        this.last_event = null;
        if (bl2) {
            return true;
        }
        return super.keyDown(event, n);
    }

    protected void createPopup(Component component, int n, int n2) {
        if (this.popup_menu != null) {
            this.remove(this.popup_menu);
        }
        this.popup_menu = new PopupMenu();
        boolean bl = false;
        boolean bl2 = false;
        if (this.TRACE) {
            System.out.println("   select_start = " + this.select_start);
            System.out.println("   select_end = " + this.select_end);
            System.out.println("   num_char = " + this.num_char);
        }
        if (this.select_start == 0 && this.select_end + 1 >= this.num_char && this.num_char != 0) {
            bl = true;
        }
        if (this.select_start == this.select_end || this.num_char == 0) {
            bl2 = true;
        }
        MenuItem menuItem = new MenuItem(this.li.getString("Cut"));
        if (bl2) {
            menuItem.setEnabled(false);
        } else {
            menuItem.addActionListener(new Cut());
        }
        this.popup_menu.add(menuItem);
        menuItem = new MenuItem(this.li.getString("Copy"));
        if (bl2) {
            menuItem.setEnabled(false);
        } else {
            menuItem.addActionListener(new Copy());
        }
        this.popup_menu.add(menuItem);
        menuItem = new MenuItem(this.li.getString("Paste"));
        menuItem.addActionListener(new Paste());
        this.popup_menu.add(menuItem);
        menuItem = new MenuItem(this.li.getString("Delete"));
        if (bl2) {
            menuItem.setEnabled(false);
        } else {
            menuItem.addActionListener(new Delete());
        }
        this.popup_menu.add(menuItem);
        this.popup_menu.addSeparator();
        menuItem = new MenuItem(this.li.getString("SelectAll"));
        if (bl || this.num_char == 0) {
            menuItem.setEnabled(false);
        } else {
            menuItem.addActionListener(new SelectAll());
        }
        this.popup_menu.add(menuItem);
        this.add(this.popup_menu);
        this.popup_menu.show(component, n, n2);
    }

    protected boolean cmpKeyStroke(String string, int n) {
        Integer n2 = (Integer)this.li.getObject(string);
        if (this.TRACE) {
            System.out.println("cmpKeyStroke(" + string + ", " + n + ")");
            System.out.println("             cmpkey = " + n2);
        }
        if (n2 == null) {
            return false;
        }
        return n2 == n;
    }

    protected void blinkCursor(boolean bl) {
        if (!(this.has_focus && this.display_cursor && this.isEnabled())) {
            return;
        }
        JCTextComponent jCTextComponent = this;
        synchronized (jCTextComponent) {
            if (bl) {
                if (this.cursor_thread != null && this.cursor_thread.isAlive()) {
                    Object var3_3 = null;
                    return;
                }
                this.cursor_thread = new Thread(this);
                if (JCEnvironment.getBrowser(this) != 3) {
                    this.cursor_thread.setPriority(1);
                }
                if (this.cursor_thread != null && !this.cursor_thread.isAlive()) {
                    this.cursor_thread.start();
                }
            } else if (this.cursor_thread != null && this.cursor_thread.isAlive()) {
                try {
                    Thread.yield();
                    this.cursor_thread.stop();
                    this.paintCursor(false);
                    this.cursor_thread = null;
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    public boolean gotFocus(Event event, Object object) {
        boolean bl = super.gotFocus(event, object);
        this.setFm();
        if (bl) {
            this.blinkCursor(true);
        }
        return bl;
    }

    public boolean lostFocus(Event event, Object object) {
        this.blinkCursor(false);
        return super.lostFocus(event, object);
    }

    public synchronized void disable() {
        if (this.isEnabled()) {
            this.blinkCursor(false);
            super.disable();
        }
    }

    public abstract Dimension getMinimumSize(int var1);

    public class Cut
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            JCTextComponent.this.cutToClipboard(null);
        }

        public Cut() {
            JCTextComponent.this = JCTextComponent.this;
        }
    }

    public class Copy
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            JCTextComponent.this.copyToClipboard(null);
        }

        public Copy() {
            JCTextComponent.this = JCTextComponent.this;
        }
    }

    public class Paste
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            JCTextComponent.this.pasteFromClipboard(null);
        }

        public Paste() {
            JCTextComponent.this = JCTextComponent.this;
        }
    }

    public class Delete
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            JCTextComponent.this.deleteSelection();
        }

        public Delete() {
            JCTextComponent.this = JCTextComponent.this;
        }
    }

    public class SelectAll
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            JCTextComponent.this.selectAll();
        }

        public SelectAll() {
            JCTextComponent.this = JCTextComponent.this;
        }
    }
}

