#!/bin/sh
# restore.sh - stage all the directories and files that were online at
# the time of the dump of the .inodes file back online.
#
# $1 is the logfile generated by the samfsrestore -g option, 
# $2 is the mount_point.
#
# logfile format generated by samfsrestore:
# type mt.vsn position.offset status path
#
# restore.sh logfile /mount_point

if [ x$1 = x ]; then
	echo usage logfile /mount_point
	exit 1
fi
if [ x$2 = x ]; then
	echo usage logfile /mount_point
	exit 1
fi

cat << /EOS > /tmp/$$.awk
#
# nawk script to extract type and file path
# skip symbolic links and put single quotes around file path in case it
# contains spaces
# Note:  will not work for filenames containing two or more consecutive spaces
# Note:  the awk variables must be escaped.  $2 is a shell variable (mountpoint)
#
 \$1 != "S"  { 
    if ( \$5 !~ /[^0-9]/ ) {
#       it's an inode number
        print \$4,  \$5
    } else {
#       it's a relative path - may contain spaces
#       strip "./" from path
        sub(/\.\//, "")
        fullfile = \$5;
        if ( NF > 5 ) {
            for (i = 6; i <= NF; i++) fullfile = fullfile " " \$i
            print \$4, "\""  "$2" "/" fullfile "\""
        } else {
            print \$4, "$2" "/" fullfile
        }
    }
}
/EOS
/bin/sort -f -k 1,3 -k 4,4n $1 | /bin/nawk -f /tmp/$$.awk > $1.1

while read partial inum
do
	echo $inum | grep "[^0-9]" > /dev/null

#   if inum is numeric, it's an inode number;  else it's a full path

	if [ $? != 0 ]; then
# samncheck output is tab separated; strip the inode.gid number.
		path=`/opt/SUNWsamfs/sbin/samncheck $2 $inum | /bin/cut -f 2`
	else
		path=$inum
	fi
	if [ $partial = "partial" ]; then
    	echo stage -p $path
		eval /opt/SUNWsamfs/bin/stage -p $path
	else
    	echo stage $path
		eval /opt/SUNWsamfs/bin/stage $path
	fi
done  < $1.1
/bin/rm $1.1 /tmp/$$.awk
