#!/bin/sh

# $Id: stageback.sh,v 1.1.2.2 2002/04/24 01:13:13 grm Exp $
#
# stage from archive_audit output
#
# stage each file, set it to no-release, and
# optionally mark it for rearchive.
#

cat << /EOF > /tmp/$$.awk
{
#       it's a full path - may contain spaces

    fullfile = \$8;
    if ( NF > 8 ) {
        for (i = 8; i <= NF; i++) fullfile = fullfile " " \$i
        print "\"" fullfile "\""
    } else {
        print fullfile
    }
}
/EOF

/bin/sort -f -k 6,6n $1 | /bin/nawk -f /tmp/$$.awk > $1.1

while read file
do
    echo stage $file
    eval /opt/SUNWsamfs/bin/stage $file
    echo release -n $file
    eval /opt/SUNWsamfs/bin/release -n $file
#    echo rearch  $file
#
#   Edit the following line for the correct media type and VSN
#
#    eval /opt/SUNWsamfs/bin/rearch -m MEDIA -v VSN $file
done < $1.1
echo " "
echo "Done staging files."
/bin/rm $1.1 /tmp/$$.awk
