#!/bin/sh

#
#  upfrom350.sh  - convert files and paths from SAM-FS 3.5.0 style
#

ETCDIR=/etc/opt/SUNWsamfs
VARDIR=/var/opt/SUNWsamfs
CAT_DIR=$VARDIR/catalog
NEW_EXE=/opt/SUNWsamfs/sbin

OLDETC=/etc/opt/LSCsamfs
OLDVAR=/var/opt/LSCsamfs
OLDCAT=$OLDVAR/catalog
OLDEXE=/opt/LSCsamfs/sbin

#  Function definitions.

#  copy old config files to their new locations if present.

copy_conf()
{
	if [ -f $2/$1 ]; then
		if [ ! -f $3/$1 ]; then
			/bin/cp $2/$1 $3/$1
		fi
	fi
}

#  copy catalogs to their new locations.

copy_cat()
{
	cat_file=`/bin/basename $cat`
	# quick check if it is some non-expected place
	echo $cat | grep '/' > /dev/null
	if [ $? -ne 0 ] ; then
		# this catalog should be moved to the (new) catalog dir
		if [ -f $OLDCAT/$cat_file ] ; then
			if [ -f ${CAT_DIR}/$cat_file ] ; then
				/bin/cp $OLDCAT/$cat_file $CAT_DIR/${cat_file}.350
			else
				/bin/cp $OLDCAT/$cat_file $CAT_DIR
			fi
		fi
	fi
}

#  main script.

# copy files that work without conversion unless already there

SAVELIST="mcf defaults.conf \
  archiver.cmd preview.cmd recycler.cmd releaser.cmd samfs.cmd"

	for object in $SAVELIST
	do
		copy_conf $object $OLDETC $ETCDIR
	done

	copy_conf ReservedVSNs ${OLDVAR}/archiver ${VARDIR}/archiver 
	copy_conf dev_down.sh  ${OLDEXE}  ${NEW_EXE}
	
	# copy files that need conversion

CHGLIST="archiver.sh recycler.sh ssi.sh"

	for object in $CHGLIST
	do
		if [ -f ${OLDEXE}/${object} ] ; then
			/usr/bin/cp ${OLDEXE}/${object} $NEW_EXE/${object}.350
			echo "WARNING: old "${object}" saved as "$NEW_EXE/${object}.350
			echo "WARNING: Make any local changes in the new version."
		fi
	done

#   move library catalogs.

	found_hist=0
	exec <$ETCDIR/mcf
	while read eqid eqord eqtype famset state cat
	do
		case $eqid in
		\#*)
			continue
			;;
		esac

		if [ X = X$cat ]; then
			cat=$famset
		fi

		# copy the catalogs to their new locations.
	
		case $eqtype in
		rb|hp|ml|cy|dm|ds|me|ac|eb|ad|a1|a2|sl|s9|ic|pd|ae|as|a3|e8|hc|q8|sn|il)
			copy_cat
			;;

		fj|gr|im|sk|sc|pe)
			copy_cat

			# copy the network robot and remote sam configuration files.
			nrcon=`/usr/bin/basename $eqid`
			if [ -f ${OLDVAR}/${nrcon} ] ; then
				/usr/bin/cp ${OLDVAR}/${nrcon} $VARDIR/${nrcon}
			echo "Network or remote "$famset" configuration file "${nrcon}" saved."
			fi
			;;

		ss)
			# copy the remote sam configuration files.
			nrcon=`/usr/bin/basename $eqid`
			if [ -f ${OLDVAR}/${nrcon} ] ; then
				/usr/bin/cp ${OLDVAR}/${nrcon} $VARDIR/${nrcon}
			echo "Remote "$famset" configuration file "${nrcon}" saved."
			fi
			;;

		'hy')
			copy_cat
			found_hist=1
			;;

		default)
			;;
		esac
	done

	if [ $found_hist -eq 0 ] ; then
		copy_conf historian $OLDCAT $CAT_DIR
	fi
