/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

public class JCStringTokenizer {
    private int index;
    private String string;
    private int length;
    private boolean count = false;
    public boolean strip_esc = true;
    private char[] token;

    public JCStringTokenizer(String string) {
        if (string != null) {
            this.string = string.trim();
            this.length = this.string.length();
        }
    }

    public static String[] parse(String string, char c) {
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String[] stringArray = new String[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = jCStringTokenizer.nextToken(c);
            ++n;
        }
        return stringArray;
    }

    public String nextToken() {
        if (this.string == null || this.index >= this.length) {
            return null;
        }
        int n = this.index;
        while (n < this.length && Character.isSpace(this.string.charAt(n))) {
            ++n;
        }
        this.index = n;
        if (n >= this.length) {
            return null;
        }
        if (!this.count) {
            this.token = new char[this.length + 1];
        }
        n = this.index;
        int n2 = 0;
        while (n < this.length) {
            if (Character.isSpace(this.string.charAt(n))) break;
            if (!this.count) {
                this.token[n2++] = this.string.charAt(n);
            }
            ++n;
        }
        this.index = n + 1;
        if (!this.count) {
            return new String(this.token).trim();
        }
        return null;
    }

    public String nextToken(char c) {
        if (this.string == null || this.index >= this.length) {
            return null;
        }
        if (!this.count) {
            this.token = new char[this.length + 1];
        }
        int n = this.index;
        int n2 = 0;
        while (n < this.length) {
            if (n + 1 < this.length && this.string.charAt(n) == '\\') {
                if (!this.strip_esc) {
                    if (this.token != null) {
                        this.token[n2++] = this.string.charAt(n);
                        this.token[n2] = this.string.charAt(++n);
                    }
                } else {
                    ++n;
                    if (!this.count) {
                        this.token[n2] = this.string.charAt(n) == 'n' ? 10 : this.string.charAt(n);
                    }
                }
            } else {
                if (this.string.charAt(n) == c) break;
                if (!this.count) {
                    this.token[n2] = this.string.charAt(n);
                }
            }
            ++n;
            ++n2;
        }
        this.index = n + 1;
        if (!this.count && n2 > 0) {
            return new String(this.token, 0, n2);
        }
        return null;
    }

    public int countTokens(char c) {
        int n = this.index;
        this.count = true;
        int n2 = 0;
        while (this.index < this.length) {
            this.nextToken(c);
            ++n2;
        }
        this.index = n;
        this.count = false;
        return n2;
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    public int getPosition() {
        return this.index;
    }
}

