/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import jclass.bwt.JCMultiColumnList;
import jclass.bwt.JCMultiColumnListComponent;
import sam.gui.DialogBox;
import sam.gui.GUIManager;
import sam.gui.dialog.FSDialog;
import sam.gui.event.RowListener;
import sam.gui.popup.TableEntryPopUp;
import sam.model.MassStorage;
import sam.model.Table;
import sam.resource.ResourceManager;

public class FSMgrDisplay
extends Panel
implements MouseListener,
RowListener,
Observer {
    private static final String[] columnHeaders = new String[]{"Family set", "Mount point", "% Full"};
    private static final int[] columnAlignments = new int[]{5, 5, 5};
    private static final String[] defaultHeaders = new String[]{"Family set", "Mount point", "% Full"};
    private MassStorage[] filesystems;
    private JCMultiColumnList table;
    private Vector rowHandlers = new Vector();
    private Hashtable entryList = new Hashtable();
    private TableEntryPopUp entryPopup;
    private Table dataTable;
    private String[] headers;

    private void setHeaderRow(String[] stringArray, String[] stringArray2, int[] nArray) {
        this.headers = stringArray;
        String[] stringArray3 = new String[this.headers.length];
        int[] nArray2 = new int[this.headers.length];
        int n = 0;
        while (n < this.headers.length) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].equals(this.headers[n])) {
                    nArray2[n] = nArray[n2];
                    break;
                }
                ++n2;
            }
            if (n2 == stringArray2.length) {
                System.err.println(String.valueOf(ResourceManager.getString("Unknown column header")) + ":" + this.headers[n]);
            }
            stringArray3[n] = ResourceManager.getString(this.headers[n]);
            ++n;
        }
        this.table.setColumnButtons(stringArray3);
        this.table.setColumnAlignments(nArray2);
    }

    private void defineHeaders() {
        String[] stringArray = defaultHeaders;
        this.setHeaderRow(stringArray, columnHeaders, columnAlignments);
    }

    public DialogBox getDialogBox() {
        return null;
    }

    public void refresh() {
        if (!this.table.getBatched()) {
            return;
        }
        this.table.setBatched(false);
    }

    private void addAllRows() {
        try {
            if (this.filesystems != null) {
                int n = 0;
                while (n < this.filesystems.length) {
                    this.addRow(this.filesystems[n]);
                    this.filesystems[n].addObserver(this);
                    ++n;
                }
                return;
            }
        }
        catch (Exception exception) {}
    }

    private Vector buildRow(MassStorage massStorage) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(massStorage.getName());
        if (massStorage.isMounted()) {
            vector.addElement(massStorage.getMountPath());
            vector.addElement(new Integer(massStorage.getPercentageFull()));
        } else {
            vector.addElement(" ");
            vector.addElement(" ");
        }
        return vector;
    }

    private void addRow(MassStorage massStorage) {
        Vector vector = this.buildRow(massStorage);
        this.addDisplayRow(massStorage, vector);
        this.refresh();
    }

    private void removeRow(int n, MassStorage massStorage) {
        Vector vector = (Vector)this.table.getItem(n);
        this.removeDisplayRow(n);
        this.entryList.remove(vector);
        this.refresh();
    }

    private void updateRow(int n, MassStorage massStorage) {
        Vector vector = this.buildRow(massStorage);
        this.updateDisplayRow(n, massStorage, vector);
        this.refresh();
    }

    private Vector buildDisplayRow(Vector vector) {
        Vector vector2 = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            vector2.addElement(e);
            ++n;
        }
        return vector2;
    }

    private void notifyRowListeners(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        if (this.rowHandlers.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.rowHandlers.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                ((RowListener)enumeration.nextElement()).rowRightClicked(mouseEvent);
                continue;
            }
            if (bl2) {
                ((RowListener)enumeration.nextElement()).rowDoubleClicked(mouseEvent);
                continue;
            }
            ((RowListener)enumeration.nextElement()).rowClicked(mouseEvent);
        }
    }

    public synchronized void addDisplayRow(MassStorage massStorage, Vector vector) {
        Vector vector2 = this.buildDisplayRow(vector);
        this.table.setBatched(true);
        this.table.addItem((Object)vector2);
        this.entryList.put(massStorage, vector2);
    }

    public synchronized void removeDisplayRow(int n) {
        if (n < 0) {
            return;
        }
        this.table.setBatched(true);
        this.table.deleteItem(n);
    }

    public synchronized boolean updateDisplayRow(int n, MassStorage massStorage, Vector vector) {
        Vector vector2 = this.buildDisplayRow(vector);
        this.table.setBatched(true);
        this.table.replaceItem((Object)vector2, n);
        this.entryList.put(massStorage, vector2);
        return true;
    }

    public synchronized int findRow(MassStorage massStorage) {
        int n = -1;
        Vector vector = (Vector)this.entryList.get(massStorage);
        int n2 = 0;
        while (n2 < this.table.countItems()) {
            if (vector == this.table.getItem(n2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public synchronized MassStorage findFilesystem(Vector vector) {
        if (vector == null) {
            return null;
        }
        Enumeration<Object> enumeration = this.entryList.elements();
        int n = 0;
        try {
            while (enumeration.hasMoreElements()) {
                ++n;
                if (vector == (Vector)enumeration.nextElement()) break;
            }
            enumeration = this.entryList.keys();
            MassStorage massStorage = null;
            int n2 = 0;
            while (n2 < n) {
                massStorage = (MassStorage)enumeration.nextElement();
                ++n2;
            }
            return massStorage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector getRow(MouseEvent mouseEvent) {
        return (Vector)((JCMultiColumnListComponent)mouseEvent.getComponent()).getSelectedItem();
    }

    public void addRowListener(RowListener rowListener) {
        this.rowHandlers.addElement(rowListener);
    }

    public void removeRowListener(RowListener rowListener) {
        this.rowHandlers.removeElement(rowListener);
    }

    public void rowClicked(MouseEvent mouseEvent) {
    }

    public void rowRightClicked(MouseEvent mouseEvent) {
    }

    public void rowDoubleClicked(MouseEvent mouseEvent) {
        FSDialog fSDialog;
        MassStorage massStorage = this.findFilesystem(FSMgrDisplay.getRow(mouseEvent));
        if (massStorage != null && (fSDialog = new FSDialog(this, massStorage)) != null) {
            fSDialog.show();
        }
    }

    public void update(Observable observable, Object object) {
        MassStorage massStorage = (MassStorage)observable;
        int n = this.findRow(massStorage);
        if (n < 0) {
            this.addRow(massStorage);
        }
        this.updateRow(n, massStorage);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = mouseEvent.getClickCount() > 1;
        boolean bl2 = mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 8;
        this.notifyRowListeners(mouseEvent, bl2, bl);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public FSMgrDisplay(MassStorage[] massStorageArray) {
        this.filesystems = massStorageArray;
        this.setLayout(new GridLayout(1, 1));
        this.setBackground(Color.lightGray);
        int n = this.filesystems.length;
        if (n == 0) {
            n = 1;
        } else if (n > 4) {
            n = 4;
        }
        this.table = new JCMultiColumnList(n, false);
        this.table.getList().setBackground(Color.white);
        this.table.setSpacing(5);
        this.table.setRowHeight(20);
        this.table.setBackground(Color.lightGray);
        this.table.setFont(new Font("Monospaced", 0, GUIManager.getFontPointSize(2)));
        this.table.getList().addMouseListener(this);
        this.add((Component)this.table);
        this.defineHeaders();
        this.addAllRows();
        this.addRowListener(this);
    }
}

