/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import sam.gui.GridManager;
import sam.gui.MailBoxDisplay;
import sam.gui.RobotDisplay;
import sam.gui.event.SelectionListener;
import sam.model.Robot;

public class RobotMgrDisplay
extends Panel
implements SelectionListener {
    private static final int INS_PIXELS = 5;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridManager robotsPanel;
    private Panel mailboxPanel;
    private Robot currentRobot;

    public Dimension getPreferredSize() {
        try {
            Dimension dimension = this.robotsPanel.getPreferredSize();
            dimension = new Dimension(dimension.width + 10, dimension.height + 10);
            return dimension;
        }
        catch (Exception exception) {
            return new Dimension(-1, -1);
        }
    }

    public void addRobotSelectionListener(SelectionListener selectionListener) {
        this.robotsPanel.addSelectionListener(selectionListener);
    }

    public void removeRobotSelectionListener(SelectionListener selectionListener) {
        this.robotsPanel.removeSelectionListener(selectionListener);
    }

    public void selected(Panel panel) {
        Robot robot = (Robot)((RobotDisplay)panel).getDevice();
        if (this.currentRobot != robot) {
            this.currentRobot = robot;
        }
    }

    public void addRobot(Robot robot) {
        RobotDisplay robotDisplay = new RobotDisplay(robot);
        this.robotsPanel.addPanel(robotDisplay);
        if (this.currentRobot == null) {
            this.currentRobot = robot;
        }
    }

    public Robot getCurrentRobot() {
        return this.currentRobot;
    }

    private void displayMailbox() {
        this.mailboxPanel.removeAll();
        if (this.currentRobot.hasMailbox()) {
            MailBoxDisplay mailBoxDisplay = new MailBoxDisplay(this.currentRobot);
            this.mailboxPanel.add(mailBoxDisplay);
        }
        this.mailboxPanel.invalidate();
        this.mailboxPanel.validate();
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    RobotMgrDisplay(int n) {
        this.setLayout(this.gridbag);
        this.setBackground(Color.lightGray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.robotsPanel = new GridManager(1, n);
        this.addRobotSelectionListener(this);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        this.gridbag.setConstraints(this.robotsPanel, gridBagConstraints);
        this.add(this.robotsPanel);
        this.mailboxPanel = new Panel();
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 0;
        this.gridbag.setConstraints(this.mailboxPanel, gridBagConstraints);
        this.add(this.mailboxPanel);
    }
}

