#!/bin/csh -f
# archiver.sh - template shell for processing archiver exceptional events.
# $Id: archiver.sh,v 1.1.2.1 2002/04/24 01:13:17 grm Exp $
#
# args:
#	1) calling program name
#	2) calling program pid
#	3) keyword identifying the 'syslog' level of the event.
# 		The keywords are:
# 		emerg, alert, crit, err, warning, notice, info, debug
#	4) message number from the message catalog.
#	5) the actual message.
#
#

##set noglob
set novsnsdir = /var/opt/SUNWsamfs/archiver/NoVsns
set nospacedir = /var/opt/SUNWsamfs/archiver/NoSpace

switch ($3)
	case emerg:
	case alert:
	case crit:
	case err:
#   These lines inform "root" that a serious error occured.
mail root <</eof
The SAM-FS $1 detected a level "${3}" exception condition.
Message number ${4}:
${5}
/eof
		breaksw


    case warning:

# The messages 4010, 4011, 4013, 4014, and 4015 are repeated each time the
# archiver scans a filesystem.
# To suppress repeated messages, the following script segments are executed.
# Files named for the archive sets are created.
# When some event occurs that fixes the lack of VSNs or space, remove the
# appropriate file to reenable the messages.

		# No VSNs available for Archive Set
		if ($4 == 4010) then
			# Get archive set name
			set msg=($5)
			set archset=$msg[7]
			# Check file for it
			if (-e ${novsnsdir}/${archset}) exit
			if (! -d ${novsnsdir}) then
				rm -f ${novsnsdir}
				mkdir ${novsnsdir}
			endif
			touch ${novsnsdir}/${archset}
		endif

		# No space available for Archive Set
		if ($4 == 4011 || $4 == 4013 || $4 == 4014 || $4 == 4015) then
			# Get archive set name
			set msg=($5)
			set archset=$msg[7]
			# Check file for it
			if (-e ${nospacedir}/${archset}) exit
			if (! -d ${nospacedir}) then
				rm -f ${nospacedir}
				mkdir ${nospacedir}
			endif
			touch ${nospacedir}/${archset}
		endif

		# Do not send default message for these, archiver already sent it.
		if ($4 == 4020) then
			#%s[%d] died - Not restarting
			exit
		endif

		if ($4 == 4022) then
			#Cannot create trace file %s
			exit
		endif

		if ($4 == 4023) then
			#Errors in archiver commands - no archiving will be done.
			exit
		endif

        breaksw

	case notice:
	case info:
	case debug:
    default:
		breaksw
endsw

#  The default action is to send the message to syslog

logger -p local7.$3 -t "$1[$2]" $3\($4\) "$5"
