/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;

public class VertexApplet
extends Applet
implements ActionListener,
ImageObserver,
Runnable {
    Button bRead;
    Button bWrite;
    Button bReset;
    Button bMove;
    Button bClear;
    Button bGif;
    Button bOrientation;
    Button bLink;
    Choice cLayout;
    public TextArea taInfo;
    Button bRefresh;
    Panel panel4;
    Panel panel1;
    Panel panel2;
    Panel panel3;
    Panel panel5;
    public TextArea tfInfo;
    public Graph graph;
    public char orientation;
    Thread timer;
    public String circleDevice = "";
    public int zoom;
    String saveURL;
    String webproc;
    String userPassword;
    public static boolean timerOn;
    String urlDetails;
    String urlRefresh;
    String isCustomer;
    public boolean saveLayout = true;
    public String gifDir;
    public int timeRefresh = 60000;
    public float scale = 1.0f;
    public int showLinkHandle;
    public boolean alt;
    public String INC_NODES = ",sw,ho,ve,br,mc,";
    boolean graphicsButton;
    public static int canvas_W;
    Vector gif_names;
    Vector gif_images;
    public boolean gif_flag = false;
    public static int canvas_H;
    public static Font smallFont;
    String browser = "";
    public static boolean statusSumMode;
    public Point zoomPosition = new Point(0, 0);
    public ScrollPane scroll;
    public Edge selectedEdge;
    public Node selectedNode;
    public Node selectedAlign;
    public int selectedZoom;
    public PopupMenu popup;
    public PopupMenu linkPopup;
    public PopupMenu zoomPopup;
    public PopupMenu alignPopup;
    public Canvas CANVAS;
    public String[][] dropMenus;
    public String[][] linkMenus;
    public String[][] alignMenus;
    public int dropMenusCnt;
    public int linkMenusCnt;
    public int alignMenusCnt;
    VCanvas canvas;
    int h;
    int w;

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.canvas.repaint(2L);
        return true;
    }

    public Vector valuesNU(String s, String del) {
        Vector<String> v = new Vector<String>();
        if (s.indexOf(del) > 0) {
            StringTokenizer st = new StringTokenizer(s, del);
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
        } else {
            v.addElement(s);
        }
        return v;
    }

    public String getAppletInfo() {
        return "Topology Viewer: Christian Cadieux: SUN Microsystems 2001";
    }

    public String expandUrl(String source) {
        if (source.substring(0, 1).equals("/")) {
            String s = this.getDocumentBase().toString();
            int i = s.lastIndexOf("/");
            source = String.valueOf(s.substring(0, i)) + source;
        } else if (source.substring(0, 1).equals("G")) {
            String s = this.getDocumentBase().toString();
            int i = s.lastIndexOf("/");
            source = String.valueOf(s.substring(0, i)) + this.webproc + "?" + source;
        }
        if (!source.substring(0, 4).equals("http")) {
            source = "http://" + source;
        }
        return source;
    }

    public String readFromUrl(String source) {
        Vector objs = new Vector();
        URLConnection conn = null;
        String out = "";
        try {
            String buffer;
            source = this.expandUrl(source);
            URL u = new URL(source);
            conn = u.openConnection();
            conn.setUseCaches(false);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((buffer = in.readLine()) != null) {
                out = String.valueOf(out) + "\n" + buffer;
            }
            in.close();
        }
        catch (Exception e) {
            this.saveInfo("Error:" + source + ":" + e);
        }
        return out;
    }

    public Vector loadFromUrl(String source) {
        Vector<String> objs = new Vector<String>();
        URLConnection conn = null;
        int cnt = 0;
        try {
            String buffer;
            source = this.expandUrl(source);
            this.saveInfo("Loading:" + source + "...");
            URL u = new URL(source);
            conn = u.openConnection();
            conn.setUseCaches(false);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((buffer = in.readLine()) != null) {
                if (buffer.indexOf("|") < 0) continue;
                objs.addElement(buffer);
                if (buffer.charAt(0) == 'x') continue;
                ++cnt;
            }
            in.close();
        }
        catch (Exception e) {
            this.appendInfo("Error:" + source + ":" + e);
        }
        this.appendInfo(String.valueOf(cnt) + " objects read.");
        return objs;
    }

    public void saveToUrl(String source) {
        URLConnection conn = null;
        OutputStream theControl = null;
        InputStream theData = null;
        if (this.saveURL != null) {
            source = this.expandUrl(this.saveURL);
        } else {
            source = this.expandUrl(source);
            int i1 = source.indexOf("=");
            source = String.valueOf(source.substring(0, i1 - 2)) + "PUT=" + source.substring(i1 + 1) + "&isCustomer=" + this.isCustomer;
        }
        this.saveInfo("Saving:" + source + "...");
        URL u = null;
        try {
            u = new URL(source);
            conn = u.openConnection();
            conn.setRequestProperty("User-Agent", " storade_7654");
            if (this.userPassword != null) {
                String encoding = Base64Converter.encode(this.userPassword.getBytes());
                conn.setRequestProperty("Authorization", "Basic " + encoding);
            }
            conn.setDoOutput(true);
            theControl = conn.getOutputStream();
        }
        catch (Exception e) {
            this.appendInfo("Error opening: " + e);
        }
        int cnt = 0;
        try {
            String line;
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(theControl));
            Object encoded = null;
            int j = this.graph.vertices.size();
            out.write("z=" + this.zoom + "|orient=" + this.orientation + "|\n");
            int k = 0;
            while (k < j) {
                Node v = (Node)this.graph.vertices.elementAt(k);
                ++cnt;
                out.write(String.valueOf(v.toC2()) + "\n");
                ++k;
            }
            out.close();
            theData = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(theData));
            String ans = "";
            while ((line = in.readLine()) != null) {
                ans = String.valueOf(ans) + line;
            }
            this.appendInfo(ans);
            in.close();
        }
        catch (Exception e) {
            this.appendInfo("Error on post " + e);
        }
    }

    public void updateObjectsStatus(Vector objs) {
        int k = 0;
        int x0 = 0;
        while (x0 < objs.size()) {
            boolean maxpos = true;
            boolean maxpos2 = false;
            int no = 1;
            try {
                Vector v = VertexApplet.parseData((String)objs.elementAt(x0), "|");
                no = Integer.parseInt((String)v.elementAt(0));
                String type = (String)v.elementAt(1);
                String category = (String)v.elementAt(2);
                String label = (String)v.elementAt(3);
                String label2 = "";
                String label3 = "";
                Vector vec1 = VertexApplet.parseData(label, ",");
                label = (String)vec1.elementAt(0);
                boolean v1Pos = true;
                boolean v2Pos = true;
                if (type.equals("v")) {
                    String status = (String)v.elementAt(6);
                    String portStatus = (String)v.elementAt(7);
                    String diskStatus = (String)v.elementAt(8);
                    String otherStatus = (String)v.elementAt(9);
                    String encInfo = "";
                    String portInfo = "";
                    String diskInfo = "";
                    String otherInfo = "";
                    if (v.size() > 10) {
                        encInfo = (String)v.elementAt(10);
                        portInfo = (String)v.elementAt(11);
                        diskInfo = (String)v.elementAt(12);
                        otherInfo = (String)v.elementAt(13);
                    }
                    int i = this.graph.vertices.size();
                    boolean found = false;
                    k = 0;
                    while (k < i) {
                        Node vx1 = (Node)this.graph.vertices.elementAt(k);
                        if (vx1.label.equals(label)) {
                            vx1.changeStatus(status, portStatus, diskStatus, otherStatus, encInfo, portInfo, diskInfo, otherInfo);
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        System.out.println("Cannot find " + type + "," + label);
                    }
                }
            }
            catch (Exception e) {
                this.saveInfo("ErrorX in parm " + (x0 + 1) + " " + e);
            }
            ++x0;
        }
    }

    public boolean createObjects(Vector objs) {
        Vector<Object> all = new Vector<Object>();
        this.canvas.deleteAll();
        all.addElement(new Object());
        int x0 = 0;
        while (x0 < objs.size()) {
            int maxpos = 1;
            int maxpos2 = 0;
            int maxpos3 = 0;
            int maxpos4 = 0;
            try {
                String name;
                Vector v = VertexApplet.parseData((String)objs.elementAt(x0), "|");
                String no = (String)v.elementAt(0);
                String type = (String)v.elementAt(1);
                String category = (String)v.elementAt(2);
                if (category.equals("x")) {
                    int n = 2;
                }
                String label = (String)v.elementAt(3);
                String label2 = "";
                String label3 = "";
                String label4 = "";
                String zones = "";
                String color = "F0F0F0";
                String gif = "";
                Vector vec1 = VertexApplet.parseData(label, ",");
                int f1 = (label = (String)vec1.elementAt(0)).indexOf("=");
                if (f1 > 0) {
                    name = label.substring(f1 + 1);
                    label = label.substring(0, f1);
                } else {
                    int ix2 = label.indexOf(":");
                    name = label.substring(ix2 + 1);
                }
                if (vec1.size() >= 2) {
                    label2 = (String)vec1.elementAt(1);
                }
                if (vec1.size() >= 3) {
                    label3 = (String)vec1.elementAt(2);
                }
                if (vec1.size() >= 4) {
                    label4 = (String)vec1.elementAt(3);
                }
                vec1 = VertexApplet.parseData(category, ",");
                category = (String)vec1.elementAt(0);
                int v1Pos = 1;
                int v2Pos = 1;
                String code = "";
                char orientation = 'x';
                String prefix1 = "";
                String prefix2 = "";
                String others = "";
                String longPrefix1 = "";
                String longPrefix2 = "";
                String longOthers = "";
                String prefix3 = "";
                String ctrlNames = "  ";
                String slotName = "disk";
                if (type.equals("v")) {
                    if (vec1.size() > 1) {
                        code = (String)vec1.elementAt(1);
                    }
                    if (category.equals("g")) {
                        maxpos = Integer.parseInt((String)vec1.elementAt(2));
                        maxpos2 = 4;
                        zones = "";
                        color = "404040";
                        if (vec1.size() > 4) {
                            Vector vec2 = VertexApplet.parseData((String)vec1.elementAt(4), "/");
                            color = (String)vec2.elementAt(0);
                            if (vec2.size() == 2) {
                                gif = (String)vec2.elementAt(1);
                            }
                        }
                    } else if (category.equals("s")) {
                        maxpos2 = Integer.parseInt((String)vec1.elementAt(3));
                        zones = (String)vec1.elementAt(2);
                        color = "F0F0C0";
                        if (vec1.size() > 4) {
                            Vector vec2 = VertexApplet.parseData((String)vec1.elementAt(4), "/");
                            color = (String)vec2.elementAt(0);
                            if (vec2.size() == 2) {
                                gif = (String)vec2.elementAt(1);
                            }
                        }
                        if (vec1.size() > 5) {
                            others = (String)vec1.elementAt(5);
                            longOthers = (String)vec1.elementAt(6);
                        }
                        if (vec1.size() > 7) {
                            String ss = (String)vec1.elementAt(7);
                            orientation = ss.charAt(0);
                        }
                    } else if (category.equals("h")) {
                        maxpos = Integer.parseInt((String)vec1.elementAt(2));
                        if (vec1.size() > 4) {
                            Vector vec2 = VertexApplet.parseData((String)vec1.elementAt(4), "/");
                            color = (String)vec2.elementAt(0);
                            if (vec2.size() == 2) {
                                gif = (String)vec2.elementAt(1);
                            }
                        }
                        if (vec1.size() > 5) {
                            others = (String)vec1.elementAt(5);
                            longOthers = (String)vec1.elementAt(6);
                        }
                    } else if (category.equals("a")) {
                        Vector ctrl = VertexApplet.parseData((String)vec1.elementAt(2), "/");
                        maxpos = Integer.parseInt((String)ctrl.elementAt(0));
                        if (ctrl.size() > 1) {
                            ctrlNames = (String)ctrl.elementAt(1);
                        }
                        Vector slots = VertexApplet.parseData((String)vec1.elementAt(3), "/");
                        maxpos2 = Integer.parseInt((String)slots.elementAt(0));
                        if (slots.size() > 1) {
                            slotName = (String)slots.elementAt(1);
                        }
                        String prefix = (String)vec1.elementAt(4);
                        Vector vv = VertexApplet.parseData(prefix, "/");
                        prefix1 = (String)vv.elementAt(0);
                        if (vv.size() > 1) {
                            prefix2 = (String)vv.elementAt(1);
                            maxpos3 = maxpos2;
                        }
                        if (vv.size() > 2) {
                            prefix3 = (String)vv.elementAt(2);
                            maxpos4 = maxpos2;
                        }
                        others = (String)vec1.elementAt(5);
                        longOthers = (String)vec1.elementAt(6);
                        Vector vec2 = VertexApplet.parseData((String)vec1.elementAt(7), "/");
                        color = (String)vec2.elementAt(0);
                        if (vec2.size() == 2) {
                            gif = (String)vec2.elementAt(1);
                        }
                    }
                    int x = Integer.parseInt((String)v.elementAt(4));
                    int y = Integer.parseInt((String)v.elementAt(5));
                    String status = "";
                    String portStatus = "";
                    String diskStatus = "";
                    String otherStatus = "";
                    if (v.size() > 7) {
                        status = (String)v.elementAt(6);
                        portStatus = (String)v.elementAt(7);
                        diskStatus = (String)v.elementAt(8);
                        otherStatus = (String)v.elementAt(9);
                    }
                    String encInfo = "";
                    String portInfo = "";
                    String diskInfo = "";
                    String otherInfo = "";
                    String testInfo = "";
                    if (v.size() > 10) {
                        encInfo = (String)v.elementAt(10);
                        portInfo = (String)v.elementAt(11);
                        diskInfo = (String)v.elementAt(12);
                        otherInfo = (String)v.elementAt(13);
                        if (v.size() > 14) {
                            testInfo = (String)v.elementAt(14);
                        }
                    }
                    Node vx1 = this.graph.addNode(this, category, code, color, gif, prefix1, prefix2, prefix3, longPrefix1, longPrefix2, others, longOthers, maxpos, maxpos2, maxpos3, maxpos4, x, y, orientation, no, status, portStatus, diskStatus, otherStatus, encInfo, portInfo, diskInfo, otherInfo, testInfo, zones, name, label, label2, label3, ctrlNames, slotName);
                    all.addElement(vx1);
                } else {
                    vec1 = VertexApplet.parseData((String)v.elementAt(4), ",");
                    String v1no = (String)vec1.elementAt(0);
                    if (vec1.size() == 2) {
                        v1Pos = Integer.parseInt((String)vec1.elementAt(1));
                        if (this.INC_NODES.indexOf(v1no.substring(0, 2)) < 0) {
                            ++v1Pos;
                        }
                    }
                    vec1 = VertexApplet.parseData((String)v.elementAt(5), ",");
                    String v2no = (String)vec1.elementAt(0);
                    if (vec1.size() == 2) {
                        v2Pos = Integer.parseInt((String)vec1.elementAt(1));
                        if (this.INC_NODES.indexOf(v2no.substring(0, 2)) < 0) {
                            ++v2Pos;
                        }
                    }
                    Node Node1 = this.findNode(all, v1no);
                    Node Node2 = this.findNode(all, v2no);
                    if (Node1 != null && Node2 != null) {
                        if (category.equals("ZZ")) {
                            Point3 off1 = Node1.portOffset(v1Pos, 0, 0, 0, null, null, null, null);
                            Point3 off2 = Node2.portOffset(v2Pos, 0, 0, 0, null, null, null, null);
                            int link_x = (Node1.position.x + off1.x + Node2.position.x + off2.x) / 2;
                            int link_y = (Node1.position.y + off1.y + Node2.position.y + off2.y) / 2;
                            Node link_vx = this.graph.addNode(this, "x", "", "F0F0F0", "", "", "", "", "", "", "", "", 0, 0, 0, 0, link_x, link_y, 'v', no, label2, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
                            all.addElement(link_vx);
                            Edge link_ed1 = this.graph.addEdge(this, "E", Node1, v1Pos, link_vx, 0, "", "", "", "");
                            all.addElement(link_ed1);
                            Edge link_ed2 = this.graph.addEdge(this, "E", link_vx, 0, Node2, v2Pos, "", "", "", "");
                            all.addElement(link_ed2);
                        } else {
                            Edge ed1 = this.graph.addEdge(this, category, Node1, v1Pos, Node2, v2Pos, label, label2, label3, label4);
                            all.addElement(ed1);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error in parm " + (x0 + 1) + " " + e + objs.elementAt(x0));
            }
            ++x0;
        }
        all.removeAllElements();
        this.canvas.repaintGraph();
        return true;
    }

    Node findNode(Vector all, String v1) {
        int x = 1;
        while (x < all.size()) {
            if (all.elementAt(x).getClass().getName().equals("Node")) {
                Node v = (Node)all.elementAt(x);
                if (v.number.equals(v1)) {
                    return v;
                }
            }
            ++x;
        }
        return null;
    }

    public void appendInfo(String s) {
        if (s.length() > 300) {
            s = s.substring(0, 300);
        }
        String nl = "\n";
        if (this.browser.equals("window")) {
            nl = " ";
        }
        this.tfInfo.append(String.valueOf(nl) + s);
    }

    public void saveInfo(String s) {
        if (s.length() > 300) {
            s = s.substring(0, 300);
        }
        this.tfInfo.setText(s);
    }

    public Image getImage(String name) {
        if (name.substring(name.length() - 1).equals("v")) {
            name = name.substring(0, name.length() - 1);
        }
        name = String.valueOf(name) + ".gif";
        int x = 0;
        while (x < this.gif_names.size()) {
            if (this.gif_names.elementAt(x).toString().equals("TopoGif/" + name)) {
                return (Image)this.gif_images.elementAt(x);
            }
            ++x;
        }
        this.gif_names.addElement("TopoGif/" + name);
        System.out.println("reading " + name);
        URL u = this.getCodeBase();
        Image i = this.getImage(u, "TopoGif/" + name);
        this.gif_images.addElement(i);
        return i;
    }

    public void init() {
        String s1;
        this.dropMenus = new String[12][5];
        this.linkMenus = new String[10][5];
        this.alignMenus = new String[5][5];
        this.gif_names = new Vector(10);
        this.gif_images = new Vector(10);
        this.popup = new PopupMenu("Details");
        this.linkPopup = new PopupMenu("Details");
        this.zoomPopup = new PopupMenu("Zoom");
        this.alignPopup = new PopupMenu("Align");
        MenuItem mi = new MenuItem("Aligh Horizontal");
        mi.addActionListener(this);
        this.alignPopup.add(mi);
        mi = new MenuItem("Aligh Vertical");
        mi.addActionListener(this);
        this.alignPopup.add(mi);
        this.zoom = 0;
        this.selectedZoom = 0;
        this.scale = 1.0f;
        int x = 0;
        while (x <= 3) {
            float f = (float)Node.iconWidth[x] / (float)Node.FULL;
            String v = String.valueOf(x) + ": " + (int)(f * f * 100.0f) + "%";
            mi = new MenuItem(v);
            mi.addActionListener(this);
            this.zoomPopup.add(mi);
            ++x;
        }
        int i = 1;
        while (i <= 10) {
            Vector vec1;
            if (this.getParameter("ldrop" + i) != null) {
                vec1 = VertexApplet.parseData(this.getParameter("ldrop" + i), "|");
                if (vec1.size() == 4) {
                    this.linkMenus[i][0] = (String)vec1.elementAt(0);
                    this.linkMenus[i][1] = (String)vec1.elementAt(1);
                    this.linkMenus[i][2] = (String)vec1.elementAt(2);
                    this.linkMenus[i][3] = (String)vec1.elementAt(3);
                    this.linkMenusCnt = i;
                    mi = new MenuItem("              .");
                    mi.addActionListener(this);
                    this.linkPopup.add(mi);
                } else {
                    System.out.println("missing args in " + this.getParameter("drop" + i));
                }
            }
            if (this.getParameter("adrop" + i) != null) {
                vec1 = VertexApplet.parseData(this.getParameter("adrop" + i), "|");
                if (vec1.size() == 4) {
                    this.alignMenus[i][0] = (String)vec1.elementAt(0);
                    this.alignMenus[i][1] = (String)vec1.elementAt(1);
                    this.alignMenus[i][2] = (String)vec1.elementAt(2);
                    this.alignMenus[i][3] = (String)vec1.elementAt(3);
                    this.alignMenusCnt = i;
                    mi = new MenuItem((String)vec1.elementAt(0));
                    mi.addActionListener(this);
                    this.alignPopup.add(mi);
                } else {
                    System.out.println("missing args in " + this.getParameter("drop" + i));
                }
            }
            if (this.getParameter("drop" + i) == null) break;
            vec1 = VertexApplet.parseData(this.getParameter("drop" + i), "|");
            if (vec1.size() == 4) {
                this.dropMenus[i][0] = (String)vec1.elementAt(0);
                this.dropMenus[i][1] = (String)vec1.elementAt(1);
                this.dropMenus[i][2] = (String)vec1.elementAt(2);
                this.dropMenus[i][3] = (String)vec1.elementAt(3);
                this.dropMenusCnt = i;
                mi = new MenuItem("             .");
                mi.addActionListener(this);
                this.popup.add(mi);
            } else {
                System.out.println("missing args in " + this.getParameter("drop" + i));
            }
            ++i;
        }
        this.scroll = new ScrollPane();
        this.scroll.setBackground(Color.white);
        Dimension d = this.getSize();
        this.scroll.setSize(d.width, d.height);
        this.panel1 = new Panel();
        this.panel2 = new Panel();
        this.panel3 = new Panel();
        this.panel4 = new Panel();
        this.panel5 = new Panel();
        this.add(this.popup);
        this.add(this.linkPopup);
        this.add(this.zoomPopup);
        this.add(this.alignPopup);
        this.enableEvents(16L);
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(220, 220, 220));
        this.canvas = new VCanvas(this);
        this.CANVAS = this.canvas;
        this.graph = this.canvas.graph;
        this.canvas.setSize(canvas_W, canvas_H);
        this.scroll.add(this.canvas);
        this.panel2.setLayout(new FlowLayout(1, 4, 2));
        this.panel3.setLayout(new FlowLayout(1, 2, 2));
        this.panel1.setLayout(new BorderLayout());
        this.panel4.setLayout(new BorderLayout());
        this.panel1.setBackground(new Color(204, 204, 255));
        this.panel2.setBackground(new Color(204, 204, 255));
        this.orientation = (char)118;
        if (this.getParameter("orientation") != null && (s1 = new String(this.getParameter("orientation"))).length() == 1) {
            this.orientation = s1.charAt(0);
        }
        this.browser = this.getParameter("browser") != null ? new String(this.getParameter("browser")) : "window";
        this.webproc = "/rashttp";
        if (this.getParameter("webproc") != null) {
            this.webproc = new String(this.getParameter("webproc"));
        }
        this.userPassword = "ras:agent";
        if (this.getParameter("userPassword") != null) {
            this.userPassword = new String(this.getParameter("userPassword"));
        }
        this.graphicsButton = false;
        this.saveLayout = true;
        if (this.getParameter("saveLayout") != null && this.getParameter("saveLayout").equals("0")) {
            this.saveLayout = false;
        }
        if (this.getParameter("graphicsButton") != null && this.getParameter("graphicsButton").equals("1")) {
            this.graphicsButton = true;
        }
        if (this.getParameter("saveURL") != null) {
            this.saveURL = new String(this.getParameter("saveURL"));
        }
        this.showLinkHandle = 0;
        if (this.getParameter("showLinkHandle") != null) {
            this.showLinkHandle = Integer.parseInt(this.getParameter("showLinkHandle"));
        }
        this.cLayout = new Choice();
        this.cLayout.add("[Layout]");
        this.cLayout.add("Default");
        this.cLayout.add("Rack");
        this.bRead = new Button("Read");
        this.bRefresh = new Button("Start Monitor");
        this.bWrite = new Button("Save XY");
        this.bOrientation = this.orientation == 'h' ? new Button("_Vertical_") : new Button("Horizontal");
        this.bReset = new Button("Reset");
        this.bMove = new Button("Clear XY");
        this.bGif = new Button("Graphics On");
        this.bLink = this.showLinkHandle == 1 ? new Button("Links Off") : new Button("Links On");
        this.bClear = new Button("Clear Info");
        int w1 = (int)(0.45 * (double)this.size().width / 7.0);
        int w2 = (int)(0.55 * (double)this.size().width / 7.0);
        int txsize = 2;
        this.tfInfo = new TextArea("", txsize, w1, 2);
        this.taInfo = new TextArea(3, w1);
        ((Component)this.tfInfo).setBackground(Color.white);
        this.tfInfo.setForeground(Color.blue);
        this.taInfo.setText("[Right Click] enclosures for more information.\n\n");
        ((Component)this.taInfo).setBackground(Color.white);
        Font ff = new Font("SansSerif", 0, 10);
        this.taInfo.setFont(ff);
        Color c1 = this.browser.equals("sun") ? Color.black : Color.black;
        this.bRead.setForeground(c1);
        this.bWrite.setForeground(c1);
        this.bOrientation.setForeground(c1);
        this.bReset.setForeground(c1);
        this.bGif.setForeground(c1);
        this.bLink.setForeground(c1);
        this.bMove.setForeground(c1);
        this.bClear.setForeground(c1);
        this.bRefresh.setForeground(c1);
        if (this.saveLayout) {
            this.panel2.add(this.bWrite);
        }
        if (this.graphicsButton) {
            this.panel2.add(this.bGif);
        }
        this.panel2.add(this.cLayout);
        this.panel2.add(this.bOrientation);
        this.panel2.add(this.bLink);
        this.panel4.add("North", this.panel2);
        if (this.getParameter("hideInfo") == null || this.getParameter("hideInfo").equals("0")) {
            this.panel1.add("North", this.tfInfo);
        }
        if (this.getParameter("textArea") != null) {
            this.panel1.add("East", this.taInfo);
        }
        this.panel1.add("West", this.panel4);
        this.add("South", this.panel1);
        this.add(this.scroll);
        Selectable.selectedColor = Color.blue;
        this.urlDetails = this.getParameter("urlDetails");
        if (this.getParameter("zoom") != null) {
            this.zoom = Integer.parseInt(this.getParameter("zoom"));
            this.scale = (float)Node.iconWidth[this.zoom] / (float)Node.FULL;
        }
        this.isCustomer = "";
        if (this.getParameter("isCustomer") != null) {
            this.isCustomer = this.getParameter("isCustomer");
        }
        if (this.getParameter("circle") != null) {
            this.circleDevice = this.getParameter("circle");
        }
        statusSumMode = this.boolParameter("StatusSumMode", false);
        if (this.getParameter("urlRefresh") != null) {
            this.urlRefresh = this.getParameter("urlRefresh");
        } else {
            this.bRefresh.setVisible(false);
        }
        if (this.getParameter("timeRefresh") != null) {
            try {
                this.timeRefresh = Integer.parseInt(this.getParameter("timeRefresh"));
            }
            catch (Exception exception) {
                this.timeRefresh = 60000;
            }
        }
        this.reloadObj();
        if (this.getParameter("url") == null) {
            this.bRead.setVisible(false);
            this.bWrite.setVisible(false);
            this.bReset.setVisible(false);
            this.bMove.setVisible(false);
        }
        SymItem lSymItem = new SymItem();
        this.bWrite.addActionListener(lSymItem);
        this.bOrientation.addActionListener(lSymItem);
        this.bReset.addActionListener(lSymItem);
        this.bGif.addActionListener(lSymItem);
        this.bMove.addActionListener(lSymItem);
        this.bClear.addActionListener(lSymItem);
        this.bLink.addActionListener(lSymItem);
        this.bRefresh.addActionListener(lSymItem);
        SymItem2 lSymItem2 = new SymItem2();
        this.cLayout.addItemListener(lSymItem2);
    }

    public void reloadObj() {
        if (this.getParameter("object1") != null) {
            Vector<String> objs = new Vector<String>();
            this.bReset.setVisible(false);
            this.bMove.setVisible(false);
            int x0 = 0;
            while (x0 <= 300) {
                if (this.getParameter("object" + (x0 + 1)) == null) break;
                objs.addElement(this.getParameter("object" + (x0 + 1)));
                ++x0;
            }
            this.createObjects(objs);
        } else if (this.getParameter("url") != null) {
            String source = this.getParameter("url");
            this.createObjects(this.loadFromUrl(source));
        }
    }

    public boolean shift(int mod) {
        return (mod & 1) != 0;
    }

    public void send_to_browser(ActionEvent e, String type, String source) {
        URL url = null;
        if (type.length() > 11 && type.substring(0, 11).equals("javascript:")) {
            try {
                int x1 = type.indexOf("$1");
                String u1 = x1 > 0 ? String.valueOf(type.substring(0, x1)) + this.webproc + "?" + source + type.substring(x1 + 2) : String.valueOf(type) + "('" + this.webproc + "?" + source + "')";
                this.getAppletContext().showDocument(new URL(u1));
            }
            catch (MalformedURLException ex) {
                System.out.println("JS.error=" + ex);
            }
            return;
        }
        source = this.expandUrl(source);
        try {
            url = new URL(source);
        }
        catch (MalformedURLException malformedURLException) {}
        int mod = e.getModifiers();
        if (this.shift(mod)) {
            type = "altWindow";
        }
        this.getAppletContext().showDocument(url, type);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        URL url = null;
        this.stopTimer();
        if (this.selectedAlign != null) {
            int x = this.selectedAlign.position.x;
            int y = this.selectedAlign.position.y;
            boolean grouping = true;
            int k = 0;
            while (k < this.graph.vertices.size()) {
                Node v = (Node)this.graph.vertices.elementAt(k);
                if (v.selected && v.NodeType == 'g') {
                    grouping = true;
                    break;
                }
                ++k;
            }
            if (command.indexOf("Horiz") >= 0 || command.indexOf("Verti") >= 0) {
                int k2 = 0;
                while (k2 < this.graph.vertices.size()) {
                    Node v = (Node)this.graph.vertices.elementAt(k2);
                    if (v.selected) {
                        if (command.indexOf("Horiz") >= 0) {
                            v.position.y = y;
                        } else {
                            v.position.x = x;
                        }
                    }
                    ++k2;
                }
                this.canvas.repaintGraph();
            } else if (grouping) {
                String list = "";
                int k3 = 0;
                while (k3 < this.graph.vertices.size()) {
                    Node v = (Node)this.graph.vertices.elementAt(k3);
                    if (v.selected) {
                        list = String.valueOf(list) + v.label + "|";
                    }
                    ++k3;
                }
                String url0 = this.alignMenus[1][3];
                String source = String.valueOf(url0) + "&enc=" + list;
                source = this.expandUrl(source);
                System.out.println(source);
                try {
                    url = new URL(source);
                }
                catch (MalformedURLException malformedURLException) {}
                int mod = e.getModifiers();
                String type = this.alignMenus[1][1];
                this.getAppletContext().showDocument(url, type);
            }
            this.selectedAlign = null;
        } else if (this.selectedNode != null) {
            int x1 = 1;
            while (x1 <= this.dropMenusCnt) {
                int l = this.dropMenus[x1][0].length();
                if (command.substring(0, l).equals(this.dropMenus[x1][0])) {
                    int ix = command.indexOf("(");
                    int ix2 = command.indexOf(":");
                    int ix3 = command.indexOf(")");
                    String url0 = this.dropMenus[x1][3];
                    String source = String.valueOf(url0) + "&LINKH=" + this.showLinkHandle + "&enc=" + this.selectedNode.label + ":" + command.substring(ix2 + 1, ix3);
                    String type = this.dropMenus[x1][1];
                    if (this.dropMenus[x1][2].indexOf("r") >= 0) {
                        this.createObjects(this.loadFromUrl(source));
                    } else if (type.equals("t")) {
                        this.saveInfo(this.readFromUrl(source));
                    } else {
                        this.send_to_browser(e, type, source);
                    }
                }
                ++x1;
            }
            this.selectedNode = null;
        } else if (this.selectedEdge != null) {
            int x1 = 1;
            while (x1 <= this.linkMenusCnt) {
                int l = this.linkMenus[x1][0].length();
                if (command.equals(this.linkMenus[x1][0])) {
                    String url0 = this.linkMenus[x1][3];
                    int p1 = this.selectedEdge.startPos;
                    int p2 = this.selectedEdge.endPos;
                    if (this.INC_NODES.indexOf(this.selectedEdge.start.label.substring(0, 2)) < 0) {
                        --p1;
                    }
                    if (this.INC_NODES.indexOf(this.selectedEdge.end.label.substring(0, 2)) < 0) {
                        --p2;
                    }
                    String source = String.valueOf(url0) + "&LINKH=" + this.showLinkHandle + "&link=" + this.selectedEdge.label3 + "&start=" + this.selectedEdge.start.label + ":" + p1 + "&end=" + this.selectedEdge.end.label + ":" + p2;
                    String type = this.linkMenus[x1][1];
                    if (this.linkMenus[x1][2].indexOf("r") >= 0) {
                        System.out.println("load=" + source);
                    } else if (type.equals("t")) {
                        this.saveInfo(this.readFromUrl(source));
                    } else {
                        this.send_to_browser(e, type, source);
                    }
                }
                ++x1;
            }
            this.selectedEdge = null;
        } else if (this.selectedZoom > 0) {
            int lastz = this.zoom;
            this.zoom = Integer.parseInt(command.substring(0, 1));
            this.scale = (float)Node.iconWidth[this.zoom] / (float)Node.FULL;
            if (this.zoom != lastz) {
                this.canvas.repaintGraph();
                try {
                    if (this.zoom == 3) {
                        this.scroll.setScrollPosition(0, 0);
                    } else {
                        float scale0 = (float)Node.iconWidth[lastz] / (float)Node.FULL;
                        Dimension d = this.scroll.getViewportSize();
                        int x = (int)((float)this.zoomPosition.x / scale0 * this.scale) - d.width / 2;
                        int y = (int)((float)this.zoomPosition.y / scale0 * this.scale) - d.height / 2;
                        this.CANVAS.getSize();
                        this.scroll.setScrollPosition(x, y);
                    }
                }
                catch (Exception exception) {}
            }
            this.selectedZoom = 0;
        }
    }

    void layoutAdd(Node found, Vector A) {
        if (!found.done) {
            A.addElement(found);
            found.done = true;
        }
    }

    void cLayout_ItemStateChanged(ItemEvent event) {
        System.out.println("layout=" + this.cLayout.getSelectedIndex());
        int width = this.getSize().width - 20;
        int height = this.getSize().height;
        Vector<Node> A = new Vector<Node>();
        Vector<Node> V = new Vector<Node>();
        Vector<Node> H = new Vector<Node>();
        Vector<Node> S1 = new Vector<Node>();
        Vector<Node> S2 = new Vector<Node>();
        int k = 0;
        while (k < this.graph.vertices.size()) {
            Node v = (Node)this.graph.vertices.elementAt(k);
            v.done = false;
            ++k;
        }
        if (this.cLayout.getSelectedIndex() == 1) {
            int array_x;
            Node found;
            this.zoom = 2;
            this.scale = (float)Node.iconWidth[this.zoom] / (float)Node.FULL;
            width = (int)((double)width / (double)this.scale);
            int host_y = 10;
            int sw_y = 20;
            int k2 = 0;
            while (k2 < this.graph.vertices.size()) {
                Node v = (Node)this.graph.vertices.elementAt(k2);
                if (!v.done && v.NodeType == 'h') {
                    this.layoutAdd(v, H);
                    while ((found = this.findNode(v, 's', false)) != null) {
                        this.layoutAdd(found, S1);
                    }
                    while ((found = this.findNode(v, 'u', false)) != null) {
                        this.layoutAdd(found, S1);
                    }
                    while ((found = this.findNode(v, 'a', false)) != null) {
                        this.layoutAdd(found, A);
                    }
                }
                ++k2;
            }
            int k3 = 0;
            while (k3 < this.graph.vertices.size()) {
                Node v = (Node)this.graph.vertices.elementAt(k3);
                if (!v.done && v.category("switch")) {
                    found = this.findNode(v, 'a', true);
                    if (found != null) {
                        this.layoutAdd(v, S2);
                        this.layoutAdd(found, A);
                    } else if (this.findNode(v, 'a', true) == null && this.findNode(v, 'h', true) == null) {
                        this.layoutAdd(v, S2);
                    } else {
                        this.layoutAdd(v, S1);
                        while ((found = this.findNode(v, 's', false)) != null) {
                            System.out.println("v=" + v.label + ", found=" + found.label);
                            if (found.category("switch")) {
                                this.layoutAdd(found, S2);
                                continue;
                            }
                            this.layoutAdd(found, V);
                        }
                    }
                }
                ++k3;
            }
            int k4 = 0;
            while (k4 < this.graph.vertices.size()) {
                Node v = (Node)this.graph.vertices.elementAt(k4);
                if (!v.done) {
                    if (v.NodeType == 's') {
                        if (v.category("ve")) {
                            V.addElement(v);
                        } else {
                            S2.addElement(v);
                        }
                    } else if (v.NodeType != 'h') {
                        A.addElement(v);
                    }
                }
                ++k4;
            }
            if (V.size() > 0) {
                this.layoutV(H, height, H.size(), 15, 40, false);
                this.layoutV(S1, height, S1.size(), width / 6 - 20, 40, false);
                this.layoutV(V, height, V.size(), 2 * width / 6 - 20, 40, false);
                this.layoutV(S2, height, S2.size(), 3 * width / 6 - 20, 40, false);
                array_x = 4 * width / 6 - 20;
            } else {
                this.layoutV(H, height, H.size(), 15, 40, false);
                this.layoutV(S1, height, S1.size(), width / 4 - 20, 40, false);
                this.layoutV(S2, height, S2.size(), 2 * width / 4 - 20, 40, false);
                array_x = 3 * width / 4 - 20;
            }
            int array_y = 20;
            int array_inc = height / A.size();
            int i = 0;
            while (i < A.size()) {
                Node v = (Node)A.elementAt(i);
                double f = (double)i * 3.1 / (double)A.size();
                int x = array_x + (int)(Math.sin(f) * (double)width / 7.0);
                v.setPosition(x, array_y);
                array_y += array_inc;
                ++i;
            }
            this.orientation = (char)118;
            this.bOrientation.setLabel("Horizontal");
            this.canvas.repaintGraph();
        } else if (this.cLayout.getSelectedIndex() == 2) {
            this.zoom = 1;
            this.scale = (float)Node.iconWidth[this.zoom] / (float)Node.FULL;
            width = (int)((double)width / (double)this.scale);
            int k5 = 0;
            while (k5 < this.graph.vertices.size()) {
                Node v = (Node)this.graph.vertices.elementAt(k5);
                if (v.NodeType == 'h') {
                    H.addElement(v);
                } else if (v.NodeType == 'a') {
                    A.addElement(v);
                } else if (v.NodeType == 's') {
                    if (v.category("ve")) {
                        V.addElement(v);
                    } else if (this.findNode(v, 'a', true) != null) {
                        S2.addElement(v);
                    } else {
                        S1.addElement(v);
                    }
                }
                ++k5;
            }
            this.layout(H, width, H.size(), 15, 40);
            this.layout(S1, width, S1.size(), 120, 40);
            this.layout(V, width, V.size(), 210, 40);
            this.layout(S2, width, S2.size(), 310, 40);
            this.layout(A, width, A.size(), 410, 40);
            this.orientation = (char)104;
            this.bOrientation.setLabel("_Vertical_");
            this.canvas.repaintGraph();
        }
    }

    Node findNode(Node v, char type, boolean doneok) {
        int j = 0;
        while (j < this.graph.edges.size()) {
            Edge ed = (Edge)this.graph.edges.elementAt(j);
            if (ed.start == v && ed.end.NodeType == type && (doneok || !ed.end.done)) {
                return ed.end;
            }
            if (ed.end == v && ed.start.NodeType == type && (doneok || !ed.start.done)) {
                return ed.start;
            }
            ++j;
        }
        return null;
    }

    void layoutV(Vector V, int height, int cnt, int x, int off, boolean ordered) {
        if (cnt == 0) {
            return;
        }
        int inc = height / cnt;
        if (inc < 100) {
            inc = 100;
        }
        int y = inc / 2 - off;
        String done = "";
        if (ordered) {
            int first_i;
            while ((first_i = this.findNext(V, done)) != -1) {
                Node v = (Node)V.elementAt(first_i);
                done = String.valueOf(done) + "," + v.label;
                v.setPosition(x, y);
                y += inc;
            }
        } else {
            int i = 0;
            while (i < V.size()) {
                Node v = (Node)V.elementAt(i);
                v.setPosition(x, y);
                y += inc;
                ++i;
            }
        }
    }

    void layout(Vector V, int width, int cnt, int y, int off) {
        int first_i;
        int x;
        String done = "";
        if (cnt == 0) {
            return;
        }
        int inc = width / cnt;
        if (inc < 100) {
            inc = 100;
        }
        int x0 = x = inc / 2 - off;
        while ((first_i = this.findNext(V, done)) != -1) {
            Node v = (Node)V.elementAt(first_i);
            done = String.valueOf(done) + "," + v.label;
            v.setPosition(x, y);
            if ((x += inc) <= width - 30) continue;
            y += 100;
            x = x0;
        }
    }

    int findNext(Vector V, String done) {
        int first_i = -1;
        String first = "zzz";
        int i = 0;
        while (i < V.size()) {
            Node v = (Node)V.elementAt(i);
            if (done.indexOf(v.label) < 0 && v.name.compareTo(first) < 0) {
                first = v.name;
                first_i = i;
            }
            ++i;
        }
        return first_i;
    }

    void bRefreshActionEvent(ActionEvent event) {
        if (this.bRefresh.getLabel().equals("Start Monitor")) {
            this.bRefresh.setLabel("Stop Monitor");
            timerOn = true;
            this.timer = new Thread(this);
            this.timer.start();
        } else {
            this.bRefresh.setLabel("Start Monitor");
            timerOn = false;
            this.timer.stop();
            this.timer = null;
        }
    }

    public void stopTimer() {
        this.bRefresh.setLabel("Start Monitor");
        this.timer = null;
        timerOn = false;
        System.out.println("timer stopped");
    }

    public void run() {
        while (timerOn) {
            try {
                System.out.println("refreshing" + this.urlRefresh);
                this.updateObjectsStatus(this.loadFromUrl(this.urlRefresh));
                this.canvas.repaintGraph();
                Thread.sleep(this.timeRefresh);
            }
            catch (Exception e) {
                System.out.println("thread error: " + e);
                break;
            }
        }
    }

    void bWrite_ActionEvent(ActionEvent event) {
        this.bWrite.setEnabled(false);
        this.canvas.setCursor(new Cursor(3));
        String source = this.getParameter("url");
        this.saveToUrl(source);
        this.bWrite.setEnabled(true);
        this.canvas.setCursor(new Cursor(0));
    }

    void bRead_ActionEvent(ActionEvent event) {
        System.out.println("read");
        String source = this.getParameter("url");
        this.bRead.setEnabled(false);
        this.createObjects(this.loadFromUrl(source));
        this.bRead.setEnabled(true);
        this.bRead.requestFocus();
    }

    void bMove_ActionEvent(ActionEvent event) {
        String source = this.getParameter("url");
        this.createObjects(this.loadFromUrl(String.valueOf(source) + "&option=clear"));
    }

    void bReset_ActionEvent(ActionEvent event) {
        System.out.println("reset");
        String source = String.valueOf(this.getParameter("url")) + "0";
        this.createObjects(this.loadFromUrl(source));
    }

    void bGif_ActionEvent(ActionEvent event) {
        if (this.gif_flag) {
            this.bGif.setLabel("Graphics On");
            this.gif_flag = false;
        } else {
            this.bGif.setLabel("Graphics Off");
            this.gif_flag = true;
        }
        this.canvas.repaintGraph();
    }

    void bLink_ActionEvent(ActionEvent event) {
        if (this.showLinkHandle == 1) {
            this.bLink.setLabel("Links On");
            this.showLinkHandle = 0;
        } else {
            this.bLink.setLabel("Links Off");
            this.showLinkHandle = 1;
        }
        this.canvas.repaintGraph();
    }

    void bOrientation_ActionEvent(ActionEvent event) {
        if (this.orientation == 'h') {
            this.bOrientation.setLabel("Horizontal");
            this.orientation = (char)118;
        } else {
            this.bOrientation.setLabel("_Vertical_");
            this.orientation = (char)104;
        }
        this.canvas.repaintGraph();
    }

    public static Vector parseData(String s, String del) {
        Vector<String> v = new Vector<String>(20);
        int k = 0;
        while (k <= s.length()) {
            int i = s.indexOf(del, k);
            if (i < 0) {
                i = s.length();
            }
            String s1 = s.substring(k, i);
            v.addElement(s1);
            k = i + 1;
        }
        return v;
    }

    public boolean boolParameter(String s, boolean def) {
        boolean b = def;
        try {
            if (this.getParameter(s) != null) {
                String s2 = this.getParameter(s);
                b = !s2.equalsIgnoreCase("false") && !s2.equalsIgnoreCase("0");
            }
        }
        catch (Exception exception) {
            b = def;
        }
        return b;
    }

    static {
        canvas_W = 1900;
        canvas_H = 1500;
        smallFont = new Font("Dialog", 0, 9);
    }

    class SymItem2
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == VertexApplet.this.cLayout) {
                VertexApplet.this.cLayout_ItemStateChanged(event);
            } else {
                VertexApplet.this.canvas.repaintGraph();
            }
        }

        SymItem2() {
            VertexApplet.this = VertexApplet.this;
        }
    }

    class SymItem
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == VertexApplet.this.bWrite) {
                VertexApplet.this.bWrite_ActionEvent(event);
            } else if (object == VertexApplet.this.bRead) {
                VertexApplet.this.bRead_ActionEvent(event);
            } else if (object == VertexApplet.this.bOrientation) {
                VertexApplet.this.bOrientation_ActionEvent(event);
            } else if (object == VertexApplet.this.bReset) {
                VertexApplet.this.bReset_ActionEvent(event);
            } else if (object == VertexApplet.this.bGif) {
                VertexApplet.this.bGif_ActionEvent(event);
            } else if (object == VertexApplet.this.bLink) {
                VertexApplet.this.bLink_ActionEvent(event);
            } else if (object == VertexApplet.this.bMove) {
                VertexApplet.this.bMove_ActionEvent(event);
            } else if (object == VertexApplet.this.bClear) {
                VertexApplet.this.taInfo.setText("");
            } else if (object == VertexApplet.this.bRefresh) {
                VertexApplet.this.saveInfo("refreshing" + VertexApplet.this.urlRefresh + " (" + VertexApplet.this.timeRefresh / 1000 + ")");
                VertexApplet.this.updateObjectsStatus(VertexApplet.this.loadFromUrl(VertexApplet.this.urlRefresh));
                VertexApplet.this.canvas.repaintGraph();
                VertexApplet.this.bRefreshActionEvent(event);
            }
        }

        SymItem() {
            VertexApplet.this = VertexApplet.this;
        }
    }
}

