package Agent::V880DISK;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: V880DISK.pm,v 1.11 2002/07/31 17:35:51 ccadieux Exp $

use strict;
use Agent;
use Agent::A5K;
use base 'Agent::A5K';

sub isSelectable {"Sun V880 Disk"}
sub revision {'$Revision: 1.11 $'}
sub category { Report::CAT_V880DISK }
sub lux_category {"SUNWGS"}


sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::V880DISK');
  return $self;
}

use vars qw ($ERR);



sub INSTRUMENTATION {
  my($agent, $device, $lux) = @_;
  my(@s, %dev, $in, %info, $key, $state, $num);
  my($v3, $v1, $v2, $x, $wwn, $status, $rev, $ib, $no, $id, $i);
  $key = $device->{key};
  my($renv)  = System->get_renv();
  my($TO) = $renv->{'timeout.luxadm'};

  my $w = $device->{wwn} || $device->{name};
  my($err,$com) = Util->run_command("$lux display $w 2>&1", "luxadm.txt" , $TO);
  return ("",$err, undef) if ($err);

  $info{"disk.header"} = "disk";
  $info{"SSC.header"} = "SSC";
  $info{"temperature.header"} = "temperature";
  my $disk_done = 0;

  for ($i =0; $i <= $#$com; $i++ ) {
    my $l = $com->[$i];
    if ($l =~ /^ *Error:/) {
       return ("",$l, undef);
    }   
    if ($l =~ /^SLOT/) {
      $in = "slot";
    } elsif ($l =~ /^FW Rev/) {
      $in = 0;
      $l =~ /FW Revision:([\d\.]+) .* +Box ID:(.*)/;
      my $box = $2; 
      $info{'revision.value'} = Util->rtrim($1);
      $info{'info.boxid'} = Util->rtrim($box);

    } elsif ($l =~ /SSC100 #(\d+): +(.*)/) {
        my $no = $1; my $val = $2;
        $val =~ s/[\. ]//g;
        my @T = ('base_backplane','base_loopB','exp_backplane','exp_loopB');
        my $xx = index($val, "(");
        my $rev0;
        if ($xx > 0) {
           $val = substr($val, 0, $xx);
           $rev = substr($val, $xx+1);
           $rev =~ s/\)//;
        }
        $info{"SSC.$T[$no].status"} = $val;
        $info{"SSC.$T[$no].revision"} = $rev if ($rev);

    } elsif ($l =~ /Temperature Sensors/) {
        my (@temp);
        my @T = ('', 'base','expansion');
        $temp[1] = Util->ltrim($com->[$i+1]);
        $temp[2] = Util->ltrim($com->[$i+2]);
        if ( $temp[1] =~ /All/ )    {

            # in this case one line output has base and expansion temperature 
            # such as:
            # 0:23'C 1:25'C  (All temperatures are NORMAL.)
            # then there is no need for temp[2]

            my ($part1, $part2, $rest ) = split (/\s+/,$temp[1]);
            $info{"temperature.$T[1].status"} = "OK"; 
            $info{"temperature.$T[1].value"}  = substr($part1,2);
            $info{"temperature.$T[2].status"} = "OK";
            $info{"temperature.$T[2].value"}  = substr($part2,2);
        } else {

            # expansion board is not installed
            # so output in two lines, such as:
            # Temperature Sensors - 0 Base, 1 Expansion                       
            #          0:25'C 
            #                 1Not Installed

            for ($x=1; $x <= 2; $x++) {
              if ($temp[$x] =~ /^\d+:\d+/) {
                  $info{"temperature.$T[$x].status"} = "OK";
                  $info{"temperature.$T[$x].value"} = substr($temp[$x],2);
              } else {
                  my $v = substr($temp[$x],1);
                  $v =~ s/ //g;
                  $info{"temperature.$T[$x].status"} = $v;
              }
            }
 
        }

    } else {
      if ($in eq "slot") {
        if (substr($l,0,1) =~ /\d/) {
          $num =  substr($l,0,2) + 0;
          $x = substr($l,7,18);
          $info{"disk.$num.exist"} = 1;  # use this to know if the row is there,
          $wwn = substr($l,25,16);
          if ($x =~ /Not Inst/) {
            $status = "OK"; $state = "NotInstalled";
          } else {
            $x =~ /([ \w]+)(.*)/;
            $state = Util->rtrim($1); 
            $status = $2; 
            $status =~ s/[\(\)\.]//g;
            $status = Util->trim($status);
            $status =~ s/ /_/g;
          }
          $wwn = " " if ($wwn !~ /^[ 0-9a-f]+$/);
          $info{"disk.$num.wwn"} = $wwn;
          $info{"disk.$num.state"} = $state;

          $info{"disk.$num.status"} = $status;
        }
      }
    }
  }
  # do not loose information from last report.
  my($oreport) = PDM->getOldReport("v880disk:$key");
  if ($oreport) {
    my($orep, $num);
    $orep = $oreport->content;
    if ($orep->{"disk.1.vendor"}) {
        my $side = "disk";
        for ($num=0; $num <= 11; $num++) {
          $info{"$side.$num.vendor"}     = $orep->{"$side.$num.vendor"};
          $info{"$side.$num.revision"}   = $orep->{"$side.$num.revision"};
          $info{"$side.$num.product_id"} = $orep->{"$side.$num.product_id"};
          $info{"$side.$num.serial_no"}  = $orep->{"$side.$num.serial_no"};
          $info{"$side.$num.u_capacity"} = $orep->{"$side.$num.u_capacity"};
        }
    }
  }
  $agent->addIdentification(\%info);
  Debug->dump('a5kConfig', \%info);
  return ($key, "", \%info);
}

# called by health monitor when needed (discovery, audit, topology )
# disk is * or  'diskfront.2' or 'disk_rear.2'

sub disks_display {
  my($agent, $disk, $rep) = @_;
  my($num, %info);
  my($lux) = System->find_luxadm;

  if ($disk eq "*") {
    for ($num=0; $num <= 11; $num++) {
       my($wwn) = $rep->{"disk.$num.wwn"};
       $agent->disk_display("disk.$num", $wwn, \%info, $lux, "f$num");
    }
  } else {
       my($wwn) = $rep->{"$disk.wwn"};
       my(@a) = split(/\./, $disk);
       my($parm) = "f$a[1]";
       
       $agent->disk_display($disk, $wwn, \%info, $lux, $parm);
  }
    
  # merge new info into existing report
  foreach my $v (keys %info) {
      $rep->{$v} = $info{$v};
  }
}



sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($rev) = $r->{'_value'}{"revision.value"};
  my($host0) = $host || System->hostname();
  $out .= $class->reportHead('V880DISK', $r);
  $out .= "
   <tr><td bgcolor=#F0F0F0 align=right><b>Name:</td><td width=25%>&nbsp;$r->{_id}{name}</td>
       <td bgcolor=#F0F0F0 align=right><b>Monitored on:</td><td>&nbsp;$host0</td>
  
   <tr><td bgcolor=#F0F0F0 align=right><b>WWN:</td><td>&nbsp;$r->{_id}{deviceName}</td>
       <td bgcolor=#F0F0F0 align=right><b>Rev:</td><td>&nbsp;$rev</td>
  </table>
  
  <table border=1 cellspacing=0 cellpadding=1 width=95% bgcolor=white>
  <tr bgcolor=#E0E0E0>
    <th><font color=black>Type</th>
    <th><font color=black>Identification</th>
    <th><font color=black>Component</th>
    <th><font color=black>Status</th>
    <th><font color=black>Revision</th>
  ";

  my($name) = $r->{_id}{name};
 
  my($v) = $r->{_value};
  my($d, $x, $status, $wwn, $ports);
  my($cnt)= 0;

    $rev = $v->{"backplane.rev"};
    for ($x=0; $x <= 11; $x++) {
      my($comp) = "disk.$x";
      $status = $v->{"$comp.state"} . "-" . $v->{"$comp.status"};
      $b = ($v->{"$comp.status"} eq "OK")? "":"<font color=red>";

      $wwn = $v->{"$comp.product_id"} . " " . 
             $v->{"$comp.serial_no"}  . " " . 
             $v->{"$comp.wwn"} ;

      $rev = $v->{"$comp.revision"};
      #$ports  = $v->{"$comp.portA.status"} . "/" . $v->{"$comp.portB.status"};
      $out .= 
           "<tr><td><center>Disk".
           "<td><small>$wwn&nbsp;" .
           "<td>$x".
           "</td><td>$b$status</td><td>$rev&nbsp;</td>\n";
      $cnt++;
    }
  $out .= "<tr><td colspan=5 bgcolor=#CCCCFF><b>SCC</td>";
  foreach my $el ('base_backplane','base_loopB','exp_backplane','exp_loopB') {
    my $st = $v->{"SSC.$el.status"};
    $out .= "<tr><td>SSC<td colspan=2>$el<td>$st<td>&nbsp;</td>";
  }
  $out .= "<tr><td colspan=5 bgcolor=#CCCCFF><b>Temperature</td>";
  $out .= "<tr><td>Temp.<td colspan=2>base<td>$v->{'temperature.base.status'} / $v->{'temperature.base.value'}</td><td>&nbsp;</td>";
  $out .= "<tr><td>Temp.<td colspan=2>Expansion<td>$v->{'temperature.expansion.status'} / $v->{'temperature.expansion.value'}</td><td>&nbsp;";

  if (!$tableCnt) {
    $out .= "</table>\n";
  }
  return $out;

}




1;

