package Client::SRM;
use System;
use Util;
use PDM::ConfigFile;
use Report;
use strict;

my $indent_level = 0;
my $HTTP_HEADER="HTTP/1.0 200 OK\nContent-Type: text/html\n\n";

my @indy_t3;
my %t3_addr;
my $cabinet_num;

#  http://hostname:7654$Http::WEBPROC?GO=CLient::SRM::get_list
#  http://hostname:7654$Http::WEBPROC?GO=Client::SRM::get_report&indy=xxxxxxxx
#  indy can by blank|specific-hostname

# LIST

sub find_se {
  my(@SE);
  opendir(O, System->get_home() . "/DATA/OLD_REPORTS");
  my @L = readdir(O);
  closedir(O);
  foreach my $f (@L) {
     next if (substr($f,0,3) ne "se:");
     push(@SE, substr($f,3));
  }
  return \@SE;
}

sub get_list {
  my($q) = @_;
  
  my $Config = PDM::ConfigFile->read();
  my $renv   = $Config->renv();
  my $hosts  = $Config->hosts();
  my $out =<<EOF;
$HTTP_HEADER
<?xml version ="1.0"?>
<!DOCTYPE RAIDBaseView SYSTEM "Raid.dtd">
EOF
  $out .= "<INDYLIST>\n";
  my $list = &find_se();
  foreach my $f (@$list) {
     $out .= "  <INDY>$f</INDY>\n";
  }
  $out .= "</INDYLIST>\n";
  print $out;
}

# REPORT

sub get_report {

  my($q) = @_;

  my $out = &head();
  my $all_err = "";
  my $remote_xml = "";

  my $Config = PDM::ConfigFile->read();
  my $renv   = $Config->renv();
  my $hosts  = $Config->hosts();
  my ($report, $name, $err, $x, $y);

  my $local_name = $renv->{hostname};

  if ($q->{indy}) {
     $report = Report->readLocal($q->{indy});
     $name = $q->{indy};
  } else {
     my $list = &find_se();
     if ($#$list < 0) {
       print &error("$q->{indy}: Report not found!");
       return;
     }
     $name = $list->[0];
     $report = Report->readLocal("se:$list->[0]");
  }

  if (!$report) {
     print &error("$q->{indy}: Report not found!");
     return;
  }
  my $r = $report->content();
  my $out = $HTTP_HEADER;

# BASEVIEW
  $out .= <<EOF;
<?xml version ="1.0"?>
<!DOCTYPE RAIDBaseView SYSTEM "Raid.dtd">
<RAIDBaseView version = "1.0"> 
   <RAIDSystem category="$r->{'info.category'}" isRedundantController="$r->{'info.isRedundantController'}" supportsLUNMasking="$r->{'info.supportsLUNMasking'}" HGType="$r->{'info.HGType'}">
    <ID>
      <name>$name</name>
      <worldwideId>N/A</worldwideId>
      <IPAddress>$r->{'id.ipno'}</IPAddress>
    </ID>
    <totalSpace>$r->{'info.totalCapacity'}</totalSpace>
    <supportedRAIDType>$r->{'info.supportedRAIDType'}</supportedRAIDType>
    <performance></performance>
    <enclosure>
      <model>$r->{'info.model'}</model>
      <manufacturer>$r->{'info.vendor'}</manufacturer>
      <serialNumber>$r->{'info.serialNumber'}</serialNumber>
      <firmwareLevel>$r->{'info.firmwareLevel'}</firmwareLevel>
      <mgmtServerLink>
        <mgmtDisplayName>$name</mgmtDisplayName>
      </mgmtServerLink>
    </enclosure>
EOF

# CONTROLLERS
  for ($x=1; $x <= 10*40; $x++) {  
     next if ($r->{"fru.$x.fruId"} !~ /u\dctr/);
     my $u    = $r->{"fru.$x.fruId"};
     my $port = substr($u,0,2) . "p1";
     my $slot = $r->{"fru.$x.fruSlot"};
     my $name = $r->{"slot.$slot.dev-name"} . "-" . $r->{"fru.$x.fruId"};
     my $ip   = $r->{"slot.$slot.dev-ipno"};
          $out .=<<EOF;
    <controller category="RAIDController">
      <name>$name</name>
      <IPAddress>$ip</IPAddress>
      <model>$r->{"fru.$x.fruModel"}</model>
      <manufacturer>$r->{"fru.$x.fruVendor"}</manufacturer>
      <serialNumber>$r->{"fru.$x.fruSerialNo"}</serialNumber>
      <firmwareLevel>$r->{"fru.$x.fruRevision"}</firmwareLevel>
      <mgmtServerLink>
        <mgmtDisplayName>N/A</mgmtDisplayName>
      </mgmtServerLink>
      <port portType="FIBRECHANNEL" category="RAIDPort">
        <name>$port</name>
        <endPointId>N/A</endPointId>
      </port>
    </controller>
EOF
  }

# LUNS
#        <type>$r->{"lun.$x.lunType"}</type>
  for ($x = 1; $x <= 2000; $x++) {    # luns
    last if (!$r->{"lun.$x.lunName"});
    $out .=<<EOF;
    <LUN category="RAIDLUN">
      <ID>
        <name>$r->{"lun.$x.lunName"}</name>
        <worldwideId>$r->{"lun.$x.lunWwn"}</worldwideId>
      </ID>
      <QOSAttrs raidLevel="RAID5" remoteCopy="FALSE" beingBackedUp="FALSE" />
      <LUNTotalSpace>$r->{"lun.$x.lunCapacity"}</LUNTotalSpace>
    </LUN>
EOF
  }
  
# VERSION
  $out .=<<EOF;
    <scanInfo></scanInfo>
    <plugInVersion>N/A</plugInVersion>
EOF
  $out .= "  </RAIDSystem>\n</RAIDBaseView>\n";

  print $out;
  
}

sub LUNHostMapping {
  my $category = "RAIDLUNHostMapping";
  my $name = "N/A";

  my $out_str;
  $out_str = xml_str(1,"LUNHostMapping","category = \"$category\"");
  print $out_str;
  $out_str = xml_str(2,"name", $name);
  print $out_str;
  $out_str = xml_str(-1,"LUNHostMapping","");
  print $out_str;

}

sub head {
  return <<EOF;
$HTTP_HEADER
<?xml version ="1.0">
<!DOCTYPE RAIDBaseView SYSTEM "Raid.dtd">
EOF
}

sub getipaddr {

  my $a1;
  my $a2;
  my $a3;
  my $a4;
  my @addrs;
  ( $a1,$a2,$a3,$a4,@addrs ) = gethostbyname($_[0]);
  ( $a1,$a2,$a3,$a4 ) = unpack('C4',$addrs[0]);
  return  "$a1."."$a2."."$a3."."$a4";
}

sub error {
  my($t) = @_;
  return <<EOF;
$HTTP_HEADER
<?xml version="1.0"?>
<ERROR>
  $t
</ERROR>
EOF
}




1;

