package GUI::Config;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use Html::Screen;
use strict;
use Agent;

#  $Id: Config.pm,v 1.55 2002/09/19 15:43:54 ccadieux Exp $

sub site {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();

  my $G = Labels->read();
  my $L = Labels->read('GUI::Config')->section('site');

  my($error);
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print "\n";
  $info = "";
  my($warn2, $warn3, $cat);

  if ($q->{ACTION_submit}) {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
     if ($err1) {
       $info = Html->error($G->{e_108});
       $err1 = "<font color=red>$err1</font>";
     }
     if (!$q->{customer}) {
       print Html->error($G->{e_109});
       $err5 = "<font color=red>$G->{mandat}</font>";
     }
     $q->{site_state} = uc($q->{site_state});
     if (!$q->{site_name} || !$q->{site_city} || !$q->{site_country} || !$q->{site_zip} ||
         !$q->{site_contact} ) {
       print Html->error($L->{err_1});
       $err8 = "<font color=red>$G->{e_110}</font>";
     }
     goto err2 if ($err1 ||  $err5 || $err8);
     $q->{site_country} = "USA" if (! $q->{site_country});

     for my $v ('customer','cust_no','site_name','site_address','site_city',
             'site_state', 'site_zip','site_contact','site_email','site_country',
             'production', 'site_contact_phone',
             'contract', 'ticker' ) {
        $renv->{$v}    = $q->{$v};
     }
     $renv->{role}     = "M";
     $renv->{hostname} = System->hostname();
     #$renv->{log_months}  = ($q->{local_event_log} eq "Y")? $q->{log_months} :"";

     if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
        print "$G->{e_100}<br>";
     } else {
        $info = Html->info($G->{conf_upd});
     }

  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
     $renv->{t300logfile} =~ s/^\s+//;
     $renv->{t300logfile} =~ s/\s+$//;
     if ($renv->{t300logfile} && !-f $renv->{t300logfile}) {
       $warn2 = "<br><font color=red>$G->{cannot_find} $renv->{t300logfile}";
     }
     if ($renv->{logfile} && !-f $renv->{logfile}) {
       $warn3 = "<br><font color=red>$G->{cannot_find} $renv->{logfile}";
     }
  }

err2:
  if ($err1 || $err5 || $err8) {
    foreach my $x ('cust_no','contract',
                'site_city', 'site_state', 'site_country', 'site_zip',
                'site_contact', 'site_email','site_address','site_name',
                'customer','ticker','contract') {
       $renv->{$x} = $q->{$x} 
    }
  }
  print Html->header2("admin.gen_maint.site_info");

  $c2 = "selected" if ($renv->{local_event_log} eq "Y");
  my($p_1, $p_2);
  if ($renv->{production} eq "Y") {
     $p_1 = "selected";
  } else {
     $p_2 = "selected";
  }

  my $pings = $renv->{ping};
  $pings =~ s/\|/\n/g;
  $pings =~ s/\#/  #/g;

  my $man = "<font size=+3 color=red><b>*</b></font>";
  my $o;
  print "\n<body bgcolor=$main'BGCOLOR><center><form><input type=hidden name=GO value=GUI::Config::site>";

  $o = Html::Screen->paint({error => "$info\n$error" },
  [
   [l => $L->{l1}],
   [f =>  $L->{l2},
         "<input type=text name=customer size=40  maxlength=60 value=\"$renv->{customer}\">$man <font color=red><b>$G->{mandat}</b></font>$err5 " ],
   [f => $L->{l3},
         "<input type=text name=cust_no size=20 maxlength=20 value=\"$renv->{cust_no}\">" ],
   [f => $L->{l4},
         "<input type=text size=20 maxlength=20 name=contract value=\"$renv->{contract}\">",1 ],
   [f => $L->{l5},
         "<input type=text name=ticker size=10  maxlength=20 value=\"$renv->{ticker}\">" ,2],
   [l => $L->{l6} ],
   [f => $L->{l7},
         "$err8<input type=text size=40 maxlength=60 name=site_name value=\"$renv->{site_name}\"> $man" ],
   [f => $L->{l8},
         "<input type=text size=30 maxlength=50 name=site_address value=\"$renv->{site_address}\">" ],
   [f => $L->{l9},
         "<input type=text size=30 maxlength=50 name=site_city value=\"$renv->{site_city}\">$man" ],
   [f =>  $L->{l10},
         "<input type=text size=10 maxlength=20 name=site_state value=\"$renv->{site_state}\">" ,1],
   [f =>  $L->{l11}, 
         "<input type=text size=15 maxlength=20 name=site_zip value=\"$renv->{site_zip}\">$man" ,2],
   [f => $L->{l12},
         "<input type=text size=30 maxlength=50 name=site_country value=\"$renv->{site_country}\">$man" ],
   [f => $L->{l13},
         "<input type=text size=30 maxlength=50 name=site_contact value=\"$renv->{site_contact}\">$man"],
   [f => $L->{l14},
         "<input type=text size=20 maxlength=40 name=site_contact_phone value=\"$renv->{site_contact_phone}\">",1 ],
   [f => $L->{l15},
         "<input type=text size=30 maxlength=50 name=site_email value=\"$renv->{site_email}\">", 2],

   [f => $L->{l16},
         "<select name=production><option value=Y $p_1>$G->{yes}<option value=N $p_2>$G->{no}</select>",undef,1 ],
   ]);

   print $o;
   if (!$deny) {
      print Html::Screen->button("<input type=submit name=ACTION_submit value=\"$G->{submit}\">");
   }
   print "</form>";
}

sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Config');
  my $renv = System->get_renv();


  my($error);
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  $info = "";
  my($categories) = Agent->findSelectableAgents($renv->{solution});
  my($warn2, $warn3, $cat);

  if ($q->{ACTION_b}) {
      require GUI::Hosts;
      GUI::Hosts::list($q);
      return;

  } elsif ($q->{ACTION_s}) {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
     for my $v ('logfile','t300logfile','st4logfile') {
        $q->{$v} =~ s/^\s+//;
        $q->{$v} =~ s/\s+$//;
     }
     if ($q->{t300logfile}) {
       if (!-f $q->{t300logfile}) {
         $warn2 = "<br><font color=red>". $G->expand('e_112',  $q->{t300logfile}) . "</font>";

       } elsif ($q->{t300logfile} !~ /\/var\/adm/) {
         $warn2 = "<br><font color=red>" . $L->expand('err_1') . "</font>";
       }
     }
     $q->{logfile} = "/var/adm/messages";
     if ($q->{logfile} && !-f $q->{logfile}) {
       $warn3 = "<br><font color=red>" . $G->expand('e_112', $q->{logfile});
     }
     my $cat = "";
     foreach my $m (@$categories) {
        my(@bb) = split(/=/, $m);
        $cat .= "$bb[0]|"  if ($q->{$bb[0]});
     }
     chop($cat) if ($cat);
     if (!$cat) {
       print Html->error($L->expand('host_upd.err_2'));
       $err6 = "<font color=red>$G->{mandat}</font>";
     }

     goto err2 if ($err6);

     for my $v ('logfile','t300logfile','st4logfile') {
        $renv->{$v}    = $q->{$v};
     }
     $renv->{datahost} = $q->{datahost} ? "Y":"N";
     $renv->{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
     $renv->{hostname} = System->hostname();
     if ($renv->{frequency} ne $q->{frequency}) {
        &main::log_change($L->expand('host_upd.err_3', $renv->{frequency}, $q->{frequency}));
     }
     $renv->{frequency}   = $q->{frequency} || 5;
     $renv->{local_event_log} = $q->{local_event_log};
     #$renv->{log_months}  = ($q->{local_event_log} eq "Y")? $q->{log_months} :"";

     if ($renv->{categories} ne $cat) {
        &main::log_change($L->expand('host_upd.err_4',$renv->{categories}, $cat));
     }
     $renv->{categories} = $cat;

     if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
        print $G->expand('e_100');
     } else {
        $info = Html->info($G->{conf_upd}, 0);
     }

  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
     $renv->{t300logfile} =~ s/^\s+//;
     $renv->{t300logfile} =~ s/\s+$//;
     if ($renv->{t300logfile} && !-f $renv->{t300logfile}) {
       $warn2 = "<br><font color=red>Warn: Cannot find $renv->{t300logfile}";
     }
     if ($renv->{logfile} && !-f $renv->{logfile}) {
       $warn3 = "<br><font color=red>Warn: Cannot find $renv->{logfile}";
     }
  }

err2:
  if ($err6) {
    foreach my $x ('frequency','production', 'local_event_log') {
       $renv->{$x} = $q->{$x} 
    }
    $cat = "";
    foreach my $m (@$categories) {
      my(@bb) = split(/=/, $m);
      $cat .= "$bb[0]|"  if ($q->{$bb[0]});
    }
    $renv->{categories} = $cat;
  }
  print Html->header2('admin.gen_maint.maintain_host');

  $c2 = "selected" if ($renv->{local_event_log} eq "Y");

  my $frequency = &main::select_frequency($renv);
  my $pings = $renv->{ping};
  $pings =~ s/\|/\n/g;
  $pings =~ s/\#/  #/g;
  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $modules_lynx;
  my $cnt = 0;
  foreach my $mod (@$categories) {
     $modules_html .= "</td><td valign=top>" if ($cnt++ %5 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if (index("|$renv->{categories}|", "|$bb[0]|") >= 0);
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
     $modules_lynx .= "<input type=checkbox name=$bb[0] $ck>: " . sprintf("%-15s", $bb[1]);
     $modules_lynx .= "\n                " if ($cnt % 2 == 0);
  }
  $modules_html .= "</table>";

  my $datahost = ($renv->{datahost} eq "Y") ? "checked":"";

  my $man = "<font size=+3 color=red><b>*</b></font>";
  my($p_1, $p_2);
  if ($renv->{production} eq "Y") {
     $p_1 = "selected";
  } else {
     $p_2 = "selected";
  }
  my $ck2 = ($renv->{show_monitored_only} eq "Y") ? "checked":"";
  my $o;
  my $lb1 = $L->expand('host_upd.l1');
  $o =<<EOF;

<body bgcolor=$main'BGCOLOR>
<form>
 <input type=hidden name=GO value=GUI::Config::upd>
<center>
$info
$error
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>

<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td></td>
<tr><td colspan=4 bgcolor=#666699><font color=white>
        <b>&nbsp;$lb1</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l2'}:&nbsp;</td>
    <td>&nbsp;$renv->{hostname} $renv->{solution_model}

<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l3'}:<br><a href=javascript:win1()>$L->{'host_upd.l4'}</td>
  <td colspan=3> $modules_html $err6
 </td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l5'}: </td>
   <td colspan=3>
     $frequency
   </td>
<tr>
   <td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l7'}: </td>
   <td colspan=3> <input type=checkbox name=datahost $datahost></td>
<tr> <td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l8'}: </td>
   <td colspan=3> <input type=checkbox name=show_monitored_only $ck2></td>


<tr><td colspan=4 bgcolor=#E0E0E0><b>&nbsp;$L->{'host_upd.l9'}:</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l10'}:</td>
    <td colspan=3><table border=1 cellspacing=0 cellpadding=2><tr><td>$renv->{logfile}</table>
<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_upd.l11'}:</td>
    <td colspan=3><input type=text name=t300logfile size=50 maxlength=60 value="$renv->{t300logfile}">$warn2

</table>
</table>
<b>
EOF

   print $o;
   if (!$deny) {
      print " <input type=submit name=ACTION_s value=\"$G->{submit}\"> ";
      print " <input type=submit name=ACTION_b value=\"$G->{back}\"> ";
   }
   print "</form>";
}
# <tr><td bgcolor=$main'LIGHT align=right>StorTools Log Directory:</td>
#    <td colspan=3><input type=text name=st4logfile size=50 maxlength=60 value="$renv->{st4logfile}">


1;
 
