package GUI::Devices;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Devices.pm,v 1.49 2002/09/19 15:43:55 ccadieux Exp $

use PDM;
use Launch;
use Serialize;
use GUI::Config;
use GUI::Hosts;
#
# List all devices, refer to GUIAdmin::<device>::addDevice and updDevice for 
# maintenance.

sub list {
 my($q) = @_;
 my($ho, $o, @devs);
 my $deny = Roles->verifyRole($q, "admin");
 my $G = Labels->read();
 my $L = Labels->read('GUI::Devices');
 my $ruser = System->get_ruser();
 

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }

  print "\n";

  if ($q->{ACTION_selected}) {
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    foreach my $e (keys %$q) {
       if (substr($e,0,4) eq "del_") {
          my $no = substr($e,4);
          $devs->[$no] = undef;     
       }
    }
    PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);

  } elsif ($q->{ACTION_all}) {
    ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
    PDM::ConfigFile->write( $renv, [], $hosts,$notifs);

  } elsif ($q->{ACTION_only}) {
    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;
    my $x;
    for ($x=0; $x <= $#$devs; $x++) {
      my $d = $devs->[$x];
      if (($q->{HOST} && $d->{host} eq $q->{HOST}) ||
          ($q->{HOST} eq "LOCAL" && !$d->{host}))  {
          $devs->[$x] = undef;
      }
    }
    print $G->expand('deleted', $q->{HOST});
    delete $q->{HOST};
    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

  } elsif ($q->{ACTION} eq "Push Slave Configs") {
    GUI::Hosts::push_slaves($q);
  }
  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;

  if (!$renv->{site_country}) {
     $q->{SITE_FIRST} = 1;
     GUI::Config::site($q);
     return;
  }

  $head = Html->header2("admin.gen_maint.maint_device");
  %H = ();
  $H{Master} = (-f System->get_home() . "/DATA/start")? "Y":"N";
  foreach $h (@$hosts) {
    $H{$h->{hostname}} = $h->{active};
  }
  my $sel;
  if ($#$dev > 100 && !$q->{HOST}) {
     $sel = "selected";
     $q->{HOST} = "LOCAL";
  }

  my($hostsD) = "<select name=HOST><option value=LOCAL $sel>$renv->{hostname}</option>";
  my(@H);
  foreach $h (@$hosts) {
     push(@H, $h->{hostname});
  }
  foreach $h (sort @H) {
     $sel = ($h eq $q->{HOST})? "selected":"";
     $hostsD .= "<option value=\"$h\" $sel>$h</option>";
  }
  $sel = ($q->{HOST} eq "")? "selected":"";
  $hostsD .= "<option value=\"\" $sel>$G->{all_hosts}</option>";
  $hostsD .= "</select>";

  $q->{sort} = 3 if (!$q->{sort});
  for ($x=0; $x <= $#$dev; $x++) {
     $d = $dev->[$x];
     next if ($ruser->{isCustomer} && $d->{mgmtLevel} eq "C");
     my $ho = $d->{host} || "LOCAL" ;
     next if ($q->{HOST} && $q->{HOST} ne $ho);
     $d->{no} = $x;
     $s = Serialize->hash_join($d);
     $loc = lc($d->{host}) || (System->hostname() . " (local)");
     if ($q->{sort} == 1) {
       $v = sprintf("%-30.30s %s", lc($d->{name}), $s);
     } elsif ($q->{sort} == 2) {
       $v = sprintf("%-30.30s %s", lc($d->{type}). $d->{name}, $s);
     } elsif ($q->{sort} == 3) {
       $v = sprintf("%-30.30s %s", $loc, $s);
     }
     push(@devs, $v);
  }
  my $urls = Launch->read();

  my($last, $cnt2);
  foreach $line (sort @devs) {
    $h = Serialize->hash_split(substr($line,31));
#   $h = $dev->[$x];
    $type = $h->{userLabel} || $h->{type};

    $ip  = $h->{ipno} || $h->{ip};
    $loc = $h->{host} || System->hostname();
    my $ix2 = index($loc, ".");
    $loc0 = $loc;
    $loc0 = substr($loc,0,$ix2) if ($ix2 > 0);

    $active = ($h->{active} eq "Y")? "On":"Off";
#   $rep_active = ($h->{report} eq "Y")? "Yes":"No";

    $col = ($active eq "Off") ? "#FFC0C0":"#C0F0C0";
    my($bold);

    if (!$q->{sort} || ($q->{sort} == 3)) {
      if ($loc ne $last) {
         $ho .= "<tr><td colspan=6></td>" if ($last);
         $bold = "<b>";
         $last = $loc;
      }
    }
    my $dh = $h->{datahost} || $loc0;
    my $WWN = $h->{wwn};
    my $wwn_err;
    if ($h->{type} eq "t3" && length($WWN) < 2) {
       $wwn_err = "<font color=red>$L->{'dev_list.err_1'}";
    }
    if ($h->{type} eq "t3" && (!$h->{key} || index($h->{key}, ". .") >= 0)) {
       $wwn_err .= "<font color=red>$L->{'dev_list.err_2'}";
    }
    $wwn_err = "<br>$wwn_err" if ($wwn_err);
    my $module = Modules->findFromClass('GUIAdmin', $h->{class});
    $lnk = "<a href=\"$Http::WEBPROC?GO=${module}->updDevice&no=$h->{no}\">$h->{name}</a>";

    if ($module) {
      my $mlist = {};
      if ($module->can("MAINTAIN")) {
         $mlist = $module->MAINTAIN();
      }
      my $xurl;
      foreach my $x (keys %$mlist) {
          $xurl  .= " | <a href=\"$Http::WEBPROC?GO=GUIAdmin::${b}::$x\">$mlist->{$x}</a>";
      }
    } else {
      $lnk = "$h->{name}";
    }
    $xurl = "<input type=checkbox name=del_$h->{no}>";
    my $l1;
    if ($urls->{$h->{type}}[0] ) {
        my $u_name = $urls->{$h->{type}}[0];
        my $u_value = $urls->{$h->{type}}[1];
        my $u_name2 = $urls->{$h->{type}}[2];
        my $u_value2 = $urls->{$h->{type}}[3];
        $u_value =~ s/\$ip/$h->{ipno}/;
        $u_value2 =~ s/\$ip/$h->{ipno}/;
        $launch = "&nbsp;<a href=$u_value target=apps><img src=/gif/urllink.gif alt=\"Launch $u_name\" border=0></a>";
        $launch .= "&nbsp;<a href=$u_value2 target=apps><img src=/gif/urllink.gif alt=\"Launch $u_name2\" border=0></a>" if ($u_name2);
        $l1 = "<table border=0 width=100% cellspacing=0 cellpadding=0><tr><td>$lnk</td><td align=right>$launch</table>";
     } else {
        $l1 = $lnk;
     }

    $ho .= "<tr>
                <td $col>$bold &nbsp;$loc0 </td>
                <td>$l1</td>
                <td><center>$type</td>
                <td><center><a href=$Http::WEBPROC?GO=GUI::Devices::comments&key=$h->{key}>Info</a></td>
                <td>$ip&nbsp;</td>
                <td>$WWN$wwn_err&nbsp;</td>
                <td><b><center>$G->{$active}</td>
                <td nowrap><center>&nbsp;$xurl</td>
           ";
    $bold="";
    $cnt2++;
  }
  if ($cnt2 == 0) {
     $ho .= "<tr><td colspan=3><b>$L->{'dev_list.err_3'}</td>";
  }

  my $comment = GUI->needToPush($hosts);
  my $cnt = $#devs + 1;
  $o =<<EOF;

<body bgcolor=$main'BGCOLOR>
<form method=get>
 <input type=hidden name=GO value=GUI::Devices::list>
<center>
$head
$q->{ERR}
$comment
<table border=1 cellspacing=0 width=90% bgcolor=white>
<tr><td colspan=8 bgcolor=#666699>
  <table border=0 cellspacing=0 cellpadding=0 width=100%>
    <tr><td nowrap><b><font color=white>&nbsp;$L->{'dev_list.l1'}</td>
    <td align=right width=10% nowrap><font color=white>&nbsp;<b>$G->{host}: $hostsD<input type=submit name=ACTION value=GO></td><td></form></td>
  </table>
<tr>
    <td bgcolor=$main'LIGHT><center><b>
        <form>
        <input type=hidden name=GO value=GUI::Devices::list>
        <input type=hidden name=HOST value=\"$q->{HOST}\">
        <a href=$Http::WEBPROC?GO=GUI::Devices::list&sort=3&HOST=$q->{HOST}>$G->{primary_host}</a></td>
    <td bgcolor=$main'LIGHT><center><b>
        <a href=$Http::WEBPROC?GO=GUI::Devices::list&sort=1&HOST=$q->{HOST}>$L->{'dev_list.l3'}</a></td>
    <td bgcolor=$main'LIGHT><center><b>
        <a href=$Http::WEBPROC?GO=GUI::Devices::list&sort=2&HOST=$q->{HOST}>$L->{'dev_list.l4'}</a></td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'dev_list.comment'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'dev_list.l5'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'dev_list.l6'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'dev_list.l7'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'dev_list.l8'}</td>
$ho
</table>
&nbsp;<br>
EOF
   print $o;
   if (!$deny) {
     my $del_host;
     my $h1 = $q->{HOST};
     if ($cnt && $h1 &&  $h1 !~ /^\d+\.\d+\./) {
        my $ix = index($h1, ".");
        $h1 = substr($h1,0,$ix) if ($ix > 0);
        $del_host =  "<input type=submit name=ACTION_only value=\"" . 
         $L->expand('dev_list.submit1', $h1) . "\" onclick=\"return confirm('" . 
         $L->expand('dev_list.l10', $h1) . "')\">&nbsp;";
     }
     print <<EOF;
<table border=0 width=90%>
 <tr><td><center><b>
      <input type=submit name=ACTION_all value="$L->{'dev_list.submit2'}"
         onclick="return confirm('$L->{'dev_list.l11'}')">&nbsp;
      $del_host
     </td>
     <td align=right><b><input type=submit name=ACTION_selected value=\"$L->{'dev_list.submit3'}\">
 </table>
</form>
EOF
    }
}

sub comments {
  my($q) = @_;

  my $G = Labels->read();
  my $L = Labels->read('GUI::Devices')->section("comments");
  print Html->body();
  my $key = $q->{key};

  if ($q->{ACTION_back}) {
    &list($q);
    return;
  }
  my $deny = Roles->verifyRole($q, "admin|c_admin");
  my $button;
  if (!$deny) {
    $button = "<b><input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  
  print Html->header2("admin.gen_maint.maint_device", undef, $L->{comment}, 
      undef, {noDoc => 1});

  if ($q->{ACTION_update}) {
    my $comment = Util->deserialize("Comments.txt") || {};
    $q->{comments} =~ s/\r//g;
    $q->{comments} =~ s/\n /\n/g;
    $comment->{$key} = $q->{comments};
    Util->serialize("Comments.txt", $comment);
    print Html->info($L->{updated});
  }
  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  
  my $dev1 = $Config->deviceByKey($q->{key});
  my $comment = Util->deserialize("Comments.txt") || {};
  my $co = $comment->{$key};
  print <<EOF;
<table border=1 cellspacing=0 width=90% bgcolor=white cellpadding=2>
  <tr><td bgcolor=#666699 colspan=2>
      <form><input type=hidden name=GO value=GUI::Devices::comments>
      <input type=hidden name=key value="$q->{key}">
      <font color=white><b>$L->{enter_info}
      </td>
  <tr><td align=right bgcolor=#CCCCFF> Device:</td>
      <td><b>$dev1->{name} </td>
  <tr><td bgcolor=#CCCCFF align=right>IP:</td>
      <td> $dev1->{ipno} &nbsp;</td>
  <tr><td bgcolor=#CCCCFF align=right>$L->{comment}:</td>
    <td ><textarea name=comments cols=80 rows=20>$co</textarea></td>
  </table>
   $button
     &nbsp;<td align=right><b><input type=submit name=ACTION_back value=\"$G->{back}\">
    </form>
EOF
}


sub add {
  my ($q) = @_;
  print Html->body();

  my $deny = Roles->verifyRole($q, "admin");
  if ($deny) {
    print $deny;
    return;
  }
  print &add0($q);
}

sub add0 {
  my($q) = @_;
  my $add ;
  my $categories = Modules->load("GUIAdmin");
  my $L = Labels->read("GUI::Devices")->section("dev_list");

  $add = "<table border=0 width=80%>";
  my $cn = 0;
  foreach my $cat (@$categories) {
    my $fun = "GUIAdmin::${cat}";
    if ($fun->isDevice() ) {
       my $desc = $fun->description() ;
       my $b = ($cat eq $q->{ADD}) ? "<b>": "";
       $add .= "<td>$b<a href=\"$Http::WEBPROC?GO=GUIAdmin::${cat}->addDevice\">" .($desc||$cat) . "</a></td>";
       $cn++;
       $add .= "<tr>" if ($cn % 3 == 0);
    }
  }
  $add .= "</table>";

  my $h = Html->header2("admin.gen_maint.add_device");
  return "
    $h
   <table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=#666699>
   <table border=0><tr><td><b><font color=white>&nbsp;$L->{select}
   </table></td>
   <tr><td colspan=3 bgcolor=white><center>$add</td>
   </table>";

}

sub selectList {
  my($q) = @_;

}


1;
