package GUI::Errlog;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Errlog.pm,v 1.17 2002/09/19 15:43:55 ccadieux Exp $

use System;
use Util::Http;
use Html;

sub list {
  my($q, $post) = @_;
  my(@S, $out, $tabs);
  my($renv) = System->get_renv();
  my($acronym) = $renv->{GSV_ACRONYM};
  my $L = Labels->read("GUI::Errlog"); 
  print "\n";
  print "<body bgcolor=$main'BGCOLOR>";

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $hid = System->hostid;

  $h = Html->header2("monitor.log.errors");

  $out = "<center>
   $h
 <table border=0 cellpadding=4 width=90% bgcolor=white><tr><td>$head</table>
 <table border=0><tr><td></table>
   <table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=#666699><b><font color=white>$L->{select}</td>
   <tr bgcolor=$main'LIGHT><th>$L->{host}</th>
       <th>$L->{hostid}</th>
       <th>$L->{location}</th>
   <tr><td><a href=$Http::WEBPROC?GO=GUI::Errlog::detail&loc=master&name=Master>$L->{master}</a></td>
       <td>$hid</td>
       <td>&nbsp;</td>
   ";
  my(@H);
  foreach $h (@$host) {
    push(@H, "$h->{hostname} | $h->{ip} | $h->{hostid}");
  }
  foreach $h (sort @H) {
    my($h_hostname, $h_ip, $h_hostid)  = split(/ \| /, $h);
    $out .= "<tr><td><a href=$Http::WEBPROC?GO=GUI::Errlog::detail&loc=$h_ip&name=$h_hostname>$h_hostname</a></td>
                 <td>$h_hostid</td>
                 <td>$h_ip</td>
            ";
    $cnt++;
  }
  $out .= "</table>";

  print $out;
}

sub detail {
  my($q, $post) = @_;
  my($renv)    = System->get_renv();
  my($acronym) = $renv->{GSV_ACRONYM};
  my $L = Labels->read("GUI::Errlog"); 

  print "\n<body bgcolor=$main'BGCOLOR>";
  $h = Html->header("Error Logfiles: $q->{name}", "95%");
  if ($q->{max} =~ /^\d+/) {
     $MAX = $q->{max} + 0;
  } else {
     $MAX = 25;
  }

  $out = "<center>$h
  <table border=1 cellspacing=0 cellpadding=1 width=95% bgcolor=white>
   <form  method=get>
      <input type=hidden name=GO value=GUI::Errlog::detail>
      <input type=hidden name=loc value=$q->{loc}>
      <input type=hidden name=name value=$q->{name}>
   <tr><td colspan=3 bgcolor=#666699>
     <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td>
         <font color=white>&nbsp;<b>$MAX $L->{recent}</td>
      </td><td align=right>
       <font color=white><b>$L->{errors}:<small>
     <input type=text name=max size=3 value=$MAX>&nbsp;
     <input type=submit name=ACTION value=Refresh>
   </td></table></table></center><pre>";

  if ($q->{loc} eq "master") {
    print "$L->{accessing}<br>";
    $q->{max} = $MAX;
    $out .= &get_readlog($q);

  } else {
    print "$L->{accessing1}<br>";

    $out .= Util::Http->getCommand( $q->{loc},
                   "GUI::Errlog::readlog&max=$MAX&http=1", 30) || "Error";
  }

  $out .="&nbsp;<p>&nbsp;</form>";
  print $out;

}

sub get_readlog {
  my($q) = @_;
  my($out, $cnt, $cnt2, $cnt3, @S, @a);

  my($MAX) = $q->{max} || 40;

  if (!open(O, System->get_home() . "/log/errors.log")) {
    if ($q->{http}) {
       print "error.log is empty ($!)";
    } else {
       return "error.log is empty ($!)";
    }
  }
  $cnt = 0;
  while ($l = <O>) {
     next if (length($l) <= 2);
     $cnt = 0 if ($cnt > $MAX);
     $S[$cnt] = $l;
     $cnt++;
  }
  close(O);
  $cnt2 = $cnt - 1;
  $cnt2 = $MAX if ($cnt < 0);
  $cnt3 = 0;
  while ($cnt3 < $MAX) {
    @a = split(/ +/, $S[$cnt2], 4);
    $out .=  "   $a[0]  $a[1]  $a[2]   $a[3]";
    $cnt2--; $cnt3++;
  }
  if ($q->{http}) {
    print $out;
  } else {
    return $out;
  }
  
}

1;
