package GUI::FCCheck;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Util;
use System;
use strict "vars";
use Html;
use Util::Http;
use PDM::ConfigFile;
use Thresholds;
use FC;
use Process;
use Agent;

sub run {
  my($q) = @_;
  my($hostname, $mach, $h, $x);
  print Html->body();
  my $deny = Roles->verifyRole($q, "admin");
  my $L = Labels->read("GUI::FCCheck");
  
  if ($q->{ACTION_start} || $q->{ACTION_com}) {
       
     my $cats;
     foreach my $x (keys %$q) {
        if (substr($x,0,4) eq "sel_") {
           $cats .= substr($x,4) . "|";
        } 
     }
     my $st = Process->status($q->{HOST}, "FCCheck");

     if ($q->{ACTION_start} && $st =~ /Running/) {
        print Html->error("FCCheck already running!");
     } elsif (!$cats) {
        print Html->error("Select at least one category!");
     } else {
       chop($cats);
       my $hostp = "-h $q->{HOST} " if ($q->{HOST});
       my $command = System->get_home() . "/bin/ras_fccheck $hostp -c \"$cats\" -b -d 2";

       if ($q->{ACTION_start}) {
         system($command);
         print $L->expand(please => $command);
       } else {
         print $L->{command} . ": $command<br>";
       }
     }
  }
  $hostname = System->hostname();

  my($renv, $devs, $hosts,$notifs, $Config) = PDM::ConfigFile->read;

  print Html->header2("diagnose.tools.fcc");

  my $con = Agent->stor_conflicts();
  if ($con) {
    print "&nbsp;<br>";
    print Html->error("Info: '$con'.  <br>Return back to this function when '$con' ends.");
  } else {
    my $l = "=Local|";
    my @H;
    my $categories = $Config->findActiveCategories( $renv->{hostname} );
    foreach my $h (@$hosts) {
      push(@H, "$h->{hostname}=$h->{ipno}");
      if ($h->{ipno} eq $q->{HOST}) {
          $categories = $Config->findActiveCategories( $h->{hostname} );
      }
    }
    my $select = "<select name=HOST onchange=form.submit()><option value=\"\">Local";
    foreach my $h (sort @H) {
      my($name, $ipno) = split(/\=/, $h);
      my $ck;
      if ($ipno eq $q->{HOST}) {
         $ck = "selected";
      }
      $select .= "<option value=$ipno $ck>$name";
    }
    $select .= "</select>";
    my $cats;
    my $mods = Modules->load("Agent");
    foreach my $m (sort @$mods) {
       my $func = "Agent::$m";
       my $desc = $func->isSelectable();
       my $ck = (index($categories, lc($m)) >= 0) ? "checked": "";
       if ($func->can("FCCounters") && $ck) {
          $cats .= "<input type=checkbox name=sel_$m $ck>: $desc<br>";
       }
    }
    my $start = "<input type=submit name=ACTION_start value=\"$L->{start}\">" if (!$deny);
    print "<form>
          <input type=hidden name=GO value=GUI::FCCheck::run>
     <table border=1 cellspacing=0 width=90% bgcolor=white>
     <tr><td bgcolor=#CCCCFF align=right><b>$L->{select}: </td>
         <td><table border=0><tr><td><b>$select <input type=submit name=ACTION value=GO></table></td>
     <tr><td bgcolor=#CCCCFF align=right><b>$L->{cat}: </td>
         <td>$cats &nbsp;</td>
     </table>
     <table border=0><tr><td></table>
    <b>$start
    <b><input type=submit name=ACTION_com value=\"$L->{comm}\">
    </form>";
  }
}

sub readLastReport {
  my($q) = @_;
  my $renv = System->get_renv();
  my $host = $q->{host};

  my $R = Process->read($host, "FCCheck");

  print Html->body();
  print Html->header2('diagnose.tools.fc_report');
  print "<table border=0><tr><td></table>";
  my $L = Labels->read("GUI::FCCheck");

  my $h = $R->{header};
  my $info = $R->{info};
  my $ho = $host || $renv->{hostname};

  print "</center><pre>$info->{log}</pre><center>" if ($info->{log});

  print "<table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr><td colspan=9><b>$L->{host}: $ho, $L->{created}: $info->{created}
   <tr bgcolor=#CCCCFF>
   <th>$h->[0]
   <td><b>$h->[1]
   <td><b>$h->[2]
   <td><b>$h->[3]
   <td><b>$h->[4]
   <td><b>$h->[5]
   <td><b>$h->[6]
   <td><b>$h->[7]
   <td><b>$h->[8]
   ";
   my $rows = $R->{data};
   foreach my $r (@$rows) {
       print "<tr><td>$r->[0]<td>$r->[1]<td>$r->[2]<td>$r->[3]<td>$r->[4]<td>$r->[5]".
             "<td>$r->[6]<td>$r->[7]<td>$r->[8]";
       print "<tr><td>&nbsp;<td colspan=8><small>$r->[9]" if ($r->[9]);
   }
   if ($#$rows < 0) {
      print "<tr><td colspan=9><b>$L->{nothing}</td>";
   }
   print "</table>";
}
  



1;
