package GUI::Hosts;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Hosts.pm,v 1.79 2002/09/19 15:43:56 ccadieux Exp $

use Net::Ping;
use Util::Http;
use System;
use GUI::Config;
use GUIAdmin;
use Events;
use Agent;
use GUI;
use Logic::Slave;

# new one is pushSlaves, old is push_slaves

sub pushSlaves {
  my($q) = @_;
  my ($x);
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');
  print Html->body();

  if (my $deny = Roles->verifyRole($q, "admin")) {
     print $deny;
     return;
  }
  my ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;

  if ($q->{ACTION_u} || $q->{ACTION_a} ) {
     my $list = ",";
     foreach my $x (keys %$q) {
        if (substr($x,0,4) eq "sel_") {
          $list .= substr($x,4) . ",";
        }
     }
     %T = (C => $L->expand('push.p_c'), M => $L->expand('push.p_m'), 
           B => $L->expand('push.p_b') );
     my $cntS = 0;
     foreach my $h (@$hosts) {
        if ($q->{ACTION_a} || index($list, ",$h->{hostname},") >= 0) {
           print "'$T{$q->{action}}' :  $h->{hostname} /$h->{ip} ... <br>";
           $cntS++;
           if ($q->{action} eq "C" || $q->{action} eq "B") {
             my $rc = Logic::Slave->push($h) ;
             print substr($rc,3) if ($rc);
           }
           if ($q->{action} eq "M" || $q->{action} eq "B") {
              if ($q->{master}) {
                Util::Http->saveFile($h->{ipno} || $h->{hostname}, "MASTER", $q->{master});
                print $L->expand('push.err_1', $q->{master}, $h->{hostname});
              } else {
                print $L->expand('push.err_2', $h->{hostname});
              }
           }
        }
     }
     if ($cntS) {
       PDM::ConfigFile->write($renv, $dev, $hosts, $notifs);
     } else {
       print " <b><font color=red>--> $G->{nothing_sel}</font></b><br>\n";
     }
  }
  print Html->header2("admin.gen_maint.push" );

  if ($#$hosts < 0) {
    print "<center><h2><font color=red>$G->{no_slave}";
    return;
  }

  my $m = System->ifconfigs();
  my $master_list = "<select name=master><option value=\"\">[$G->{no_change}]";
  foreach my $x (@$m) {
     next if ($x->[1] eq "127.0.0.1");
     $master_list .= "<option value=\"$x->[1]\">$x->[0]: $x->[1]</option>";
  }
  $master_list .= "</select>";
  my $S = Util->makeSelect("action", 
        "C=$L->{'push.p_c'}|M=$L->{'push.p_m'}|B=$L->{'push.p_b'}", $q->{action});

  print "<table border=1 cellspacing=0 bgcolor=white width=90%>
  <form><input type=hidden name=GO value=GUI::Hosts::pushSlaves>
  <tr><td colspan=2 bgcolor=#666699><font color=white><b>$G->{select_action}
  <tr><td colspan=2>
    <table border=0 cellpadding=4 cellspacing=1 bgcolor=#CCCCFF width=100%>
       <tr><td><b> $S </td>
       <td><b>$L->{'push.l1'}:
             <td><b>$master_list</td>
    </table>
  <tr><td colspan=2 bgcolor=#666699><b><font color=white>$L->{'push.l2'}</td>";

  my $tot = $#$hosts + 1;
  my $row1 = int($tot / 2);

  my ($col1, $col2, $col3, @L);
  foreach $h (@$hosts) {
    push(@L, $h->{hostname});
  }
  @L = sort @L;

  if ($#$hosts >= 0) {
    for ($x = 0; $x < $row1; $x++) {
      my $h = $L[$x];
      $col1 .= "<input type=checkbox name=sel_$h> $h<br>";
    }

    for ($x = $row1; $x <= $#$hosts; $x++) {
      my $h = $L[$x];
      $col2 .= "<input type=checkbox name=sel_$h> $h<br>";
    }

    print "<tr><td>$col1&nbsp;</td><td>$col2&nbsp;</td>";
  }  else {
    print "<tr><td colspan=2><b>&nbsp;<font color=red>$L->{'push.err_3'}</td>";
  }

  print "</table>
   <table border=0 width=90%>
   <tr><td><b><input type=submit name=ACTION_u value=\"$L->{'push.submit1'}\">
       <td align=right><b><input type=submit name=ACTION_a value=\"$L->{'push.submit2'}\">
   </table>
        ";
  
  
  #&push_slaves($q);
  #&list($q);
}


sub list {
  my($q) = @_;
  my($ho, $o);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');

  print "\n";
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }


  if ($q->{ACTION_1}) {
     &add($q);
     return;
  } elsif ($q->{ACTION_3}) {
     &pushSlaves($q);
     return;
  }
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  if (!$renv->{site_country}) {
     $q->{SITE_FIRST} = 1;
     GUI::Config::site($q);
     return;
  }
  my($ping) = ($q->{ACTION_2})? 1:0;

  $head  = Html->header2("admin.gen_maint.maintain_hosts");

  my(%CNT);

  for ($x=0; $x <= $#$dev; $x++) {
    $h = $dev->[$x];
    $CNT{$h->{host} || "LOCAL"}++;
    if (!$h->{host}) {
       $dev_cnt++;
    }
  }
  my @H;
  for ($x=0; $x <= $#$host; $x++) {
     push(@H, "$host->[$x]{hostname} | $x");
  } 
  foreach my $h2 (sort @H) {
    my ($name1, $x) = split(/ \| /, $h2);
    my ($hostid, $version);
    $h = $host->[$x];
    $lnk = "<a href=$Http::WEBPROC?GO=GUI::Hosts::upd&no=$x><b>$h->{hostname}</b></a>";
    use Net::Ping;
    $p = Net::Ping->new();

    $alive = "";
    if ($ping) {
      if ($h->{active} eq "N") {
        $alive = "(Inactive)";
      } else {
        print "Pinging $h->{ip}...<br>";
        $ix = index($h->{ip}, ":");
        $ip = ($ix > 0)? substr($h->{ip},0,$ix) : $h->{ip};
        eval {
          $alive   = ($p->ping($ip,4))? $L->{alive} : $L->{unaccessible};
        };
        my $ss = Util::Http->getCommand($h->{ip},"INFO1", 30) || "Error";
        if ($ss ne "Error") {
          ($hostid, $version) = split(/ *\| */, $ss);
          $h->{hostid} = $hostid if (!$h->{hostid});
        }
      }
    }
    $cnt = $CNT{$h->{hostname}} + 0;
#    use POSIX2;
#    if ($h->{last_push}) {
#       $push .= POSIX::strftime("%b", 0,0,0,0,substr($h->{last_push},0,2),0) 
#                . substr($h->{last_push},2);
#    }
    $active = $h->{active} || "N";
    my $c1 = ($active eq "N")? "bgcolor=#FFC0C0":"";
    $x2 = "&nbsp;$alive";
    $x2 .= "/ $hostid - $version" if ($hostid);
    $am = $h->{role} eq "AM" ? $G->{alt}: $G->{slave}; 
    my $sol= "SE-".$h->{solution_model} if ($h->{solution} eq "Y");

    $push = $h->{last_push};
    if ($push =~ /FAILED/) {
      $push = "<td nowrap bgcolor=#F0D0D0>&nbsp;$push</td>";
    } else {
      $push = "<td nowrap>&nbsp;$push</td>";
    }

    $ho .= "<tr>
                <td>$lnk</td>
                <td>$am $sol</td>
                <td align=right>$cnt&nbsp;</td>
                <td>$h->{ipno}</td>
                $push
                <td $c1><center>$active</td>
                <td>$x2</td>
          ";
  }
  if ($ping) {
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
  }
  $comment = GUI->needToPush($host);

  $hid   =  System->hostid(); 
  $hname = System->hostname();
  $ip    = System->local_ip;

  if ($#$host < 0) {
     $ho .= "<tr><td colspan=7><br>$L->{'hosts.no_sl'}</td>";
  }
  $local_active = (-f System->get_home() . "/DATA/start")? "Y":"N";
  my $c1 = ($local_active eq "N")? "bgcolor=#FFC0C0":"";
  my $sol= "SE-".$renv->{solution_model} if ($renv->{solution} eq "Y");

  $o =<<EOF;

<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::list>
<center>
$head
$q->{ERR}
 $comment
<table border=0><tr><td></table>
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
<tr><td colspan=7 bgcolor=#666699>
  <table border=0 cellspacing=0 width=100% cellpadding=2><tr>
    <td><b><font color=white>&nbsp;$L->{'hosts.l1'}</td>
    <td align=right><b>
       <font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Hosts::updAll><font color=white>$L->{'hosts.l2'}</font></a> ]
  </table>
<tr>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.l3'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.type'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.l4'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.l5'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.l6'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.l7'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'hosts.l8'}</td>
<tr>
    <td><b><a href=$Http::WEBPROC?GO=GUI::Config::upd>$hname</a></td>
    <td><b>$G->{master} $sol</td>
    <td align=right>$CNT{LOCAL}&nbsp;</td>
    <td>$ip</td>
    <td>&nbsp;$G->{na}</td>
    <td $c1><center>$G->{$local_active}</td>
    <td>&nbsp;</td>
$ho
</table>
&nbsp;<br>
<b>
EOF
   print $o;
   if (!$deny) {
      print <<EOF;
<input type=submit name=ACTION_1 value="$L->{'hosts.submit1'}">
<input type=submit name=ACTION_2 value="$L->{'hosts.submit2'}">
<input type=submit name=ACTION_3 value="$L->{'hosts.submit3'}">
</form>
EOF
   } 
}


sub push_slaves {
  my($q, $hostlist) = @_;

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read();
  foreach $h (@$hosts) {
     next if ($hostlist and index(",$hostlist," , ",$h->{hostname},") < 0);
     print "Pushing Config to $h->{hostname} /$h->{ip} ... <br>";
     my $rc = Logic::Slave->push($h);
     print substr($rc,3) if ($rc);
  }
  PDM::ConfigFile->write($renv, $dev, $hosts, $notifs);
}



sub add {
  my($q) = @_;
  my($ho, $o, $err, $cat, $err1);

  print "\n";
  my($categories) = Agent->findSelectableAgents();
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_add}) {
    $q->{hostid} = lc($q->{hostid});
    while (1) {
     if ($q->{hostid} eq System->hostid) {
        $err = $L->expand('host_add.err_1') . "<br>";
        last;
     } elsif ($err1) {
        $err1 = "<font color=red>$err1</font>";
        $err .=  $L->expand('host_add.err_1') ;
        last;
     } elsif (!$q->{hostname}) {
        $err .=  $L->expand('host_add.err_3') ;
        last;
     } else {
        $done = 0;
        if (index($q->{hostname} , ".") < 0) {
           $save = $q->{hostname};
           $q->{hostname} .= "." . lc(System->domain());
           $ipno = Util->name2ip($q->{hostname});
           if (!$ipno) {
             $q->{hostname} = $save;
           } else {
             $done = 1;
           }
        }
        if (!$done) {
          $ipno = Util->name2ip($q->{hostname});
          if (!$ipno) {
             $err .= $G->expand("host_add.e_111", $q->{hostname});
             last;
          }
        }

        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        foreach $x (@$host) {
          $x->{role} = "S" if ($q->{role});
          foreach $tag ('hostid','hostname') {  # ip
            if ($x->{$tag} eq $q->{$tag}) {
              $err .= $L->expand('host_add.err_4', $tag);
              last;
            }
          }
        }
        $x = $#$host + 1;
        $cat = "";
        foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          $cat .= "$bb[0]|" if ($q->{$bb[0]});
        }
        my $rc = Util::Http->getCommand($q->{hostname}, "hostinfo",  60) || "Error";
        my($hostid, $master) = split(/\t/, $rc);

        if ($hostid ne "Error") {
           $host->[$x]{hostid}   = $hostid;
        } else {
           if ($q->{hostid} !~ /^\w\w\w\w\w\w\w\w$/ && lc(System->os) !~ /linux/) {
             $err .= $L->expand('host_add.err_5') . "<br>";
             last;
           }
           $host->[$x]{hostid}   = $q->{hostid};
        }
        if (!$master) {
            print Html->warning($L->expand('host_add.err_6', $q->{hostname}));
            #last;

        } elsif (Util->name2ip($master) ne Util->name2ip($renv->{hostname})) {
             $err .= $L->expand('host_add.err_7', $master); 
             last;
        }
        chop($cat) if ($cat);
        $host->[$x]{categories} = $cat;
        $host->[$x]{_name}    = "host" . ($x+1);
        $host->[$x]{hostname} = $q->{hostname};
        $host->[$x]{ip}       = $q->{hostname};
        $host->[$x]{active}   = "N";
        $host->[$x]{role}     = $q->{role}? "AM" : "S";
        $host->[$x]{ipno}     = Util->name2ip($q->{hostname});
        $host->[$x]{datahost} = $q->{datahost} ? "Y":"N";
        $host->[$x]{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
        $host->[$x]{frequency}= $q->{frequency} || 10;
        $host->[$x]{contract} = $q->{contract} if ($q->{contract});
        $host->[$x]{logfile}  = "/var/adm/messages";
        $host->[$x]{t300logfile} = $q->{t300logfile} ;
        $host->[$x]{st4logfile} = $q->{st4logfile} ;
#        $q->{ping} =~ s/ *[\|\:\#]+ */#/g;
#        $q->{ping} =~ s/ *[\n\r]+ */|/g;
#        $host->[$x]{ping}       = $q->{ping};

        GUIAdmin->clearSlave($q->{hostname}, $host);
        unlink System->get_home() . "/DATA/snapshot_db";

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print Error->error(101, $CONF)->toHtml();
           
        } else {
           $info = Html->error($L->expand('host_add.added'));
#           &main::save_event("AH", $q->{hostid});
           print $L->expand('host_add.added');
        }
        &list($q);
        return;
      }
    }
  }


  $h = Html->header2("admin.gen_maint.add_hosts");
  print Html->error($err) if ($err);

  $q->{logfile}     = "/var/adm/messages";
  $q->{st4logfile} = "/var/opt/SUNWstade/log/diags";

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 5 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if ($q->{$bb[0]});
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  $frequency = &main::select_frequency($q);


  $o =<<EOF;
<body bgcolor=#F0F0F0>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::add>
<center>
$h
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>

<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=#666699><b><font color=white>&nbsp;Enter Host Information</td>
<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{'host_add.l1'}:</td>
    <td colspan=3><input type=text name=hostid size=8 maxlength=8 value="$q->{hostid}">
<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{'host_add.l2'}:</td>
    <td colspan=3><input type=text name=hostname size=40 maxlength=40 value="$q->{hostname}">

<tr><td bgcolor=$main'LIGHT align=right nowrap>$L->{'host_add.l3'}:</td>
    <td colspan=3><input type=ip size=20 maxlength=20 name=contract value="$q->{contract}">

<tr><td bgcolor=$main'LIGHT align=right>
     &nbsp;$L->{'host_add.l4'}<br><a href=javascript:win1()>$L->{'host_add.l5'}</td>
 <td colspan=3>
   $modules_html
 </td>
<tr><td bgcolor=$main'LIGHT align=right>
     &nbsp;$L->{'host_add.l6'}: </td>
    <td colspan=3>$frequency</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_add.l7'}: </td>
    <td colspan=3><input type=checkbox name=role></td>
<tr>
    <td bgcolor=$main'LIGHT align=right>$L->{'host_add.l9'}: </td>
    <td ><input type=checkbox name=datahost></td>
<tr><td align=right bgcolor=$main'LIGHT width=40%>
     $L->{'host_add.l10'}: </td>
    <td>&nbsp;<input type=checkbox name=show_monitored_only>


<tr><td colspan=4 bgcolor=silver><b>&nbsp;>$L->{'host_add.l11'}</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_add.l12'}:</td>
    <td colspan=3><table border=1 cellspacing=0><tr><td>$q->{logfile}</table></td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_add.l13'}:</td>
    <td colspan=3><input type=text name=t300logfile size=50 maxlength=60 value="$q->{t300logfile}">

<!--
<tr><td bgcolor=$main'LIGHT align=right>$L->{'host_add.l14'}:</td>
    <td colspan=3><input type=text name=st4logfile size=50 maxlength=60 
      value="$q->{st4logfile}">
-->


</table>
</table>
<b>
<input type=submit name=ACTION_add value=\"$L->{'host_add.submit1'}\">
<input type=submit name=ACTION_back value=\"$L->{'host_add.submit2'}\">
</form>
EOF

  print $o;

}


#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$q->{ping}</textarea></td>

sub upd {
  my($q) = @_;
  my($ho, $o, $err2);
  my($name, $err);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');

  print "\n";
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $h = $host->[$q->{no}];
  my($categories) = Agent->findSelectableAgents($h->{solution});

  if ($q->{ACTION_back}) {
    &list($q);
    return;
  } elsif ($q->{ACTION_delete}) {
    $x = $q->{no};
    $hostid = $host->[$x]{hostid};
    my $hn = $host->[$x]{hostname};
    unlink(System->get_home() . "/DATA/topo/$hn") if ($hn);
    $host->[$x]{_name} = "";
    unlink System->get_home() . "/DATA/REMOTE_LISTS/" . $host->[$x]{hostname};

    $name = $host->[$x]{hostname} . "/ " . $host->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change($L->expand('deleted',  $name));
    $q->{ERR} = Html->error($L->expand('deleted', $name)); 
    Events->saveEvent("DH", $hostid);

    $rc = Util::Http->getCommand($host->[$x]{ip}, "DELET&file=start",  30);


    &list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    $q->{hostid} = lc($q->{hostid});
    while (1) {
#     if ($q->{ping}) {
#        @a = split(/ *[\n\r]+ */, $q->{ping});
#        $err1 = "";
#        foreach $p (@a) {
#           @l = split(/ *[\:\|\#] */, $p);
#           if (!(-d $l[0] || -f $l[0])) {
#              $err1 .= "Cannot read path: $l[0]<br>";
#           }
#        }
#     }
     if ($err1) {
        $err1 = "<font color=red>$err1</font>";
        $err = Html->error($L->{err_1});
        last;
     } elsif ($q->{hostid} eq System->hostid) {
        $err = Html->error($L->{err_2});
        last;
     } else {
        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        $x = $q->{no};
        $cat = "";
        foreach my $h (@$host) {
             $h->{role} = "S" if ($q->{role});
        }
        foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          $cat .= "$bb[0]|" if ($q->{$bb[0]});
        }
        chop($cat) if ($cat);
        my($H) = $host->[$x];

        if ($H->{categories} ne $cat) {
          &main::log_change($L->expand('err_3',$H->{hostname}, $H->{categories}, $cat) );
        }
        $host->[$x]{categories} = $cat;

        $host->[$x]{role}     = $q->{role} ? "AM" : "S";
        if (!$host->[$x]{ipno}) {
           $host->[$x]{ipno} = Util->name2ip($host->[$x]{hostname});
        }
        $host->[$x]{last_push}  = "";
        $host->[$x]{contract} = $q->{contract};
        if ($H->{frequency} ne $q->{frequency}) {
           &main::log_change($L->expand('err_4', $H->{hostame}, $H->{frequency}, $q->{frequency}));
        }
        $host->[$x]{frequency}= $q->{frequency} || 5;
        $host->[$x]{datahost} = $q->{datahost} ? "Y":"N";
        $host->[$x]{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
        $host->[$x]{logfile}  = "/var/adm/messages";
        $host->[$x]{t300logfile} = $q->{t300logfile} ;
        $host->[$x]{st4logfile} = $q->{st4logfile} ;
#        $q->{ping} =~ s/ *[\|\:\#] */#/g;
#        $q->{ping} =~ s/ *[\n\r]+ */|/g;
#         $host->[$x]{ping}       = $q->{ping};

        GUIAdmin->clearSlave($host->[$x]{hostname}, $host);

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print "Cannot write to ConfigFile $CONF<br>";
        } else {
           $err2 = Html->info($L->{updated_1} . 
                    "<font color=red>(<a href=$Http::WEBPROC?GO=GUI::Hosts::pushSlaves><font color=red>" .
                    $L->{updated_2} . "</font></a>)</font>");
        }
     }
     last;
    }
  }
out:

  $h1 = Html->header2("admin.gen_maint.maintain_host");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $host->[$q->{no}];

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     my(@bb) = split(/=/, $mod);
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 5 == 0);
     my($ck) = "checked"  if (index($h->{categories}, $bb[0]) >= 0);
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  # my $topoType = Util->makeSelect("topo_type","ib=$G->{inband}|oob=$G->{oob}", $h->{topo_type});
  $ping = $h->{ping};
  $ping =~ s/\|/\n/g;
  $ping =~ s/#/  #/g;
  $frequency = &main::select_frequency($h);

  my $role_ck = "checked" if ($h->{role} eq "AM");

  $active = ($h->{active} eq "Y")? $L->{host_on} : $L->{host_off} ;
  my $datahost = ($h->{datahost} eq "Y")? "checked":"";
  my $ck2 = ($h->{show_monitored_only} eq "Y") ? "checked":"";

  $o =<<EOF;

<body bgcolor=#E0E0E0>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::upd>
 <input type=hidden name=no value=$q->{no}>
 <input type=hidden name=hostid value=$h->{hostid}>
<center>
$h1
$err $err2
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=#666699><b><font color=white>&nbsp;$L->{label}</td>
<tr><td bgcolor=$main'LIGHT width=20% align=right>$L->{hostid}:</td>
    <td ><table border=1 cellspacing=0><tr><td>$h->{hostid}&nbsp;</table></td>
    <td colspan=2 align=right><b>$active</td>
<tr><td bgcolor=$main'LIGHT width=20% align=right>$L->{name}:</td>
    <td colspan=3><b>&nbsp;$h->{hostname}

<tr><td bgcolor=$main'LIGHT align=right >$L->{ip}:</td>
    <td colspan=3><b>&nbsp;$h->{ipno}

<tr><td bgcolor=$main'LIGHT align=right>$L->{contract}&nbsp;:</td>
    <td colspan=3><input type=ip size=20 maxlength=20 name=contract value="$h->{contract}">

<tr><td bgcolor=$main'LIGHT align=right>&nbsp;$L->{cat} <br><a href=javascript:win1()>$L->{abb}</td>
    <td colspan=3>
    $modules_html
 </td>
<tr><td bgcolor=$main'LIGHT align=right>
     $L->{freq}: </td>
    <td colspan=3>$frequency</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{alt}: </td>
    <td ><input type=checkbox $role_ck name=role></td>
<tr>
    <td bgcolor=$main'LIGHT align=right>$L->{inband}: </td>
    <td ><input type=checkbox name=datahost $datahost></td>
<tr><td align=right bgcolor=$main'LIGHT width=40%>
       $L->{show}: </td>
    <td colspan=3><input type=checkbox name=show_monitored_only $ck2></td>


<tr><td colspan=4 bgcolor=silver><b>&nbsp;$L->{label2}</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{log1}:</td>
    <td colspan=3><table border=1 cellspacing=0><tr><td>$h->{logfile}</table></td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{log2}:</td>
    <td colspan=3><input type=text name=t300logfile size=50 maxlength=60 value="$h->{t300logfile}">

<!--
<tr><td bgcolor=$main'LIGHT align=right>Diagnostics Log Directory:</td>
    <td colspan=3><input type=text name=st4logfile size=50 maxlength=60 
      value="$h->{st4logfile}">
-->

</table>
</table>
<b>
EOF
   print $o;
   if (!$deny) {
     print <<EOF;
<input type=submit name=ACTION_update value="$G->{submit_update}">
<input type=submit name=ACTION_delete value="$G->{submit_delete}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
EOF
   }
   print "</form>";

}

sub uniq {
  my($v1, $v2) = @_;
  my @NEW = split(/\|/, $v2);
  foreach my $x (@NEW) {
    if (index("|$v1|", "|$x|") < 0) {
       $v1 .= "|$x";
    }
  }
  return $v1;
}

sub updAll {
  my($q) = @_;
  my($ho, $o, $err, $cat, $err1);

  print "\n";
  my($categories) = Agent->findSelectableAgents();

  if ($q->{ACTION} eq "Back") {
    &list($q);
    return;

  } elsif ($q->{ACTION} =~ /Update/) {
    $q->{hostid} = lc($q->{hostid});

    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          if ($q->{$bb[0]}) {
             $cat .= "|" if ($cat);
             $cat .= $bb[0];
          }
    }
    $renv->{categories} = $cat;
    $renv->{frequency}   = $q->{frequency} || 10;
    my %CAT;
    if ($q->{autocheck}) {
      foreach my $d (@$dev)  {
         my $h = $d->{host} || "LOCAL";
         $CAT{$h} .= "$d->{type}|" if (index("|$CAT{$h}|", "|$d->{type}|") < 0);
      } 
      $renv->{categories} = &uniq($cat, $CAT{LOCAL});
    }

    foreach my $h (@$host) {
       if ($q->{autocheck}) {
          $h->{categories} = &uniq($cat, $CAT{$h->{hostname}}) ;
       } else {
          $h->{categories} = $cat;
       }
       $h->{frequency}  = $q->{frequency} || 10;
    }

    if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
       print "Cannot write to ConfigFile $CONF<br>";
    } else {
       print "All hosts are updated!";
    }
    &list($q);
    return;
  }
out:

  $h = Html->header("Maintain Hosts: Update All Hosts");
  $q->{logfile}     = "/var/adm/messages";
#  $q->{t300logfile} = "/var/adm/messages.t3" if (!$q->{t300logfile} && !$err);
  $q->{st4logfile} = "/var/opt/SUNWstade/log/diags";

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 5 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if ($q->{$bb[0]});
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  $frequency = &main::select_frequency($q);

  $o =<<EOF;

<body bgcolor=#F0F0F0>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::updAll>
<center>
$h
$err
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>

<tr><td colspan=4 bgcolor=#666699><b><font color=white>&nbsp;Update these fields on all Slaves</td>

<tr><td bgcolor=$main'LIGHT align=right>
     &nbsp;Categories to Monitor<br><a href=javascript:win1()>Abbreviations</td>
    <td colspan=3>
   $modules_html
 </td>
<tr><td bgcolor=$main'LIGHT align=right>
     &nbsp;Also check categories that have devices: </td>
    <td colspan=3><input type=checkbox name=autocheck>
<tr><td bgcolor=$main'LIGHT align=right>
     &nbsp;Monitoring Frequency: </td>
    <td colspan=3>$frequency</td>


</table>
</table>
<b>
<input type=submit name=ACTION value="Update All Hosts">
<input type=submit name=ACTION value="Back">
</form>
EOF

  print $o;

}



#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$ping</textarea></td>

#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$ping</textarea></td>
1;
