package GUI::Instr;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Instr.pm,v 1.86 2002/09/19 16:35:07 ccadieux Exp $

use Util;
use Labels;
use Launch;
use Html;
use System;
#use Agent;
use Modules;
use Report;
use State;
use strict;

use vars qw (@Map);

sub frame {
  my($q) = @_;
  my($renv) = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  if ($window ne "B") {
     GUI::Instr::explore($q);
  } else {
     print <<EOF;
<frameset cols=50%,* border=1>
  <frame src=$Http::WEBPROC?GO=GUI::Instr::explore name=top  scrolling=auto>
  <frame src=/empty.html name=tree scrolling=auto>
</frameset>

EOF
  }
}


sub reverse {
  my($d) = @_;
  return (3000 - substr($d,0,4)) .   # year
         (20 - substr($d,5,2))   .   # month
         (40-substr($d,8,2))     .   # day
         (999999- (substr($d,11,2).substr($d,14,2).substr($d,17,2)));
}

sub explore {
  my($q, $post, $util) = @_;
  my(%D, $data, $head);
  print Html->body();

  my($renv, $dev, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my(%MAP);
  my($local) = System->hostname();
  my $sel = ($q->{host} eq "ALL")? "selected":"";
  my $sel1 = ($q->{host} eq "local")? "selected":"";
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('explore') ;
  my($hostsD) = "<select name=host><option value=ALL $sel>$L->{all_hosts}</option>".
                "<option value=local $sel1>$local</option>";
  my (%LABEL, %MGMT);
  if ($renv->{solution} eq "Y") {
    $LABEL{"host:$renv->{hostname}"} = "sp";
     $MGMT{"host:$renv->{hostname}"} = "C";
  }
  foreach my $h (@$hosts) {
     $MAP{$h->{hostname}} = $h->{ip};
     if ($h->{solution} eq "Y") {
       $LABEL{"host:$h->{hostname}"} = "sp" ;
        $MGMT{"host:$h->{hostname}"} = "C";
     }
     my $sel = ($h->{hostname} eq $q->{host})? "selected":"";
     $hostsD .= "<option value=\"$h->{hostname}\" $sel>$h->{hostname}</option>";
  }

  $hostsD .= "</select><b><input type=submit name=ACTION value=GO>";

  $head = Html->header2("monitor.devices", "95%") . 
   "<table border=0 width=95%>
   <tr><td nowrap><b><form><input type=hidden name=GO value=GUI::Instr::explore>
          $L->{search}:&nbsp;<input type=text size=10 name=PREFIX value=$q->{PREFIX}></td>
       <td align=right>
          <b>$L->{host}:&nbsp;</b>$hostsD</table>";
  my $prefix = $q->{PREFIX};

  my $shost = $q->{host} || "ALL";
  my $sort = $q->{sort} || "HOST";

  print $head;

  my(%CONF) = ();
  my($types, %NAMES, %IP);
  $types = "host,";
  foreach my $d1 (@$dev) {
     $LABEL{$d1->{type} . ":" . $d1->{key}} = $d1->{userLabel};
     $MGMT{$d1->{type} . ":" . $d1->{key}} = $d1->{mgmtLevel};
     $IP{$d1->{type} . ":" . $d1->{key}} = $d1->{ipno};
     $types .= "$d1->{type},";
  }
  my $DB = State->getComponentState(1); # worst severity for each comp.

  my @GIF = ("al_ok3.gif alt=$G->{ok}",
             "al_alert3.gif alt=$G->{warning}",
             "al_crit3.gif alt=$G->{error}",
             "al_down3.gif alt=$G->{down}"
             );
  
# REPORT-LIST
  my $RL = Report->reportList();
  my($out, $found, @LIST);
  $prefix =~ s/\*//g;
  $prefix =~ s/\./\\./g;
  my $target = ($window ne "B") ? "" : "target=tree";

  foreach my $r0 (keys %$RL) { #host, type, date, XX, name
    my $r    = $RL->{$r0};
    my $file = $r0;
    my $type = $r->[1];
    my $host = $r->[0];
    my $label = $LABEL{$r0} || $type;
    next if ($ruser->{isCustomer} && $MGMT{$r0} eq "C");
    next if (index(",t3message,backup,message,san,topo,mpxio,", ",$type,") >= 0);
    next if ($prefix and $r->[4] !~ /$prefix/);
    #next if (index($types, $type) < 0); # only display types that are in confg
    my ($ok, $h1);
    if ($renv->{hostname} eq $r->[0]) { # local
       if ($shost eq "local" || $shost eq "ALL") {
         $ok = 1;
       }
    } else {
       $out .= "<tr><td colspan=7></td>";
       if ($shost eq $host || $shost eq "ALL") {
          $ok = 1;
          $h1 = $MAP{$host} || $host;
       }
    }
    if ($ok) {
       my $name = $r->[4];
       my $date = $r->[2];
       $name =~ s/\./. /;
       $found++;
       my $url = "<a href=$Http::WEBPROC?GO=GUI::Instr::rStart&file=$file&type=$type&host=$h1 $target>$name</a>";
       my $report = "<a href=$Http::WEBPROC?GO=GUI::Instr::explore1&file=$file&type=$type&host=$h1 $target>Report</a> ";
       
       my $state = $DB->{$file};
       my($v);
       if ($sort eq "TYPE") {
          $v = lc($type);
       } elsif ($sort eq "NAME") {
          $v = $name;
       } elsif ($sort eq "STATUS") {
          $v = sprintf("%2.2d", 10 - $state->[0]);
       } elsif ($sort eq "DATE") {
          $v = &reverse($date);
       } else {  # if ($sort eq "HOST") {
          $v = $host;
       }
       $v .= "\t$host\t$label\t$url\t$report\t$state->[0]\t$file\t$date\thost_local";
       push(@LIST, $v);
    }
  }


  $out =<<EOF;
<table border=1 cellpadding=1 cellspacing=0 width=95% bgcolor=white><tr bgcolor=#666699>
   <td><b><font color=white><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=HOST&host=$q->{host}><font color=#FFFFCC>$L->{host}</font></a></td>
   <td><b><font color=white><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=TYPE&host=$q->{host}><font  color=#FFFFCC>$L->{type}</font></a></td>
   <td><b><font color=white><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=NAME&host=$q->{host}><font  color=#FFFFCC>$L->{name}</font></a></td>
   <td><b><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=STATUS&host=$q->{host}><font  color=#FFFFCC>$L->{sev}</font></a></td>
   <td><b><center>
     <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=DATE&host=$q->{host}><font  color=#FFFFCC>$L->{last_report}</font></a></td>
EOF


  my($gif, $details, $url);

  my $urls = Launch->read();
  my $last_h;
  foreach my $l (sort @LIST) {
     my @a = split(/\t/, $l);
     $gif = $details = "";
     my($t, $k) = split(/:/, $a[6]);
   
     if ($a[5] > 0) {
        my $g = $GIF[$a[5]];
        $gif = "<a href=\"$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&file=$a[6]&host=$a[1]\" $target><img src=/gif/$g (Click to review Alerts)\" border=0 ></a>";
        $details = $DB->{$a[6]}->[1];
     }

     my $h = Util->shortHostname($a[1]);
     my ($launch, $l1);

     if ($urls->{$t}[0] ) {
        my $u_name = $urls->{$t}[0];
        my $u_value = $urls->{$t}[1];
        my $u_name2 = $urls->{$t}[2];
        my $u_value2 = $urls->{$t}[3];
        $u_value =~ s/\$ip/$IP{$a[6]}/;
        $u_value2 =~ s/\$ip/$IP{$a[6]}/;
        $launch = "&nbsp;<a href=$u_value target=apps><img src=/gif/urllink.gif alt=\"Launch $u_name\" border=0></a>";
        $launch .= "&nbsp;<a href=$u_value2 target=apps><img src=/gif/urllink.gif alt=\"Launch $u_name2\" border=0></a>" if ($u_name2);
        $l1 = "<table border=0 width=100% cellspacing=0 cellpadding=0><tr><td>$a[3]</td><td align=right>$launch</table>";
     } else {
        $l1 = $a[3];
     }
     if ($sort eq "HOST") {
        if ($h ne $last_h) {
           $out .= "<tr><td><tr><td>&nbsp;<b>$h";
           $last_h = $h;
        } else {
           $out .= "<tr><td>&nbsp;$h";
        }
        $out .= "<td>&nbsp;$a[2]
       <td nowrap>$l1</td>
       <td valign=middle><center>&nbsp;$gif
       <td nowrap><small>&nbsp;$a[7]
      ";
     } else {
       $out .= "<tr><td>&nbsp;$h
       <td>&nbsp;$a[2]
       <td nowrap>$l1</td>
       <td valign=middle><center>&nbsp;$gif
       <td nowrap><small>&nbsp;$a[7]
      ";
     }
  }

  $out .= "</table></table>&nbsp;</form>";

  print $out;
  my($x, $g);

  print Html->readHtdocs('explore_trailer');
}

sub explore1F {
  my($q, $port, $util) = @_;
  my($url) = "host=$q->{host}&file=$q->{file}";
  print "<frameset rows=50%,* border=0>
     <frame src=$Http::WEBPROC?GO=GUI::Instr::explore1&$url name=left0 scrolling=auto>
     <frame src=javascript:return() name=main2 scrolling=auto>
 </frameset>
  ";
}

@Map = ('al_ok3','al_alert3','al_crit3','al_down3');

sub addAlert {
  my($k, $file, $Comp, $isLink) = @_;
  return "" if ($Comp->[0] < 0);
  my $G = Labels->read();
  my ($n, $grid);
  if ($isLink) {
    $n = $k; $grid = "";
  } else {
    $n = substr($k,length($file)+1);
    $n = "Enclosure" if (index(",ei,eo,e,", ",$n,") >= 0);
    my $ev = State->eventHash($Comp->[4]);
    $grid = "<a href=javascript:info('$ev->{EventType}','$ev->{Caption}')>$G->{eventgrid}</a>";
    $n .= "</b> $ev->{OrigTargetName}" if (exists($ev->{OrigTargetName}));
  }
  my $gif = "<img src=/gif/" . $Map[$Comp->[0]]. ".gif>";
  return "<tr><td>$gif</td><td><b>$n &nbsp;$grid</td><tr><td></td><td><small> $Comp->[1]</td>";
}

sub state {
  my($q, $diagram) = @_;
  my($title);
  my $file = $q->{file};
  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my $deny = Roles->verifyRole($q, "admin|c_admin");
require TO;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  if ($q->{name}) {
    $title = "$q->{cat}:$q->{name}";
  } else {
    $title = $q->{file};
  }
  my($type, $key) = split(/\:/, $title);

  if ($q->{ACTION_delete}) {
     if ($q->{key}) {
       State->clearComponent($q->{key});
       State->clearAllLinks(undef, $q->{key});
       State->write();
     }
  }

  my $State;
  if ($q->{host} && $q->{host} ne $renv->{hostname} && 
       index(",host,se,", ",$type,") < 0 && !$Config->deviceByKey($file) ) {
    my $i  = Util->rasInfo($q->{host});
    print "</b>Calling $q->{host}...<br>\n";
    $State = State->readFromDevice($q->{host}, $i->{hostname});
  } else {
    $State = State->read();
  }
  my $Comp = $State->components();

  print "<script>
   function info(a,b) {
      var b = '$Http::WEBPROC?GO=GUI::EventLog::info&type=' + a + '&comp=' + b;
      var O = window.open(b,'linfo','menubar=yes,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
   }
   </script>
   <center><table border=0 cellspacing=1 cellpadding=2 width=100% bgcolor=#666699>
      <tr><td><b><font color=white>&nbsp;$title</td> </table> ";

  my $to = TO->readTopo($q->{topo});
  if ($diagram) {
    if ($type eq "hostXX") {

      my $diag =TO::HOST->diagramApplet($title, $Comp, $to);
      print $diag;

    } elsif ($type eq "t3") {
      my $diag =TO::T3->diagramApplet($title, $Comp, $to);
      print "<table border=0 cellspacing=1 cellpadding=0 width=100% bgcolor=black><tr><td>".
           "<center>$diag</table>";
    } else {
      print Html->info($L->{no_graph});
    }
    return;
  }
  print " <table border=1 cellpadding=2 cellspacing=0 width=100% bgcolor=white>";
  my ($cnt, $out);
  foreach my $k (sort keys %$Comp) {
     if (substr($k,0,length($file)) eq $file) {
       my $new =  &addAlert($k,$file, $Comp->{$k});
       $out .= $new;
       $cnt++ if ($new);
     }
  }
  my $Links = $State->links();
  foreach my $k (sort keys %$Links) {
     my($f1,$f2) = split(/\|/, $k);
     if (substr($f1,0,length($file)) eq $file) {
       my $el = "link to " . $f2;
       my $new = &addAlert($el, $file, $Links->{$k}, 1);
       $out .= $new;
       $cnt++ if ($new);
     } elsif (substr($f2,0,length($file)) eq $file ) {
       my $el = "link to " . $f1;
       my $new = &addAlert($el, $file, $Links->{$k}, 1);
       $out .= $new;
       $cnt++ if ($new);
     }
  }
  print $out;
  if (!$cnt) {
    print "<tr><td colspan=3><b>$L->{no_alerts}</td>";
  } 
  print "</table>";
  if (!$diagram) {
    print "<form>
      <input type=hidden name=GO value=GUI::Instr::rStart>
      <input type=hidden name=key value=\"$title\">
      <input type=hidden name=Roption value=2>
      <input type=hidden name=file value=$file>";
    if ($cnt && !$deny) {
      print "<b><input type=submit name=ACTION_delete value=\"$L->{submit_del}\">";
    }
    print "</form>";
  }
}


sub explore1 {
  my($q, $port, $util) = @_;
  my($data, @a);
  print "\n";
  my($WIN) = "WIN=$q->{WIN}" if ($q->{WIN});
  
  print "\n<body bgcolor=#F0F0F0 leftmargin=2 topmargin=2 marginwidth=2 marginheight=2>";
  my($P) = System->get_home() . "/DATA/OLD_REPORTS";
  my($ip);
  my($renv) = System->get_renv();
  $q->{host} = "" if ($q->{host} eq $renv->{hostname});
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  if ($q->{host}) {
    print "$G->{calling} $q->{host}...<br>\n";
    my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
    foreach my $h (@$hosts) {
      if ($h->{hostname} eq $q->{host} || $q->{host} eq $h->{ip}) {
        $ip = $h->{ip};
        last;
      }
    }
    $ip = $q->{host} if (!$ip);
  }

  my ($err, $VAR1) = Report->readSpecial({ host  => $ip,
                                  timeout  => 10,
                                  file     => $q->{file},
                                  wwn      => $q->{wwn},
                                  name     => $q->{name} });
     
  if ($err) {
    print "<b>$err</b><br>";
    return;
  }
  require Report;

  my($id) = $VAR1->id();
  my $lost;
  if ($VAR1->status() eq "CC") {
    $lost = "<font color=red><b>$G->{cannot_comm}</b></font>" ;
  }
  $q->{file} = "$id->{category}:$id->{deviceName}";

 # $pl = "<font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Instr::explore1&host=$q->{host}&file=$q->{file}&level=0><font color=white>$G->{close}</font></a> ] ";
  print "
 $lost
<table border=1 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
  <tr><td bgcolor=#666699 colspan=2>
   <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td colspan=2><b><font color=white>" . uc($id->{category}) . ":$id->{name}</td>
      <tr><td colspan=2><b><font color=white>$G->{last_probe}: $VAR1->{_created}</td>
   </table>
<tr><td colspan=2><font face=arial,helvetica>
  <table border=0><tr><td></table>
 ";

  my $h = $VAR1->value();
  require Html::Tree;
  my $tree =  Html::Tree->new({
                     this => "$Http::WEBPROC?GO=GUI::Instr::rStart&file=$q->{file}&host=$q->{host}&Roption=4",
                           q => $q,
                      sysgif => '/gif',
                     linkall => 1,
                        name => "ROOT"});
  my %X = ();
  foreach my $k (sort keys %$h) {
    next if (substr($k,0,1) eq "_");
    my $ix = rindex($k, ".");
    my $k1 = $k;
    if ($ix > 0) {
      $k1 = substr($k, 0, $ix);
    }
    $X{$k1} = 1;
  }
  my(@X) = ();
  print " <img src=/gif/menu_root.gif border=0 align=top>&nbsp;<a href=$Http::WEBPROC?GO=GUI::Instr::explore1&file=$q->{file}&host=$q->{host} >$id->{category}:$id->{deviceName}</a><br>";

  foreach my $k (sort keys %X) {
    my $k2 = $k; $k2 =~ s/\./\//g;
    push(@X, [ $k2, "$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=4&file=$q->{file}&section=$k2&host=$q->{host}" ]);
  }
  print $tree->read(\@X);
  print "<br>&nbsp;</table></table>";
  if ($q->{section}) {
     print "<table border=0><tr><td></table>";
     &explore2($q);
  }
}


sub explore2 {
  my($q, $port, $util) = @_;
  my($local);
  require Report;
  my($data);
  my($P) = System->get_home() . "/DATA/OLD_REPORTS";

  #print "\n<body bgcolor=#F0F0F0 leftmargin=2 topmargin=2 marginwidth=2 marginheight=2><center>";
  my @a = split(/:/, $q->{file});
  my $i = rindex($a[0],"/");
  $a[0] = substr($a[0],$i+1) if ($i) ;
  my $title = "$a[0]:$a[1] $q->{section}";
  
  if ($q->{host}) { # remote file
     my($D2) = System->get_home() . "/DATA/remote";
     $data = Util->readf("$D2/$q->{file}");

#     $url = Util->makeUrl($q->{host}, "?GET=run_file&file=$q->{file}");
#     print "Retrieving data from $url...<br>";
#     $data = Util::Http->get($url, 30);
     $local =0;
  } else {          # local file
     $data = Util->readf("$P/$q->{file}");
     $local =1;
  }
  if (substr($data,0,3) =~ /ER/) {
     print "$data<br>";
     return;
  }
  my($VAR1);
  eval $data;
  my $h = $VAR1->value();
  my($id) = $VAR1->id();
  my $section = $q->{section};

  my $l = length($section);
  $section =~ s/\//./g;
  print "
<table border=1 cellpadding=1 cellspacing=0 width=100% bgcolor=white>
  <tr><td colspan=2 bgcolor=#666699>&nbsp;<font color=white><b>$title</td>
<tr><td><pre>";
  my $last = undef;
  my ($val, $k0, $v, $ix, $cnt);
  foreach my $k (sort keys %$h) {
    next if (substr($k,0,1) eq "_");
    next if ($l && substr($k,0,$l) ne $section);
    next if ($l && length($k) > $l && substr($k,0,$l+1) ne "$section.");
    $k0 = $k;
    $k0 = substr($k, $l+1) if ($l);
    $ix = index($k0,".");
    if ($ix > 0) {
      $v = substr($k0,0,$ix);
      if ($v ne $last) {
        print "<tr><td colspan=2>&nbsp;</td>" if (defined($last));
        $last = $v;
      }
    }
    my $co = ($cnt++ % 2 == 0) ? "bgcolor=#F0F0F0" : "";
    
    print "<tr $co><td>&nbsp;";
    print "$k0</td><td>";
    $val= $h->{$k};
    require Data::Dumper;
    $Data::Dumper::Indent = 1;
    if (ref($val)) {
      print "<pre>" . substr(Data::Dumper::Dumper($val),7) . "</td>";
    } else {
      print " = $val</td>";
    }
  }
  print "</table></table><center>";
  print "&nbsp;";


}

# NU
sub update {

  my($q, $port, $util) = @_;
  require Report;
  print "\n<body bgcolor=#F0F0F0>";
  my @a = split(/:/, $q->{file});
  my $i = rindex($a[0],"/");
  $a[0] = substr($a[0],$i+1) if ($i) ;
  my $title = "$a[0]:$a[1] $q->{section}";


  my($l);
  if ($q->{ACTION} eq "Update") {
     open(O, System->get_home() ."/$q->{file}");
     open(W, ">" . System->get_home() . "/$q->{file}.new");  
     while ($l = <O> ) {
         chop($l);
         @a = split(/ *\= */, $l);
         if ($a[0] eq "$q->{section}.$q->{value}") {
            print W "$a[0]  = $q->{new}\n";
         } else {
            print W $l . "\n";
         }
     }
     close(O); close(W);
  }
  my($data);
  if ($q->{host}) { # remote file
     print "Retrieving data from $q->{host}...<br>";
     require Util::Http;
     $data = Util::Http->getCommand($q->{host}, "run_file&file=$q->{file}", $main::TO);

  } else {          # local file
     $data = Util->readf(System->get_home() ."/$q->{file}");
  }
  if (substr($data,0,3) =~ /ER/) {
    print "$data<br>";
    return;
  }
  my $r = eval substr($data, 7);
  my $h = $r->value();
  my $id = $r->id();
  my $section = $q->{section};

  $l = length($section);
  $section =~ s/\//./g;
  print "
<table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white><tr><td bgcolor=black>
<table border=0 cellpadding=0 cellspacing=0 width=100% bgcolor=white>
 <form  method=get>
 <input type=hidden name=GO value=update>
 <input type=hidden name=section value=$q->{section}>
 <input type=hidden name=value value=$q->{value}>
  <tr><td colspan=2 bgcolor=#666699>&nbsp;<font color=white><b>$title</td>
<tr><td><pre>";
  my $last = undef;
  my($k0);
  foreach my $k (sort keys %$h) {
    next if ($l && substr($k,0,$l) ne $section || substr($k,0,1) eq "_");
    $k0 = $k;
    next if (substr($k0, 0 - length($q->{value})) ne $q->{value});
    $k0 = substr($k, $l+1) if ($l);
    my $ix = index($k0,".");

    print "<tr><td align=right><b>$k0: </td>
               <td><input type=text name=new value=\"$h->{$k}\"></td>";
  }
  print "</table></table><center><input type=submit name=ACTION value=Update>";
  print "</form>&nbsp;";
  
}


sub mon {
  my($type, $name) = @_;
  my(%D);
  if (defined($D{$type}{$name})) {
    return ($D{$type}{$name}[0] eq "Y")? "<font color=green><b>On":"<font color=red><b>Off"
  } else {
    return "<font color=red><b>No";
  }
}

sub header {
  my($q,  $title, $url, $window) = @_;
  my $renv = System->get_renv();
  #if ($window eq "N") {
    print Html->header2("monitor.devices", "95%");
  #} else {
  #  print "</center><b>$title</b><center>";
  #}
  print "<table border=0 bgcolor=#F0F0F0 cellspacing=0><tr><td nowrap>$url</table>";
  print "<table border=0><tr><td></table>";
}

sub rStart {
  my($q) = @_;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  my $h     = "$Http::WEBPROC?GO=GUI::Instr::rStart&host=$q->{host}&file=$q->{file}&topo=$q->{topo}";
  my @S;
  $S[1]= "<a href=$h&Roption=1><font color=blue>$L->{summary}</font></a>";
  $S[2]= "<a href=$h&Roption=2><font color=blue>$L->{alerts}</font></a>";
  $S[3]= "<a href=$h&Roption=3><font color=blue>$L->{log}</font></a>";
  $S[4]= "<a href=$h&Roption=4><font color=blue>$L->{report}</font></a>";
  $S[5]= "<a href=$h&Roption=5><font color=blue>$L->{graph}</font></a>";
  $S[6]= "<a href=$h&Roption=8><font color=blue>$L->{info}</font></a>";
  my $tst   = " | <a href=$h&Roption=6><font color=blue>$L->{test}</font></a>" if ($q->{topo});
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $window= $ruser->{window} || $renv->{window};

  print Html->body();
  my $url= "[ ";
  my $x;
  for ($x=1; $x <= 5; $x++) {
     $url .= $q->{Roption} eq $x ? "<b>$S[$x]</b>" : $S[$x];
     $url .= " | " if ($x < 5);
  }
  $url .= "$tst ]<br>";

  if ($q->{Roption} == 2) {       # ALARMS
     &header($q, $L->{alerts}, $url, $window);
     &state($q);

  } elsif ($q->{Roption} == 6) {  # TEST
     $q->{enc} = "$q->{file}:e";
     delete($q->{file});
     $q->{TAB} = 1;
     require GUI::Test;
     GUI::Test::get_test($q);

  } elsif ($q->{Roption} == 3) {  # LOG

     require GUI::EventLog;
     &header($q, $L->{log}, $url, $window);
     $q->{NOBACK} = 1;
     GUI::EventLog::display($q);

  } elsif ($q->{Roption} == 4) {  # REPORT
     &header($q, $L->{report}, $url, $window);
     &explore1($q); 

  } elsif ($q->{Roption} == 5) {  # GRAPH
     &header($q, $L->{graph}, $url, $window);
     &state($q, 1); 
  } else {                        # SUMMARY
     &header($q, $L->{summary}, $url, $window);
     &report($q);  
  }
}



sub report {
  my($q) = @_;
require TO;
  my($type, $wwn) = split(/:/, $q->{file});
  my $host1 = substr($q->{file}, 5) if ($type eq "host");

  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart');

  if (0) {
   if ($type eq "host") {
     my $to = TO->readTopo($q->{topo});
     if ($to) {
       my $ho = $to->nodeByName($q->{file});
       $host1 = substr($ho->name(), 5);
       if ($ho) {
         $q->{file} = "host:$ho->{info}{hostid}";
       }
     }
   }
  }
  my($renv) = System->get_renv();
  $q->{host} = "" if ($q->{host} eq $renv->{hostname});
  if ($q->{host}) {
    print "Calling $q->{host}...<br>\n";
  }
  my($err, $VAR1) = Report->readReport($q->{file}, $q->{host}, 10);

  if (!$VAR1) {
     print Html->warning($L->{err_no_report});
     return ;
  }
  if ($err) {
   $VAR1 = undef;
   if ($type ne "host") {
     print Html->warning($L->{err_no_report});
     return ;
   }
  }
  my $t1 = $VAR1->category();
  my $ip1 = $VAR1->value("id.ipno");
  my $urls = Launch->read();
  if ($urls->{$t1}[0] ) {
     my $u_name = $urls->{$t1}[0];
     my $u_value = $urls->{$t1}[1];
     my $u_name2 = $urls->{$t1}[2];
     my $u_value2 = $urls->{$t1}[3];
     $u_value =~ s/\$ip/$ip1/;
     $u_value2 =~ s/\$ip/$ip1/;
     my $im1 = "<img src=/gif/urllink.gif border=0>";
     my $u_out = "<a href=$u_value target=apps>$im1 $u_name</a>";
     $u_out .= "&nbsp;&nbsp;<a href=$u_value2 target=apps>$im1 $u_name2</a>" if ($u_name2);
     print "<table border=0 cellspacing=0 width=90% cellpadding=0><tr><td align=right>Launch: $u_out</table>";
  }

  my $Comments = Util->deserialize("Comments.txt");
  if ((my $com = $Comments->{$wwn})) {
    print "<table border=0 cellspacing=1 width=95% bgcolor=white><tr><td>$com</table>";
  }
  print "\n<body bgcolor=#E0E0E0 topmargin=2 marginheight=2><center>";

  my $module = uc($type);
  eval "require \"Agent/$module.pm\"";
  $module = "Agent::$module";

  if (!$@) {
    print $module->REPORT($q->{host}|| $renv->{hostname}, $VAR1, {host => $host1});
  }

}

sub dumpConfig {
  my($q) = @_;
  print "\n<body bgcolor=$main'BGCOLOR>";
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
  my($acronym) = $renv->{GSV_ACRONYM};
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('dumpConfig');

  if ($q->{ACTION_email}) {
     if ($q->{email_address} !~ /.+\@.+/) {
        print "<big><font color=red><b>$L->{err_email}</font>";
     } else {
        &dumpConfig1($q);
        print "<font color=green size=+1><b>$L->{info_1} $q->{email_address}
</b></font>";
     }
  }
  print "<center>";
  opendir(O, System->get_home() . "/DATA/topo");
  my @dirs = readdir(O); closedir(O);
  my $checks = "";
  my $bg = "bgcolor=D0D0FF";
  my $ho = System->hostname();
  $checks .= "<tr><td align=right $bg>$ho:<td> <input type=radio name=radioHost value=$ho></td>";
  foreach $ho (@$hosts) {
    $checks .= "<tr><td align=right $bg>$ho->{hostname}:<td> <input type=radio name=radioHost value=$ho->{hostname}></td>";
  }

  print Html->header2('admin.system.email_config');

  print "<table border=1 width=80%  cellspacing=0 cellpadding=3 bgcolor=white>
  <form><input type=hidden name=GO value=GUI::Instr::dumpConfig>
  <tr bgcolor=#666699>
    <td colspan=2><font color=white><b>$L->{label}
  
  <tr><td align=right $bg>$L->{l1}:</td>
      <td><input type=text size=60 name=email_address>
  <tr><td align=right $bg>$L->{l2}:</td>
      <td><input type=text size=60 name=info>
  <tr><td colspan=2 bgcolor=#666699><font color=white><b>$L->{l3}</td>
  $checks
  </table>
  <b><input type=submit name=ACTION_email value=$L->{submit_email}>
  </form>";

}

sub dumpConfig1 {
  my($q) = @_;
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
  my($space) = "&nbsp;";
  my($out);
  my($today) = `/usr/bin/date`; # Util->today();
  my($master) = System->hostname();
  $q->{email} = 1;
  my($acronym) = $renv->{GSV_ACRONYM};

  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('dumpConfig');

  $out .= "\n<body bgcolor=#F0F0F0>
  <table border=0 cellspacing=0 width=100%><tr><td>
     <h2>Configuration on $renv->{customer}</h2></td>
     <td align=right><b>$renv->{hostname} - $renv->{version}<br>$today</table>
  <table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
  <tr bgcolor=#666699><td colspan=2>
  <font color=white><big><b>$L->{label2}
  <tr><td>
  <table border=0 cellspacing=0 bgcolor=white>
    <tr><td align=right bgcolor=#E0E0E0>$L->{name}:</td>
        <td>&nbsp;$renv->{customer}</td>
    <tr><td align=right valign=top bgcolor=#E0E0E0>$L->{addr}:</td>
        <td>&nbsp;$renv->{site_address}<br>
           &nbsp;$renv->{site_city} $renv->{site_state} $renv->{site_zip} $renv->{site_country}<br>
    <tr><td align=right bgcolor=#E0E0E0>$L->{l_contact}:</td>
        <td>&nbsp;$renv->{site_contact} $renv->{site_email}</td>
  </table>
  <td valign=top><table border=0 cellspacing=0>
    <tr><td align=right bgcolor=#E0E0E0>$L->{custno}:</td>
        <td>&nbsp;$renv->{cust_no} &nbsp;$L->{contract}: $renv->{contract}</td>
    <tr><td align=right bgcolor=#E0E0E0>$L->{host}:</td>
        <td>&nbsp;$q->{radioHost}</td>
    <tr><td align=right bgcolor=#E0E0E0>$L->{admin}:</td>
        <td>&nbsp;$renv->{site_email}</td>
    <tr><td align=right bgcolor=#E0E0E0>$L->{polling}:</td>
        <td>&nbsp;$renv->{frequency} $L->{mins}</td>
    </table>
  </table>
  ";
  my $b;
  $b = ($q->{radioHost} eq System->hostname())? "<b>":"";

  $out .= "$space<table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
  <tr bgcolor=#666699>
  <td colspan=7><big><FONT color=white><b>$L->{labvel3}</td>
  <tr bgcolor=#E0E0E0> $L->{header2}
    ";

    $out .= "<tr><td>$b$master".
    "<td>$renv->{hostname}</td>".
    "<td>" . System->hostname() . "</td>".
    "<td>&nbsp;</td>".
    "<td><center>Y</td>".
    "<td><center>$renv->{frequency}</td>
    <td>$renv->{categories}&nbsp;</td>
     ";
  my(@L) ;
  foreach my $h (@$hosts) {
    push(@L, "$h->{hostname}\t$h->{hostid}\t$h->{ip}\t$h->{ipno}\t$h->{active}\t$h->{frequency}\t$h->{categories}");
  }
  foreach my $h (sort @L) {
    my(@a) = split(/\t/, $h);
    $b = ($a[0] eq $q->{radioHost}) ? "<b>":"";
    $out .= "<tr><td>$b$a[0]<td>$a[1]<td>$a[2]<td>$a[3]
    <td><center>$a[4]</td>
    <td><center>$a[5]</td>
    <td>$a[6]&nbsp;</td>
     ";
  }
  $out .= "</table><table border=0><tr><td></table>";
  my $outmaster;

  foreach my $el ($q->{radioHost}, 'MERGE-MASTER') {
    my $F = System->get_home()  . "/DATA/topo/$el";
    if (-f $F) {
      my $o;
      print "topology for $el...<br>\n";
      $o .= "<table border=1 width=100% cellspacing=0  cellpadding=3 bgcolor=#666699>
         <tr><td><font color=white><b>$L->{label4} $el</table>";
          
      require GUI::Graph;
      $o .= GUI::Graph::genApplet({topo => $el, email => 1, height => 400,  zoom => 3});
      if ($el eq 'MERGE-MASTER') {
         $outmaster .= $o;
      } else {
         $out .= $o;
      }
    }
  }

  $out .= "$space<table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
  <tr bgcolor=#666699>
  <td colspan=7><big><FONT color=white><b>$L->{label5}</td>
  <tr bgcolor=#E0E0E0> $L->{header3}
    ";

  foreach my $d (@$devs) {  # master devices
     my $hd = $d->{host} || $renv->{hostname};
     next if ($q->{radioHost} ne $hd);
     $out .= "<tr><td>$hd<td>$d->{type}<td>$d->{name}<td>$d->{ip}&nbsp;<td>$d->{active}</td>";
  }

  $out .= "</table>";

  print "Reading<br> "; 

  my $D = System->get_home() . "/DATA/REMOTE_LISTS";
  opendir(O, $D);
  my @fs = readdir(O); closedir(O);
  my $cnt=0;
  Modules->load("Agent");
  foreach my $f (@fs) {
    next if (substr($f,0,1) eq ".");
    next if ($f ne $q->{radioHost});
    open(O, "$D/$f");
    my $host = $f;
    $out .= "&nbsp;<p><table border=1 cellspacing=0 width=100% bgcolor=white>
       <tr bgcolor=#666699><td><font color=white><big><b>Instrumentation Reports from $host</td></table>";
    my($l);
    while ($l = <O>) {
      my($file_1, $date_1, $acces_1, $name_1) = split(/=/, $l);
      my($type, $xxx) =   split(/:/, $file_1);
      next if (!$xxx);
    
      my ($err, $VAR1) = Report->readReport($file_1, $host, 10);
      if ($err) {
        $out .= "$err";
      } else {
        my $module = "Agent::" . uc($type);
        if ($module->can("REPORT")) {
          print " report $file_1 <br>";
          my $rep = $module->REPORT($host, $VAR1, {host => $xxx} );
          $out .= "$rep &nbsp;";
        }
      }
    }
  }

  my($hostname) = System->hostname();
  my($email) = Util->email_html("$acronym", 
                  "$acronym Configuration at $renv->{customer}", 
                  $q->{email_address},
                  "Email from $acronym on $master.
$q->{info}
$L->{email_head} $q->{radioHost}

  $L->{cust1} $renv->{customer} ($renv->{ticker})
  $L->{site1} $renv->{site_name}
  $L->{addr1} $renv->{site_address}   
  $L->{city} $renv->{site_city} $renv->{site_state} $renv->{site_zip}
  $L->{country} $renv->{site_country} 
  $L->{contact} $renv->{site_contact} $renv->{site_email}
 ",
                  "rasconfig.html", $out, "html",
                  "rasmaster.html", $outmaster, "html",
         );
  
  open(O, ">/tmp/xx"); print O $email ; close(O);
  my($mailer) = $renv->{mailer};
  open(O,"|$mailer $q->{email_address}");
  print O $email;
  close(O);
}
  

sub readR {
  my($file) = @_;
  my(@a, $v);
  open(O, System->get_home() . "/DATA/OLD_REPORTS/$file");

  @a = <O>; close(O);

  my $l = '$v = ' . substr("@a",7);
  eval $l;
  return $v;
}


1;
 
