package GUI::Notifs;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
#  $Id: Notifs.pm,v 1.27 2002/10/09 18:51:29 ccadieux Exp $

use Labels;

sub get_PRIO {
  my $G = Labels->read();
  return (0 => $G->{sev0}, 1 => $G->{sev1}, 2 => $G->{sev2}, 3 => $G->{sev3},
          9 => "$G->{sev1}+$G->{sev2}+$G->{sev3}", 91 => $G->{sevA}, '*' => $G->{all});
}


sub list {
  my($q) = @_;
  my($ho, $o);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
  my $Lang = Util->languageList(1);

  print "\n";
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }


  if ($q->{ACTION_add}) {
     &add($q);
     return;
  } elsif ($q->{ACTION_max}) {
     unlink System->get_home() . "/DATA/Email_max";
     print Html->info($L->{'email.reset_done'});
  }

  print "\n<body bgcolor=$main'BGCOLOR> <center>";
  print Html->header2("admin.gen_maint.email");

  ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
  %PRIO = &get_PRIO();

  for ($x=0; $x <= $#$notifs; $x++) {
    $h    = $notifs->[$x];
    $lnk  = "<a href=$Http::WEBPROC?GO=GUI::Notifs::upd&no=$x><b>$h->{email}</b></a>";
    $type = $h->{type};
    $device = ($h->{device} eq "*")? $G->{all}: $h->{device};
    $prio   = ($h->{priority} eq "*")? $G->{all}: "$h->{priority}: $PRIO{$h->{priority}}";
    @a      = split(/\|/,  $h->{event});
    $events = "";
    foreach $x (@a) {
      if ($x eq "*") {
        $events .= "**$L->{'email.l1'}<br>";
      } else {
        $events .= "$x<br>";
      }
    }
    $ho .= "<tr>
                <td><center>$type</td>
                <td>$lnk</td>
                <td><center>$device</td>
                <td>$events</td>
                <td><center>$prio</td>
           ";
  }
  if ($#$notifs < 0) {
     $ho .= "<tr><td colspan=5><b>$L->{'email.err_1'}</td>";
  }
  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::list>
$q->{ERR}
<table border=2 cellspacing=1 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100% bgcolor=#F0F0F0>
<tr><td colspan=5 bgcolor=#666699><b><font color=white>&nbsp;$L->{'email.l2'}</td>
<tr>
    <td bgcolor=$main'LIGHT><center><b>$L->{'email.l3'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'email.l4'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'email.l5'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'email.l6'}</td>
    <td bgcolor=$main'LIGHT><center><b>$L->{'email.l7'}</td>
$ho
</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
    print "<input type=submit name=ACTION_add value=\"$L->{'email.submit1'}\">";
    print "<input type=submit name=ACTION_max value=\"$L->{'email.reset_max'}\">";
  }
  print "</form>";
}

sub upd {
  my($q) = @_;
  my($ho, $o);
  my($name);

  print "\n";
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  } elsif ($q->{ACTION_update}) {
    if ($q->{script} && !-x $q->{script}) {
        print Html->error($L->expand('email.err_2', $q->{script}));
    }
    if (!$q->{email}) {
        $err = Html->error($L->{'email.err_3'});
        goto out;
    }
    ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;

    $x = $q->{no};
    $notifs->[$x]{email}  = $q->{email};
    $notifs->[$x]{device} = $q->{device};
    $notifs->[$x]{type}   = $q->{type};
    $notifs->[$x]{language} = $q->{language};
    $notifs->[$x]{email_type} = $q->{email_type};
    $notifs->[$x]{script}   = $q->{script};
    $notifs->[$x]{priority} = $q->{priority};

    if (!$q->{event} || (index($q->{event}, "*") >= 0) ) {
       $notifs->[$x]{event}     = "*" ;
    } else {
       $s = $q->{event}; $s =~ s/\t/|/g;
       $notifs->[$x]{event}     = $s;
    }
    PDM::ConfigFile->write($renv, $dev, $host, $notifs);
    $err = Html->info($L->{'email.info_1'});

  } elsif ($q->{ACTION_delete}) {
    ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $notifs->[$x]{_name} = "";
    $name = $notifs->[$x]{email};
    PDM::ConfigFile->write( $renv, $dev, $host, $notifs);
    $q->{ERR} = Html->warning($L->expand('email.info_2', $name));
    &list($q);
    return;

  }
out:

  $h1 = Html->header2("admin.gen_maint.email", undef, "#2");

  ($renv, $dev, $hosts, $notifs) = PDM::ConfigFile->read;
  $h = $notifs->[$q->{no}];
  %PRIO = &get_PRIO();

  $device = ($h->{device} eq "*")? $G->{all}: $h->{device};
  $prio   = ($h->{priority} eq "*")? $G->{all}: "$h->{priority}: $PRIO{$h->{priority}}";

  my $sel = &priorities();
  $priority = "<select name=priority ><option value=*>$L->{'email.l8'}</option>" .
              &main::select($sel, $h->{priority});

  @a      = split(/\|/,  $h->{event});
  $events = "";
  %w = ();
  foreach $x (@a) {
    $w{'event_'.$x} = 1;
  }
  my $host_select = "<select name=host><option value=\"\">$G->{all}";
  foreach my $h (@$hosts0) {
     $host_select .= "<option>$h->{hostname}";
  }
  $host_select .= "</select>";

  my($cat) = &main::find_devices();
  my($select) = "";
  foreach $c (@$cat) {
     $select .= lc($c)  ."=" . uc($c) . "|";
  }
  $select .= "Agent=StorageAgent|";
  chop($select) if ($select);
  $device   = "<select name=device>". &main::select("$select|*=$L->{'email.l9'}", $h->{device});
  $events = "<select name=event size=12 multiple>".
              &main::select("*=$L->{'email.l1'}|" . &find_events , $h->{event}, 1);
  my $lang = Html->makeSelect("language", Util->languageList(), $h->{language});

  my $email_type = Html->makeSelect("email_type",
           "S=$L->{'email.type_s'}|C=$L->{'email.type_c'}" , $h->{email_type});

  $o =<<EOF;

<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::upd>
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{'email.l10'}</td>

<tr><td bgcolor=$main'LIGHT align=right width=20%>$L->{'email.l3'}:</td>
    <td><b><input type=hidden name=type value=$h->{type}>&nbsp;$h->{type}</td>
  
<tr><td bgcolor=$main'LIGHT align=right width=20%>$L->{'email.l11'}:</td>
    <td><input type=text name=email value="$h->{email}" size=40>
      <font color=red><big>*</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{'email.type'}:</td>
    <td>$email_type</td>

<tr><td bgcolor=$main'LIGHT align=right width=20%>$L->{'email.l12'}:</td>
    <td><input type=text name=script value="$h->{script}" size=60></td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{'email.l5'}:</td>
    <td><b>&nbsp;$device</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{'email.l7'}:</td>
    <td><b>&nbsp;$priority</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{'email.l6'}:</td>
    <td><b>&nbsp;$events</td>


</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
    print "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">
           <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">";
  }
  print "&nbsp;<input type=submit name=ACTION_back value=\"$G->{submit_back}\"> </form>";
}

sub priorities {
  my $sel;
  %PRIO = &get_PRIO();
  foreach my $k (sort keys %PRIO) {
    next if ($k eq "*");
    $xx = "$k=$PRIO{$k}";
    $sel .= $xx;
    $sel .= " ($k)" if ($k >= 0 && $k < 9);
    $sel .= "|";
  }
  chop($sel);
  return $sel;
}

sub add {
  my($q) = @_;
  my($ho, $o, $err);

  print "\n";
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs')->section('email');

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;

  } elsif ($q->{ACTION_add1}) {
    while (1) {
     if ($q->{type} ne "File" && $q->{email} !~ /^.+\@.+/) {
        $err = Html->error($L->{err_4});
        last;
     } else {
        ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
        $x = $#$notifs + 1;
        $notifs->[$x]{_name}    = "notification" . ($x+1);
        $notifs->[$x]{email}    = $q->{email};
        $notifs->[$x]{device}   = $q->{device};
        $notifs->[$x]{language} = $q->{language};
        $notifs->[$x]{email_type} = $q->{email_type};
        $notifs->[$x]{type}     = $q->{type};
        $notifs->[$x]{priority} = $q->{priority};

        if (!$q->{event} || (index($q->{event}, "*") >= 0) ) {
          $notifs->[$x]{event}     = "*" ;
        } else {
          $s = $q->{event}; $s =~ s/\t/|/g;
          $notifs->[$x]{event}     = $s;
        }
        $notifs->[$x]{event}    = "*"  if ($q->{priority} == 91);


        if (!PDM::ConfigFile->write($renv, $dev, $host, $notifs)) {
           print "$G->{'e_100'} <br>";
        } else {
           $info = Html->info($L->{info_3});
        }
        $q->{option} = "";
        &list($q);
        return;
     }
     last;
    }
  }
out:

  $h = Html->header2("admin.gen_maint.email", undef, "#3");

  my($cat) = &main::find_devices();
  my($select) = "";
  foreach $c (@$cat) {
     $select .= lc($c)  ."=" . uc($c) . "|";
  }
  $select .= "Agent=StorageAgent|";
  chop($select) if ($select);
  $device   = "<select name=device ><option value=*>$L->{all_cat}</option>" .
              &main::select($select, $q->{device});
  
  my $sel = &priorities() ;
  $priority = "<select name=priority ><option value=*>$L->{l8}</option>" .
              &main::select($sel, $q->{priority});
  $ev       = "";
  $ev = &display_event_list($q, '-h');
  $evH = &display_event_list($q, 'h');

  $events = "<select name=event size=6 multiple><option value=*>$L->{l1}</option>" .
              &main::select(&find_events);
  my $lang = Html->makeSelect("language", Util->languageList());

  my $email_type = Html->makeSelect("email_type", "S=$L->{type_s}|C=$L->{type_c}");

  $o =<<EOF;

<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::add>
<center>
$h
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{l20} </td>

<tr><td bgcolor=$main'LIGHT align=right width=20%>$L->{l21}:</td>
    <td><input type=radio name=type value=Email checked> $L->{l22}&nbsp;&nbsp;
        <input type=radio name=type value=Pager>$L->{l23}&nbsp;&nbsp;
    </td>

<tr><td bgcolor=$main'LIGHT align=right width=20%>$L->{l24}:</td>
    <td><input type=text name=email size=40 maxlength=60 value="$q->{email}">

<tr><td bgcolor=$main'LIGHT align=right>$L->{type}:</td>
    <td>$email_type</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{l7}:</td>
    <td>$priority</td>



<tr><td bgcolor=$main'LIGHT align=right>$L->{l5}:</td>
    <td>$device</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{l6}:</td>
    <td>$events</td>

</table>
</table>
<b>
<input type=submit name=ACTION_add1 value="$G->{submit_add}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
</form>
EOF

  print $o;

}

sub display_event_list {
  my($q, $filter) = @_;
  my($x, $ck, $out);

  foreach $x (sort keys %{Event->get_types} ) {
     if (substr($filter,0,1) eq "-") {
        next if (Event->get_category($x) eq substr($filter,1));
        $ck = ($q->{"event_$x"})? "checked":"";
        $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";

     } else {
       if (Event->get_category($x) eq $filter) {
         $ck = ($q->{"event_$x"})? "checked":"";
         $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";
       }
     }
  }
  return $out;
}


sub find_events {
  my $ruser = System->get_ruser();
  my $lang = $ruser->{language} || $renv->{language};

  my $F = System->get_home() ."/Lang/System/Labels/$lang/Events.lb";
  if (-f $F) {
    open(O, $F);
  } else {
    open(O, System->get_home() . "/System/Labels/Events.lb");
  }
  my($out);
  while ($l = <O>) {
    chop($l);
    $l =~ s/\s*=\s*/=/;
    $out .= "$l|";
  }
  close(O);
  chop($out);
  return $out;
}







1;
