package GUI::Options;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use GUI::Hosts;
use strict;
use Html;

#  $Id: Options.pm,v 1.38 2002/09/19 15:43:56 ccadieux Exp $

sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUI::Options");

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_submit} ) {
    while (1) {
       my $mailer = $q->{mailer};
       my $ix = index($mailer, " ");
       $mailer = substr($mailer,0,$ix) if ($ix > 0);
       if (!-x $mailer) {
         $err2 = "<center><font color=red><b>" . $G->expand('cannot_ex', $q->{mailer}) . "</b></font>";
       }
       $renv->{gui_bandwidth}       = $q->{band} || "L";
       $renv->{mailer}              = $q->{mailer};
       $renv->{email_per_event}     = $q->{one} ? 1:0;
       $renv->{admin_email}         = $q->{admin_email};
       $renv->{use_hub}             = $q->{use_hub} ? 1: 0;
       $renv->{topo_history_size}   = $q->{topo} || 5;
       $renv->{max_daily_email}     = $q->{max_daily_email};
       $renv->{max_event_file_size} = $q->{max_event_file_size};
       my $hh = System->get_home() . "/htdocs";
       #my $cmd = "/bin/cp $hh/graph$renv->{window}.html $hh/graph.html";
       #print "$cmd<br>";
       #system($cmd);
       $q->{test_refresh}           = 5 if ($q->{test_refresh} < 5);
       $renv->{'test.refresh_rate'} = ($q->{test_refresh} + 0) ;
  
       if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
       } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
       }
       last;
    }

  } elsif ($q->{ACTION_submit2} ) {
    while (1) {
      $last_win = $renv->{window};
      $renv->{window}              = $q->{window};
      $renv->{accessible}          = "N";
      if ($renv->{window} eq "A") {
        $renv->{window}     = "N";
        $renv->{accessible} = "Y";
      }
      if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
      } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
      }
      last;
    }
    print "<meta http-equiv=Refresh target=_top content=\"0;URL=/\">";
    return;

  }

  my $h = Html->header2("admin.gen_maint.options");
  $renv->{topo_history_size} = 5 if (!$renv->{topo_history_size});

  my $showoob = "<input type=checkbox name=showoob " . 
                ($renv->{showoob} eq "Y"?"checked":"") .  ">";
  my $ck5 = $renv->{email_per_event} ? "checked" : "";
  my $refresh = $renv->{'test.refresh_rate'} || 30;
  my $maxevents = $renv->{'max_event_file_size'} || 2;
  my $band = Util->makeSelect("band", "L=$L->{b_low}|H=$L->{b_high}", $renv->{gui_bandwidth});

  my $w = $renv->{window};
  $w = "A" if ($renv->{accessible} eq "Y");

  my $ssize = Html->makeSelect("window", "B=$L->{w_b}|S=$L->{w_s}|N=$L->{w_n}|A=$L->{w_a}",
    $w) ;
  my ($button1, $button2);
  if (!$deny) {
    $button1 = " <input type=submit name=ACTION_submit value=\" $L->{submit_options} \">" ;
    $button2 = " <input type=submit name=ACTION_submit2 value=\" $L->{submit_window} \">" ;
  }
  my $max = Html->makeSelect("max_daily_email", "0=$L->{max_daily0}|5|10|20|50", $renv->{max_daily_email});
  my $hub = "checked" if ($renv->{use_hub});
  my $o =<<EOF;

<body bgcolor=$main'BGCOLOR>
<form method=post>
 <input type=hidden name=GO value=GUI::Options::upd>
<center>
$h
$info
$error
$err2
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=#666699><b><font color=white>&nbsp;$L->{label}</td>
<tr><td bgcolor=$main'LIGHT width=40% align=right>$L->{old_topo_cnt}:</td>
    <td>&nbsp;<input type=text size=3 name=topo value=\"$renv->{topo_history_size}\">

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{refresh}: </td>
    <td>&nbsp;<input type=text name=test_refresh size=4 value=$refresh> $L->{min}</td>

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{max_events}: </td>
    <td>&nbsp;<input type=text name=max_event_file_size size=4 value=$maxevents> (Meg)

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{email_path}: </td>
    <td>&nbsp;<input type=text name=mailer size=30 value=\"$renv->{mailer}\"> 

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{admin_email}: </td>
    <td>&nbsp;<input type=text name=admin_email size=30 value=$renv->{admin_email}> 

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{one_email}: </td>
    <td>&nbsp;<input type=checkbox name=one $ck5>

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{max_daily_email}: </td>
    <td>&nbsp;$max

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{bandwidth}: </td>
    <td>$band

<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{use_hub}: </td>
    <td><input type=checkbox name=use_hub $hub>

</table>
</table>
<b><table border=0><tr><td></table>
  $button1
</form>
<form method=post target=_top>
<br>

<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=#666699><b><font color=white>&nbsp;$L->{submit_window}</td>
<tr><td colspan=4>$L->{window_info}
<tr><td align=right bgcolor=$main'LIGHT width=40%> $L->{window}: </td>
    <td>&nbsp;$ssize
</table>
<b><table border=0><tr><td></table>
  $button2
</form>
EOF
  print $o;
}

1;
 
