package GUI::ProcMgr;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Util;
use AutoForm;
use strict;
use GUI;
use Tasks;
use Cache;
use Html::List;
use GUI::Graph;
use Html::Tabs;
use System;
use Scheduler;

#
# LIST ALL CURRENT PROCESSES 
#
sub list {
  my($q) = @_;
  my($renv, $devs, $hosts,$notifs, $command, $opts, $sel,$local );
  my($out, $tag);
  $q->{prefix}  = "StorTools" if (!$q->{prefix});
  my $prefix = uc(substr($q->{prefix},0,2)) || "ST";

  my $L = Labels->read('GUI::ProcMgr')->section('list');
  my $G = Labels->read();

  my $PLIST = $q->{PLIST}; # process _list
  $tag = ($prefix eq "ST")? "Test":"Proc.";

  my $MODE = $q->{MODE};
  my $u1 = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::list&PLIST=$PLIST&MODE=O&WIN=$q->{WIN}>$L->{running}</a>";
  my $u2 = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::list&PLIST=$PLIST&WIN=$q->{WIN}>$G->{all} ${tag}s</a>";
  if ($MODE eq "O") {
     $u1 = "<b>$u1</b>";
  } else {
     $u2 = "<b>$u2</b>";
  }
  my $u3;
  if ($q->{WIN}) {
    $u3 = "| <a href=javascript:window.close()>$G->{close}</a>";
  }
  my $head = "\n<head><title>$tag Manager</title></head><body bgcolor=#E2E2E2 vlink=blue><center>";

  print Html->header2("diagnose.test.test_mgr", "100%", undef,
             undef, {right => "$u1 | $u2 $u3", noTabs => $q->{WIN}, noCrumb => $q->{WIN} }) ;

  $out .= "
    <table border=0 cellspacing=2 cellpadding=0 width=100%>
  <form><input type=hidden name=GO value=GUI::ProcMgr::list>
  <input type=hidden name=prefix value=$prefix>
  <input type=hidden name=MODE value=$PLIST>
  <input type=hidden name=WIN value=$q->{WIN}>
  <input type=hidden name=PLIST value=$MODE>
    </table>
        ";

  my $info; 
  if ($q->{ACTION_del_all}) {

     delete_tests();

    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    foreach my $h (@$hosts) {
       # do slaves
       my $master = $renv->{hostname};
       my $rc = Util::Http->getCommand($h->{hostname}, "GUI::ProcMgr::delete_tests&master=$master&HTTP=1", 10);
    }

   } elsif ($q->{ACTION_del_sel}) {
    my $del_cnt;
    foreach my $v (keys %$q) {
       next if (substr($v,0,4) ne "del_");
       $del_cnt++;
       print "Deleting " . substr($v,4) . " ..<br>\n";
       if (substr($v,0,10) eq "del_local_") {
          my $pid = substr($v,10);
          Scheduler->delete($prefix,$pid, "");
       } else {
          my (@x) = split(/_/, $v);
          Scheduler->delete($prefix,$x[2], $x[1]);
       }
    }
    if (!$del_cnt) {
       print "<font color=red><b>$L->{err_nothing_sel}</b></font>";
    }

    
  } elsif ($q->{ACTION_archive}) {
    my $arch_cnt;
    foreach my $v (keys %$q) {
       next if (substr($v,0,4) ne "del_");
       print "Archiving " . substr($v,4) . " ..<br>\n";
       $arch_cnt++;
       if (substr($v,0,10) eq "del_local_") {
          my $pid = substr($v,10);
          Scheduler->archive($prefix,$pid, "");
       } else {
          my (@x) = split(/_/, $v);
          Scheduler->archive($prefix,$x[2], $x[1]);
       }
    }
    if (!$arch_cnt) {
       print "<font color=red><b>$L->{err_nothing_sel}</b></font>";
    }

  } elsif ($q->{ACTION} eq "RunXX") {
    my $ix = index($q->{command}, " ");
    if ($ix > 0) {
       $command = substr($q->{command},0,$ix);
       $opts = substr($q->{command},$ix+1);
    } else {
       $command = $q->{command};
    }
    my $h = ($q->{host} eq "local") ? undef: $q->{host};
    my $pid = Scheduler->run('ST',$h, $command, $opts, 0, {}, 10);
    print "<b>Process $pid ($command) started!";
  }

  ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  $sel = "<option>local";
  foreach my $h (@$hosts) {
     $sel .= "<option>$h->{hostname}";
  }
  
  $out .= "<script>
function win1(a,b) {
  var b = '$Http::WEBPROC?GO=GUI::ProcMgr::display&prefix=$prefix&pid=' + a + '&host=' + b;
  var O = window.open(b,'Fav','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>
  ";

  my $cnt = 0;
  my $running;
  my(@DATA);
  foreach my $h (@$hosts, {hostname => $renv->{hostname}}) {

     my $list = Scheduler->processList($prefix,$h->{hostname}, 
                             {status => $MODE, plist => $PLIST} );

     foreach my $l (@$list) {
        my $sh   = Util->shortHostname($l->{host});
        my $host = $l->{host};
        my $pid  = $l->{pid};
        my $pid0  = sprintf("%6.6d", $l->{pid});
        my $status = &_status($l);
        my $start = $l->{start_date};
        my $end   = $l->{end_date};
        my $mins = 24 * 60;
        if (!$end) {
           $mins = "";
        } elsif (substr($start,0,10) eq substr($end,0,10)) {
           $mins = substr($end,11,2)   * 60 + substr($end,14,2) - 
                  (substr($start,11,2) * 60 + substr($start,14,2) );
        }
        $end = substr($end,11) if (substr($start,0,10) eq substr($start,0,10));

        my $url = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::display&MODE=$MODE&prefix=$q->{prefix}&pid=$pid0&PLIST=$PLIST&host=$host&WIN=$q->{WIN}>$prefix-$pid</a>";

        $running = 1 if ($status =~ /Running/);
        my $del = "<input type=checkbox name=del_${host}_$pid>";
        $cnt++;
        my $ix = rindex($l->{command}, "/");
        my $command = substr($l->{command}, $ix+1);
        my $target = $l->{info}{target};
        push(@DATA, [$sh,$url,$command,"<small>$target","<b>$status",substr($start,5),$del]);
     }
  }

  if (!$q->{SORT}) {
     $q->{SORT} = 5;
     $q->{SIGN} = -1;
  }
  my($pageInfo, $list) = Html::List->makeList($q,
                        \@DATA, 
                       [$L->{host},$L->{process},$L->{command},
                        $L->{target},$L->{status},$L->{start},$L->{select}],
                       ['l',     'l',     'l',      'l',    'c',     'l',    'c'],
                       ['+',    '-',      '+',      '+',    '-',     '-'],
                       {pageSize => 18});

  my $ref;
  if ($q->{REFRESH}) {
     $ref = sprintf("%.1f", $q->{REFRESH} * 1.1);
     $ref = 20 if ($ref > 20);
  } else {
     $ref  = $renv->{'test.refresh_rate'} || 60;
  }
  $running = "<meta http-equiv=Refresh content=\"$ref;URL=$Http::WEBPROC?GO=GUI::ProcMgr::list&MODE=$MODE&prefix=$prefix&PLIST=$PLIST&WIN=$q->{WIN}&SORT=$q->{SORT}&REFRESH=$ref\">" 
               if ($running);

  $out .= "
  <table border=1 cellspacing=0 cellpadding=0 width=100% bgcolor=white>
    $list
  </table>
  ";
  if ($#DATA >= 0) {
    $out .= "<table border=0 width=100%>
    <tr><td>$pageInfo</td>
     <td>
     <td align=right>
     <table border=0 cellspacing=0 cellpadding=2>
     <tr><td><b>
       <input type=submit name=ACTION_archive value=\"$L->{submit_archive}\"
     onclick=\"return confirm('$L->{confirm_archive}')\">&nbsp;
       <input type=submit name=ACTION_del_sel value=\"$L->{submit_delete_sel}\"
     onclick=\"return confirm('$L->{confirm_delete_sel}')\">&nbsp;
       <input type=submit name=ACTION_del_all value=\"$L->{submit_delete_all}\"
     onclick=\"return confirm('$L->{confirm_delete_all}')\">
 
     <tr><td align=right>
     </table>
    </table></form>
     ";
  } else {
   if ($MODE eq "O") {
     $out .= "&nbsp;<br><b>". $L->expand('err_no_running', $tag);
   } else {
     $out .= "&nbsp;<br><b>".  $L->expand('err_no_tag', $tag);
   }
  }
  print $head . "\n";
  print $running;
  print $out;
  
}

sub archiveD {
  my($q) = @_;
  my $f = $q->{file};
  my($host, $pid) = split(/\//, $f, 2);
  my $F = System->get_home() . "/DATA/ProcArchive/$f";
  my $prefix = substr($pid,2,2);
  my $tag       = ($prefix eq "ST")? "Test":"Proc.";
  my $L = Labels->read("GUI::ProcMgr")->section("archiveD");

  print "\n<body bgcolor=#F0F0F0><center>";
  my $h = Html->header("$L->{archived} $tag","95%","","test_defaults");
  if (!open(O, $F)) {
     print $L->expand(no_arch => $pid) . "<br>";
     return;
  }
  my ($info, $pro, $out, $err) = Scheduler->read(
              $prefix, $host, substr($pid,5), {archive => 1});
  
  my $status = &_status($info);
  my $dur;
  if ($info->{end_date}) {
     $dur = $info->durationHMS();
  }
  my $cm = $info->{command} if ($info);
  my $ix = rindex($cm, "/");
  $cm = substr($cm, $ix+1);
  my $opts2 = $info->{opts2};
  my @opts2 = split(/\t/, $info->{opts2});
  $opts2 =join(" | ", @opts2);
  my $opts2_cnt = $#opts2+1;
  my $reg_cnt = 0;
  my $options = $info->{opts};
  $options =~ s/\|/| /g;
  my $enclosure = "<tr><td bgcolor=#CCCCFF align=right>$L->{key}: </td>
       <td colspan=3>&nbsp;$info->{info}{key} $info->{info}{ports}</t>" 
       if ($info->{info}{key});

  my $kill = "<tr><td bgcolor=#CCCCFF align=right>$L->{killed}: </td>
       <td colspan=3>&nbsp;$info->{kill}" if ($info->{kill});

  my $registers = "<tr><td bgcolor=#CCCCFF align=right>Devices ($opts2_cnt): </td>
       <td colspan=3>&nbsp;$opts2" if ($#opts2 >= 0);

  my $sd = substr($info->{start_date}, 5);
  my $ed = substr($info->{end_date}, 5);
  my $pid2 = substr($pid,2);
  $pid2 =~ s/_/ /g;
  print "<table border=1 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
   <tr><td colspan=4 bgcolor=#666699><font color=white><b>&nbsp;$pid2</td>
   <tr>
       <td bgcolor=#CCCCFF align=right>$L->{status}: </td> <td><b>&nbsp;$status
       <td bgcolor=#CCCCFF align=right>$L->{host}: </td> <td>&nbsp;$host</td>

   <tr>
       <td bgcolor=#CCCCFF align=right>$L->{start}: </td> <td>&nbsp;$sd ($dur)
       <td bgcolor=#CCCCFF align=right>$L->{target}: </td><td>&nbsp;$info->{info}{target}</td>

   <tr>  

   $kill
   <tr><td bgcolor=#CCCCFF align=right>$L->{passes}: </td><td>&nbsp;$info->{passes}</td>
       <td bgcolor=#CCCCFF align=right>$L->{end}: </td> <td>&nbsp;$ed </td>
   $enclosure
   <tr><td bgcolor=#CCCCFF align=right>$L->{options}: </td>
       <td colspan=3>$cm $options
   $registers
   </table>
   ";
   my ($display, $lines) = _display1($out, \$reg_cnt);
   print "<table border=1 cellspacing=0 cellpadding=3 bgcolor=white width=100%>" .
       "<tr><td>$display</table>";
}

sub archive {
  my($q) = @_;
  my(@DATA, $x);

  my $L = Labels->read("GUI::ProcMgr")->section("archive");

  $q->{prefix}  = "StorTools" if (!$q->{prefix});
  my $prefix    = uc(substr($q->{prefix},0,2)) || "ST";
  my $tag       = ($prefix eq "ST")? "Test":"Proc.";

  print "\n<body bgcolor=#E0E0E0><center>";

  if ($q->{ACTION_del}) {
    my $del_cnt;
    foreach my $v (keys %$q) {
          next if (substr($v,0,4) ne "del_");
          my $file = substr($v,4);
          $del_cnt++;
          my $ix = index($file, "/");
          print "Deleting $file ..<br>\n";
          my $dfile = System->get_home() . "/DATA/ProcArchive/$file";
          unlink $dfile;
          substr($file, $ix+1,1) = "O";
          unlink System->get_home() . "/DATA/ProcArchive/$file";
          substr($file, $ix+1,1) = "P";
          unlink System->get_home() . "/DATA/ProcArchive/$file";
    }
    if (!$del_cnt) {
       print "<font color=red><b>$L->{nothing}</b></font>";
    }
  }

  my $h = Html->header2("diagnose.test.archive", "95%");
  print $h;
  my $days = $q->{DAYS} || 10;
  my $AR = System->get_home() . "/DATA/ProcArchive";
  return if (!-d $AR);
  chdir $AR;
  my $com = "/usr/bin/find . -type f -name \"I_${prefix}_*\" -mtime -$days";
  my @L;
  my @L2 = `$com`;
  
  for ($x=0; $x <= $#L2; $x++) { 
      my $f = substr($L2[$x],2);
      my($host,$name) = split(/\//, $f);
      my $info = Scheduler->readInfo($host, substr($name,2), {archive => 1});
      next if (!$info);
      my $status = $info->statusText(); 
      $host = Util->shortHostname($host);

      my($a1, $a2, $pid, $date, $time) = split(/_/, $name);
      my $lnk = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::archiveD&file=$f>$info->{command}</a>";
      my $del = "<input type=checkbox name=del_$f>";
      push(@DATA, [$host, $lnk, 
                   $info->{info}{dev_type} . ":" . $info->{info}{key}, 
                   $info->{info}{ports},
                   $info->{start_date}, $status, "$date $time", $pid, $del]
          );
  }
       
  if (!$q->{SORT}) {
     $q->{SORT} = 5;
     $q->{SIGN} = -1;
  }
  my($pageInfo, $list) = Html::List->makeList($q,
                        \@DATA, 
            [$L->{host},$L->{test}, $L->{system}, $L->{comp}, $L->{started}, $L->{result}, $L->{archived},$L->{pid}, $L->{select}],
            ['l',  ,'l',     'l',      'l',     'l',     'l',       'l',     'l', 'c'],
            ['+',  '+s',      '+',      undef,   '+',     undef,    '-',      '+'],
            { pageSize => 18 });

  print "
  <table border=1 cellspacing=0 cellpadding=0 width=95% bgcolor=white>
   <tr><td colspan=9 bgcolor=#666699>
     <form><input type=hidden name=GO value=GUI::ProcMgr::archive>
     <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td><font color=white><b>&nbsp;</td>
          <td align=right><font color=white><b>$L->{look_back}:
           <input type=text name=DAYS value=$days size=4> $L->{days}
     </table>
   <tr><td>
    $list
  </table>
  <table border=0 width=95%>
    <tr><td>$pageInfo</td>
     <td align=right><b>
       <input type=submit name=ACTION_del value=\"$L->{delete}\"
     onclick=\"return confirm('$L->{sure}')\">
     <tr><td align=right>
  </form>
  </table>
  ";


}


sub cline {
  my($l, $running, $prefix) = @_;

  my $sh    = Util->shortHostname($l->{host});
  my $host  = $l->{host};
  my $pid   = $l->{pid};
  my $pid0  = sprintf("%6.6d", $l->{pid});
  my $status = &_status($l);
  my $start = $l->{start_date};
  my $ix = rindex($l->{command}, "/");
  my $command = substr($l->{command}, $ix+1);
  $$running  = 1 if ($status =~ /Running/);
  my $short = Util->shortHostname($host);
  return "<tr><td>$short<td>$prefix-$pid</td><td>$command<td>$status<td>$start<td>2";
}


sub _display1 {
  my($out, $reg_cnt) = @_;
  my $out2;
  my $lines ;

  foreach my $el (@$out) {
     if( $el->{run_num} )
     {
        $out2 .="<table border=0 cellspacing=1 cellpadding=1 width=100% bgcolor=#F0F0F0>
         <tr><td><b>$el->{run_num}</b> &nbsp;</table>";
	 $$reg_cnt = 0;
     }
     my $rc = ($el->{rc} != 0) ? "<font color=red>$el->{rc}</font>":$el->{rc};
     $$reg_cnt = $$reg_cnt + 1;
     my $i = "Device($$reg_cnt): <b>$el->{register}</b>,&nbsp;" if ($el->{register});

     if( $el->{date} ){
       $out2 .= "<table border=0 cellspacing=1 cellpadding=1 width=100% bgcolor=#F0F0F0>
        <tr><td>$i Ended: <b>$el->{date}</b>,&nbsp;RC: <b>$rc</b></table>";
     } else {
       # was displaying "Running after test stopped. GUI already gives status
       #$out2 .="<table border=0 cellspacing=1 cellpadding=1 width=100% bgcolor=#F0F0F0>
       #<tr><td>$i&nbsp;RC: <b>$rc</b><b>Running</b></table>";
     }

     my $l = $el->{output};

     $l =~ s/</&lt;/g;
     $l =~ s/#QUESTION (\d+)/<b>#QUESTION $1<\/b>/g;
     $l =~ s/Probable[_ ]Cause\(s\)/<br><b><font color=red>Probable_Cause\(s\)<\/font><\/b>/g;
     $l =~ s/Probable[_ ]Cause/<br><b><font color=red>Probable_Cause<\/font><\/b>/g;
     $l =~ s/Recommended[_ ]Action\(s\)/<br><b><font color=red>Recommended_Action\(s\)<\/font><\/b>/g;
     $l =~ s/Recommended[_ ]Action/<br><b><font color=red>Recommended_Action<\/font><\/b>/g;
     $l =~ s/\n([^\n]+)\?/\n<font color=blue>$1 ?<\/font>/g;
     $l =~ s/\n/<br>\n/g;
     $l =~ s/([\|])/$1 /g;
     $out2 .= $l;
     $l =~ s/\<br\>/$lines++/eg;
     
  }
  return($out2, $lines);
}
#pid | command | arg | host | start | end | err

sub display {
  my($q) = @_;
  my(@p1, @p2, @a, @out);
  my $pid = $q->{pid} + 0;
  my $host = $q->{host};
  print "\n";
  my($info, $pro, $out, $err, $out2);
  my $prefix = uc(substr($q->{prefix},0,2)) || "ST";
  my $tag = ($prefix eq "ST")? "Test":"Proc.";
  $q->{WPAGE} = "O" if (!$q->{WPAGE});
  my $MODE = $q->{MODE};
  my $PLIST = $q->{PLIST};

  my $head = "<body bgcolor=#E2E2E2 onload=window.scroll(0,100000)
         leftmargin=2 topmargin=2 marginwidth=2 marginheight=2
         vlink=red alink=red link=blue>";

  if ($q->{ACTION_sync}) {
    print "Syncing $q->{pid} on $q->{host}...<br>\n";
    Scheduler->syncProcess($prefix,$q->{pid}, $q->{host});

  } elsif ($q->{ACTION_delete}) {
    print "Deleting $q->{pid} on $q->{host}...<br>\n";
    Scheduler->delete($prefix,$q->{pid}, $q->{host});
    GUI::ProcMgr::list($q);
    return;

  } elsif ($q->{ACTION_stop}) {
    print "Halting $q->{pid} on $q->{host}...<br>\n";
    my $done = Scheduler->kill($prefix,$q->{pid}, $q->{host} , {child => 1, signal => 9});
    if (!$done) {  
      print "$Scheduler::ERROR<br>";
    }
    sleep 1;
   } elsif ($q->{QUESTION}) {
      my(@s) = split(/\=/, $q->{QUESTION});
      Scheduler->answer($prefix, $q->{host}, $q->{pid}, $s[0]);
      print "Syncronizing Test Ouput<br>\n";
      sleep(6);
   # print Util->redirect("GUI::ProcMgr::list");

  } elsif ($q->{ACTION} eq "XXQuit" ){
    Scheduler->answer($prefix, $q->{host}, $q->{pid}, "q");
    print "Cancelling Test...<br>\n";
   # print Util->redirect("GUI::ProcMgr::list");
  }

  ($info, $pro, $out, $err) = Scheduler->read($prefix, $host, $pid);

  my $cm = $info->{command} if ($info);
  my $ix = rindex($cm, "/");
  $cm = substr($cm, $ix+1);
  my $pp = "pid=$q->{pid}&host=$q->{host}";
  my $u3 = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::display&MODE=$MODE&$pp&WPAGE=O&&prefix=$q->{prefix}&PLIST=$PLIST><font color=white>Output</font></a>";
  my $u2 = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::display&MODE=$MODE&$pp&WPAGE=P&prefix=$q->{prefix}&PLIST=$PLIST><font color=white>Options</font></a>";
  my $u1 = "<a href=$Http::WEBPROC?GO=GUI::ProcMgr::list&MODE=$MODE&prefix=$q->{prefix}&PLIST=$PLIST><font color=white>$tag List</font></a>";
  if ($q->{WPAGE} eq "P") {
     $u2 = "<b>$u2</b>";
  } elsif ($q->{WPAGE} eq "O") {
     $u3 = "<b>$u3</b>";
  }
  my $body = "<center>
    <table border=0 cellspacing=2 cellpadding=0 width=100%>
  <xform><xinput type=hidden name=GO value=GUI::ProcMgr::list>
  <xinput type=hidden name=prefix value=$prefix>
    <tr><td><b><big><font color=navy>$tag Detail</td>
        <td align=right>
    </table>
        ";

  if (!$info) {
     print $head . $body . "<font color=red><b>Cannot find Process $prefix:$host:$pid<br>";
     print $Scheduler::ERROR;
     return;
  }

  my $err0 = "<font color=red>Error:</font>" if ($#$err >= 0);
  my($duration, $hours, $mins, $secs);
  my $running;
  my $dur ;

  if ($info->{end_date}) {
     $dur = $info->durationHMS();
  }
  my $status = &_status($info);

  if ($status =~ /Running/) {
     my $renv = System->get_renv();
     my $ref;
     if ($q->{REFRESH}) {
        $ref = sprintf("%.1f", $q->{REFRESH} * 1.1);
        $ref = 20 if ($ref > 20);
     } else {
        $ref  = $renv->{'test.refresh_rate'} || 60;
     }
     
     $running = "<meta http-equiv=Refresh content=\"$ref;URL=$Http::WEBPROC?GO=GUI::ProcMgr::display&pid=$q->{pid}&host=$q->{host}&prefix=$q->{prefix}&MODE=$MODE&PLIST=$PLIST&REFRESH=$ref\">" ;
  }
     
  my $opts2 = $info->{opts2};
  my @opts2 = split(/\t/, $info->{opts2});
  $opts2 =join(" | ", @opts2);
  my $opts2_cnt = $#opts2+1;
  my $reg_cnt = 0;
  my $options = $info->{opts};
  $options =~ s/passwd=[^\s\=\|]+//; #remove passwd from output
  $options =~ s/\|/| /g;


  my $enclosure = "<tr><td bgcolor=#CCCCFF align=right>Key/Ports: </td>
       <td colspan=3>&nbsp;$info->{info}{key} $info->{info}{ports}</t>" 
       if ($info->{info}{key});

  my $kill = "<tr><td bgcolor=#CCCCFF align=right>Killed: </td>
       <td colspan=3>&nbsp;$info->{kill}" if ($info->{kill});

  my $registers = "<tr><td bgcolor=#CCCCFF align=right>Devices ($opts2_cnt): </td>
       <td colspan=3>&nbsp;$opts2" if ($#opts2 >= 0);

  print $head . $running . $body;
  my $sd = substr($info->{start_date}, 5);
  my $ed = substr($info->{end_date}, 5);
  my $t2 = $info->{info}{target2};
  $t2 = " &nbsp;$t2" if ($t2);
  my $dur2 = " / $dur" if ($dur);
  my $head0 = "<table border=1 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
   <tr><td colspan=4 bgcolor=#666699>
    <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td><font color=white><b>&nbsp;$prefix-$pid ($cm)</td>
          <td align=right><font color=white>[ $u3 | $u2 | $u1 ]</td></table>
   <tr>
       <td bgcolor=#CCCCFF align=right>Status: </td> <td><b>&nbsp;$status
       <td bgcolor=#CCCCFF align=right>Host: </td> <td>&nbsp;$host</td>

   <tr>
       <td bgcolor=#CCCCFF align=right>Start/Time: </td> <td>&nbsp;$sd$dur2
       <td bgcolor=#CCCCFF align=right>Target: </td><td>&nbsp;$info->{info}{target}$t2</td>

   <tr>  

   $kill
   ";
   if ($q->{WPAGE} eq "P") {
      $head0 .= "
       <tr><td bgcolor=#CCCCFF align=right>Passes: </td><td>&nbsp;$info->{passes}</td>
           <td bgcolor=#CCCCFF align=right>End: </td> <td>&nbsp;$ed </td>
       $enclosure
       <tr><td bgcolor=#CCCCFF align=right>Options: </td>
           <td colspan=3>$cm $options
       $registers
         ";
   }
   $head0 .= " </table>";
   print $head0;
   print "
   <form><input type=hidden name=GO value=GUI::ProcMgr::display>
         <input type=hidden name=host value=\"$host\">
         <input type=hidden name=prefix value=\"$q->{prefix}\">
         <input type=hidden name=pid value=\"$pid\">
         ";                  
  my ($k, $sync);

  my($af_err,$af) = AutoForm->new("System/Tests");
  my $test1 = $af->commandByName($info->{command} );

  if ($status !~ /Done/ && !$test1->{info}{noKill} ) {
    $k = "<input type=submit name=ACTION_stop value=\"Stop Test\"
            onclick=\"return confirm('Are you sure you want to stop this Test?')\">";
    $sync = "<input type=submit name=ACTION_sync value=\"Sync Test\">";
  } else {
    $k = "<input type=submit name=ACTION_delete value=\"Delete Test\"
            onclick=\"return confirm('Are you sure you want to delete this Test?')\">" 
  }


  if ($q->{WPAGE} eq "O") {
    my ($display, $lines) = _display1($out, \$reg_cnt);
    print "<table border=1 cellspacing=0 cellpadding=3 bgcolor=white width=100%>" .
        "<tr><td>$display</table>";
    if ($status =~ /Waiting/) {
      my ($question, $prs, $text) = Scheduler->getQuestion($prefix, $host, $pid);
      chop($question);
      chop($question);
      $question =~ s/</&lt;/g;
      $question =~ s/QUESTION (\d+)/<b>Question $1<\/b>/g;
      my $prompts;
      foreach my $p (@$prs) {
        $prompts .= "<input type=submit name=QUESTION value=\"$p\">&nbsp;";
      }

      print "
       <table border=1 width=100% cellspacing=0 bgcolor=white>
           <tr><td bgcolor=#F0F0D0><center><b>$prompts </td><td align=right><b>$k&nbsp;
       </table>";
      print "<table border=0><tr><td></table>$head0" if ($lines > 26);
      print "</form>";
           
    } else {
      if ($err0 || "@$err") {
        print "<pre>$err0 @$err</pre>";
      } else {
        print "<table border=0><tr><td></table>";
      }
      print "<b> $k $sync</table></form>";
      print $head0 if ($lines > 26);
    }
  }

}
sub _status {
  my($p) = @_;


  if ($p->{status} eq "O") {
    return "<font color=blue>Running";
  } elsif ($p->{status} eq "OQ")  {
    return "<font color=blue>Waiting..";

  } elsif ($p->{rc} =~ /143/)  {
    return "<font color=red>Done:ABORTED";

  } elsif ( ( $p->{rc} >> 8 ) =~ /143/)  {
    return "<font color=red>Done:ABORTED";

  } elsif ($p->{rc} =~ /35072/)  {
    return "<font color=red>Done:ABORTED";

  }elsif ($p->{rc} =~ /999/)  {
    return "<font color=red>Done:SYNC";

  }
  elsif ($p->{rc} !~ /^[0\-,]+$/ ) {
    return "<font color=red>Done:ERROR";
  } else {
    return "<font color=green>Done:OK";
  }
}

sub delete_tests(){

   opendir(O, System->get_home() . "/DATA/Proc");
   my @f = readdir(O); closedir(O);
   foreach my $file (@f) {
      next if (substr($file ,0,1) eq ".");
      opendir(OH, System->get_home() . "/DATA/Proc/" . $file);
      my @hf = readdir(OH); closedir(OH);
      foreach my $hfile (@hf) {
        next if (substr($hfile ,0,1) eq ".");
        unlink(System->get_home() . "/DATA/Proc/$file/$hfile");
      }
   }
}  
sub get_delete_tests(){
    my($q) = @_;
    delete_tests();

  if ($q->{HTTP}) {
     print "OK\n";
  } else {
     return "OK";
  }

}


1;
