package GUI::Providers;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use Html::Tabs;

sub display {
  my($q, $post, $util) = @_;
  my(@M, @tabs);

  print Http->text_header();
  my $L = Labels->read('Provider')->section('names');

  my $out = "<body bgcolor=#E0E0E0>\n<center>";

  if (my $err = Roles->verifyRole($q, "admin")) {
     print $out;
     print $err;
     return;
  }

  my $renv = System->get_renv();

  $out .= Html->header2("admin.gen_maint.providers", "90%", undef, " ");

  opendir(O, System->get_home() . "/lib/Provider");
  @list = readdir(O); closedir(O);

  $cnt = 1;
  foreach $p (sort @list) {
     next if ($p !~ /.pm$/);
     $name = substr($p, 0 , -3);
     next if ($name eq "Email");
     # next if ($name eq "NSM" && $renv->{activate_nsm} ne "Y");
     $M[$cnt]= $name;
     $cnt++;
     if (!(eval "require \"Provider/$name.pm\"")) {
       $out .= "$name: $!";
     }
  }

  $q->{option} = 1 if (!$q->{option});

  $pack = $M[$q->{option}];
  my $module = "Provider::$pack";


  $form =  $module->UPDATE($q);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  $cnt = 1;
  foreach $p (sort @list) {
     next if ($p !~ /.pm$/);
     $name = substr($p, 0 , -3);
     $name0 = lc($name);
     next if ($name0 eq "email");
     #next if ($name eq "NSM" && $renv->{activate_nsm} ne "Y");

     $module = "Provider::$name";
     $desc =  $L->{$name0};

     $flag = ($renv->{"pro.$name0.active"} eq "Y")? "(On)":"(Off)";
     push(@tabs, "$cnt=$desc $flag");
     $cnt++;
  }

  my $table = Html::Tabs->create(list  =>  \@tabs,
                       url  => "$Http::WEBPROC?GO=GUI::Providers::display",
                     width  => "90%",
             selectedColor  => "white",
         selectedTextColor  => "blue",
           backgroundColor  => $main'LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
               );

  my($info) = Util->readHtdocs("provider_$pack");

  print $out;
  print $table;
  print $info;
  print $form;

}

1;
