package GUI::Roles;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use strict;
# WINDOW = S : small window, few frames.
#          B : big window, many frames.
#          N : no frames at all.

use Roles;


sub test {
  my($q) = @_;
  foreach my $x (keys %$q) {print "$x=$q->{$x}<br>"}
  print "\n<body bgcolor=white>
  <a href=$Http::WEBPROC?GO=GUI::Roles::test>Test link</a><br>
  <form>
  <input type=hidden name=GO value=GUI::Roles::test>
  <input type=text name=field1 value=field1>
  <input type=submit name=ACTION value=Submit>
  </form>";
}

sub update {
  my($q) = @_;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Roles');

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print "\n<body bgcolor=#F0F0F0><center>";

  print Html->header2("admin.system.roles");

  if (my $err = Roles->verifyRole($q, "admin|c_admin")) {
     print $err;
     return;
  }

  my $ruser      = System->get_ruser();
  my $isCustomer = $ruser->{isCustomer};
  my $info;
  if ($isCustomer) {
     $info = $L->{info1};
  } else {
     $info = Util->readHtdocs("role_maint");
  }

  my $db = Roles->read();

  my ($adds, $dels, $INFO);
  my $roles = $db->getRoles();

  $#$roles-- if ($roles->[$#$roles] eq "peer");

  if ($q->{ACTION_update}) {
     foreach my $k (keys %$q) {
       if (substr($k,0,4) eq "del_") {
          my $user = substr($k,4);
          $dels .= "$user,";
          $db->deleteUser($user);
           
       } elsif (substr($k,0,5) eq "USER_") {
          my $ix = substr($k,5);
          my $user = lc($q->{$k});
          $user =~ s/\W+/_/g;
          $user = "u$user" if ($user =~ /^\d+/);
          next if (!$user);
          my $name = $q->{"USER_$ix"};
          my $password = $q->{"PASS_$ix"};
          my $lang = $q->{"LANG_$ix"};
          my $window = $q->{"WINDOW_$ix"};
          my $access = "N";
          if ($window eq "A") {  # accessible 
             $window = "N"; $access= "Y";
          }
          my $rlist;
          foreach my $r (@$roles) {
             my $r0 = "ROLE_" . $ix . "_$r";
             if ($q->{$r0}) {
                if (substr($r,0,2) ne "c_" && index($rlist, "c_") >= 0) {
                   $INFO = Html->info("$user:" . $L->{invalid_role});
                   goto out;        
                }
                $rlist .= "$r|";
             }
          }
          if ($name && $password && $rlist) {
            $db->addUser($user, $name, $password, $rlist, $lang, $window, $access);
            $adds .= "$user, ";
          } else {
            $INFO = Html->error($L->expand('err_no_name', $user));
          }         
       } elsif (substr($k,0,5) eq "pass_") { # update
          my $id = substr($k,5);
          my $user = $db->getUser($id);
          my $name = $id;
          if ($user) {
             if ($q->{"pass_$id"}) {
                $user->{password} = Roles->encode($q->{"pass_$id"});
             }
             $user->{window}   = $q->{"window_$id"};
             $user->{language} = $q->{"lang_$id"};
             $user->{access}   = "N";
             if ($user->{window} eq "A") {
                $user->{window} = "N";
                $user->{access} = "Y";
             }
             my $rlist;
             foreach my $r (@$roles) {
                my $r0 = "role_$r" ."_$id";
                if ($q->{$r0}) {
                   if (substr($r,0,2) ne "c_" && index($rlist, "c_") >= 0) {
                      $INFO = Html->info("$name:". $L->{err_2users});
                      $db->deleteUser($id);
                      goto out;        
                  }
                  $rlist .= "$r|";
                }
             }
             if ($rlist) {
               $user->{roles} = $rlist;
             } else {
               $INFO = Html->error($L->expand('err_cannot_rem', $id));
             }
          }
       }
     }
     $INFO = Html->error($L->expand('err_dels', $dels)) if ($dels);
     $INFO = Html->info( $L->expand('info_add', $adds))  if ($adds);
     
     $db->write();
  }
out:
  print "
  <table border=0 width=95% bgcolor=white cellpadding=4><tr><td>$info</table>
  $INFO
  <form><input type=hidden name=GO value=GUI::Roles::update>";

  my $userlist = $db->idList();
  my $TOT = 6;

  my $cols = ($isCustomer ? 1 : $#$roles)+$TOT + 1;

  my $head = "<table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr><td colspan=$cols bgcolor=#666699><font color=white><b>$L->{label}
   <tr><td  bgcolor=#CCCCFF colspan=$TOT>&nbsp;
   <td colspan=2 bgcolor=#CCCCFF><b><center>$L->{customer}</td>";
   if (!$isCustomer) {
       $head .= "<td colspan=" . ($#$roles-1) . " bgcolor=#CCCCFF><b><center>$L->{service}</td>";
   }


  $head .= "<tr bgcolor=#CCCCFF><td><b><center>#<td><b>&nbsp;$L->{l_del}
     <td><b>&nbsp;$L->{l_user}
     <td><b>&nbsp;$L->{l_pass}
     <td><b>&nbsp;$L->{l_lang}
     <td><b>&nbsp;$L->{l_window}
    ";
  foreach my $r (@$roles) {
     my $r0 = $r;
     next if ($isCustomer && substr($r0,0,2) ne "c_");
     my $tname = $L->{$r0};
     $r0 = substr($r0,2) if (substr($r0,0,2) eq "c_");
     $head .= "<td bgcolor=#CCCCFF><center><b>$tname</td>";
  }
  print $head;
  my $cnt = 0;
  my $data;
  my $WIN_OPTIONS = "B=$L->{big}|S=$L->{small}|N=$L->{nof}|A=$L->{access}";
  my $LEVELS = "d=$L->{level_d}|s=$L->{level_s}";

  foreach my $userid (sort @$userlist) {
     my $user = $db->getUser($userid);
     my $lang = $user->{language};
     next if ($isCustomer && index($user->{roles}, "c_") < 0);
     next if (index($user->{roles}, "peer") >= 0);
     $cnt++;
     my $ck;
     my $peer = 1 if (index($user->{roles}, "peer") >= 0);
     foreach my $r (@$roles) {
       my $checked = (index("|$user->{roles}|", "|$r|") >= 0) ? "checked":"";
       next if (substr($r,0,2) ne "c_" && $isCustomer);
       my $bg = "bgcolor=#FFFFDD" if (substr($r,0,2) eq "c_");
       if ($peer) {
         $ck .= $checked ? 
           "<td $bg><center>X<input type=hidden name=role_${r}_$userid value=X>": "<td>&nbsp;";
       } else {
         $ck .= "<td $bg><center><input type=checkbox $checked name=role_${r}_$userid>";
       }
     }
     
     my($pass,$del, $lang2, $window);
     if (!$peer) { 
         $del  = "<input type=checkbox name=del_$userid>" ;
         $pass = "<input type=password size=10 name=pass_$userid>";
         $user->{window} = "A" if ($user->{access} eq "Y");
         $window = Html->makeSelect("window_$userid", $WIN_OPTIONS, $user->{window} );
         $lang2 = Html->makeSelect("lang_$userid", Util->languageList(), $user->{language});
     }
     $data .= "<tr><td><center>$cnt
    <td><center>&nbsp;$del
    <td>&nbsp;$userid
    <td>&nbsp;$pass
    <td>&nbsp;$lang2
    <td><center>&nbsp;$window
     $ck
     \n";
  }

  my  $last = ($cnt < 6) ? 6:5;
  my($x);
  for ($x=1; $x <= $last; $x++) {
     my $sel1 =  Html->makeSelect("WINDOW_$x", $WIN_OPTIONS);
     my $ck;
     foreach my $r (@$roles) {
       next if (substr($r,0,2) ne "c_" && $isCustomer);
       my $bg = "bgcolor=#FFFFDD" if (substr($r,0,2) eq "c_");
       $ck .= "<td $bg><center><input type=checkbox name=ROLE_${x}_$r>";
     }
     my $lang2 = Html->makeSelect("LANG_$x", Util->languageList());
     $data .= "<tr><td colspan=2><center>$L->{add1}:<td>&nbsp;<input type=text name=USER_$x size=10>
       <td>&nbsp;<input type=password name=PASS_$x size=10>
       <td>$lang2
       <td><center>&nbsp;$sel1
       $ck
       ";
  }
  print $data;

  print "</table>
  &nbsp;<br><b>
  <input type=submit name=ACTION_update value=\"$L->{submit_1}\"></form>";

}
1;

