package GUI::Stats;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use System;
use Util;
use Timelapse;
use strict;


sub agent {
  my($q) = @_;
  my($v, %M, $tt, $mins, %X, $secs, $out, $x);

  my $L = Labels->read("GUI::Stats");
  print "\n<body bgcolor=#E0E0E0>";
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  my $a = Timelapse->readAll();

  my $a = Timelapse->readAll();
  
  foreach $x (keys %$a) {
     $v = $a->{$x}{avg};
     $M{$renv->{hostname}}{$x} =  $v->[1] / $v->[0];
     $X{$x} = 1;
  }


  foreach my $h (@$hosts) {
     print "Calling $h->{hostname}..<br>\n";
     $a = Timelapse->readAll($h->{hostname});
     foreach $x (keys %$a) {
        $v = $a->{$x}{avg};
        $M{$h->{hostname}}{$x} = $v->[1] / $v->[0];
        $X{$x} = 1;
     }
  }
  my $cnt =2;
  foreach $x (keys %X) { $cnt++}

  print "<center>";
  print Html->header2("report.general.agent_stats", "90%");

  $out = "<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
   <tr bgcolor=#666699>
     <td colspan=$cnt>
      <font color=white><b>$L->{title}
   <tr bgcolor=#E0E0E0><td><b>&nbsp;$L->{host}</td>";

  foreach $x (sort keys %X) { 
      my $x0 = $x; $x0 =~ s/Agent//;
      $x0 =~ s/:://;
      $out .= "<td><b>&nbsp;$x0</td>";
  }

  $out .= "<td><b>$L->{total}";
  
  my $hosts = 0;
  my(%AV);

  foreach my $h (keys %M) {
     $out .= "<tr><td>&nbsp;$h";
     $hosts++;
     my $sum = 0;
     foreach my $m (sort keys %X) {
        my $v1 = $M{$h}{$m};
        my $c1 = &cell($v1);
        $out .= $c1;
        $sum += $v1;
        $AV{$m} += $v1;
     }
     $out .= &cell($sum);
  }
  $out .= "<tr bgcolor=#F0F0D0><td><b> $L->{average}:</td>";
  my $tot;
  foreach my $m (sort keys %X) {
     my $v1 = $AV{$m}/$hosts;
     $tot += $v1;
     $out .= &cell($v1);
  }
  $out .= &cell($tot);
  print "$out</table>";
     


}

sub cell {
  my($v1) = @_;
  my $mins = int($v1/60);
  my $secs = $v1 % 60;
  return "<td>&nbsp;" . sprintf("%2.2d:%2.2d", $mins,$secs) . "</td>";
}

1;
