package GUI::Traffic;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Util;
use AutoForm;
use strict;
use TO;
use TO::Applet;
use PDM::ConfigFile;
use GUI;
use Tasks;
use Tests;
use Cache;
use Html::List;
use GUI::Graph;
use Html::Tabs;
use System;
use Scheduler;


sub run {
  my($q) = @_;
# foreach my $x (keys %$q) {print "$x=$q->{$x}<br>"}
  my $LB =  Labels->read("GUI::Traffic");
  print Html->body();
  my($renv) = System->get_renv();

  my($select_host, $filter) = GUI->topoPage($q);
# my($selected, $head) = GUI->test_head($q);


  my $cache_file = "/tmp/traffic_" . $q->{topo};
  my $cache_date =  Util->get_file_created(System->get_home() . "/DATA/$cache_file");
  my ($cache_info, $hrs, $mins, $secs) ;
  if ($cache_date) {
   ($hrs, $mins, $secs) = Util->getFileAge(System->get_home() . "/DATA/$cache_file", "hms");
   $cache_info = " <small>" . substr($cache_date, 5) . " ( ${hrs}h ${mins}m ${secs}s</small>)";
  }
  print Html->header2("report.general.fc_traffic", "100%");
  my $header = "<table border=0 cellspacing=1 cellpadding=0 bgcolor=#CCCCFF width=100%>
   <tr><td>
   <form>
       <input type=hidden name=GO value=GUI::Traffic::run>
       <b>&nbsp;$LB->{traffic}:$select_host <small>
          <input type=submit name=ACTION value=GO>
   <td><b><center>$LB->{baseline}: $cache_info</td>
   <td align=right><b><input type=submit name=ACTION_set value=\"$LB->{set}\">
                   <input type=submit name=ACTION_total value=$LB->{total}>&nbsp;</td>
   <tr><td></td>
   </table>";
  
  my($o1, $meta);

  my $linkInfo = {};

# find the hosts  with switches
  my $to = TO->readExistingTopo($q->{topo});
  if (!$to) {
     print "No Topo $q->{topo}!"; return;
  }
  my $switches = $to->switchList();
  my (%ST);
  foreach my $st (@$switches) {
    $ST{$st->name()} = 1;
  }
  my $Config = PDM::ConfigFile->read();
  my $devs = $Config->devices();
  
  my %H;
  foreach my $d (@$devs) {
     next if ($d->{type} ne "switch");
     if ($ST{"switch:$d->{key}"}) {
        $H{$d->{host}|| $renv->{hostname}} = 1;
     }
  }     
# for each host, get and the san report.
  my $tot;
  my $summ  = "<table border=1 cellspacing=0 bgcolor=white width=300 >
  <tr bgcolor=#CCCCFF>$LB->{header}";

  foreach my $h (keys %H) {
    my ($err, $r) = Report->readReport("san:san", $h);
    next if (!$r);
    my $value = $r->value();
    foreach my $k (keys %$value) {
      next if (substr($k,0,8) ne "FC_Agent");
      my $ss = $value->{$k};
      if (exists($ss->{data})) {
        foreach my $k (keys %{$ss->{data}} ) {
          my($a1,$a2,$a3, $a4) = split(/\|/, $k);
          my $sw1 = $to->nodeByKey($a2);
          my $pno = substr($a3,5);
          if ($sw1 && $sw1->getPortLink($pno)) {
            my(@L) = split(/\t/, $ss->{data}{$k});
            $tot +=  $L[6] + $L[7];
            $linkInfo->{$sw1->type() . ":$a2,$pno"} = $L[6] + $L[7];
          }
        }
      }
    }
  }

  if ($q->{ACTION_total}) {
    unlink System->get_home() . "/DATA/$cache_file";

  } elsif ($q->{ACTION_set}) {
    Util->serialize($cache_file, $linkInfo);
  }
  if ($cache_date) {
     my $cache = Util->deserialize($cache_file);
     foreach my $x (keys %$linkInfo) {
        $linkInfo->{$x} -= $cache->{$x};
        $tot -= $cache->{$x};
     }
  }
  $tot = 1 if (!$tot);
  my $tt;
  foreach my $x (sort keys %$linkInfo) {
     #$linkInfo->{$x} = sprintf(" %.1f", ($linkInfo->{$x} * 100 / $tot));
     $linkInfo->{$x} = sprintf(" %.1f", $linkInfo->{$x}/1000);
     my $x2 = rindex($x,",");
     my $name = substr($x,0, $x2);
     my $port = substr($x, $x2+1);
     my $dev = $Config->deviceByKey($name);
     $name   = $dev->{name} || $x;
     $summ .= "<tr><td>&nbsp;$name</td><td>$dev->{ipno}&nbsp;</td><td><center>$port</td><td align=right>&nbsp;$linkInfo->{$x}&nbsp;</td>";
     $tt += $linkInfo->{$x};
  }
  $summ .= "<tr><td colspan=3 align=right><b>Total:<td align=right>&nbsp;$tt</td>";
  $summ .= "</table>";

  $q->{FILTER} = "*";
  my($out2, $running) = TO::Applet->genAppletData($q, 1, $linkInfo); # returns <parms ...
  if ($running) {
     my $ref = $renv->{'test.refresh_rate'} || 60;
     #$meta = "<meta http-equiv=Refresh content=\"$ref;URL=$Http::WEBPROC?GO=GUI::Test::topo\">";
  }

  my $current = $q->{topo};
  my($applet, $parm1, $parm2);
  my $zoom = $q->{zoom}  + 0;

  $applet = System->appletHeader("code=VertexApplet.class codebase=Topo archive=topo21.jar",35,80);

  $parm1 =<<EOF;
  <param name=url value="GO=GUI::Graph::get_topos&topo=$current&FILTER=$q->{FILTER}">
  <param name=urlRefresh value="GO=GUI::Graph::get_topos&topo=$current">
  <param name=timeRefresh value="10000">
  <param name=circle value="$q->{key}">
  <param name=showLinkHandle value=1>
  <param name=graphicsButton value=1>

  <xparam name=ldrop1 value="Test Link|details||GO=GUI::Test::get_testlink&topo=$current">
  <xparam name=ldrop2 value="Display Error|details|h|GO=GUI::Graph::get_fibrelog&topo=$current">
  <param name=browser value="sun">
EOF

   print $meta .  $header .  $applet .  $parm1 .  $out2 . " </applet> </form>";
  
   print "<b>Summary: \n<br>$summ <br>";
}




1;
