package GUIAdmin::MCDATA;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: MCDATA.pm,v 1.1 2002/08/01 16:30:07 mckenney Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUI::Devices;
use GUIAdmin;
use base 'GUIAdmin';
use Agent::MCDATA;
sub description {'McDATA'};

sub isDevice {1}

sub ipRequired {1}

sub getDevices {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn);

  my($HOME) = System->get_home();
  if (open(RUN, "/etc/fcswitch.conf")) {
     while ($l = <RUN>) {
         chop($l);
         next if (substr($l,0,1) eq "#" || $l =~ /^\s*$/);
         my(@a) = split(/\s+/, $l);
         $f .= "$a[0]|$a[1]\n";
     }
     close(RUN);
     return "OK $f\n";
  } else {
     return "ERR $!";
  }
}

sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);

  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  my $G = Labels->read();

  require "GUI/Devices.pm";
  if ($q->{ACTION_back})  {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    while (1) {
     if ($q->{name} eq "") {
        $err = Html->error($G->{device_name_mandat});
        last;
     } elsif (!$q->{ip}) {
        $err = Html->error($G->{must_enter_ip});
        last;
     } else {
        if (!($ipno = Util->testIp($q->{ip}))) {
           $q->{ERR} = Html->error($G->expand('cannot_ping_this','switch', $q->{ip}));
           $active = "N";
        }
        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        foreach $x (@$dev) {
          if ($x->{name} eq $q->{name}) {
             $err = Html->error($G->{device_name_already});
             goto out;
          } elsif ($q->{ip} && $x->{ip} eq $q->{ip}) {
             $err = Html->error($G->{device_ip_already});
             goto out;
          } elsif ($ipno && $x->{ipno} eq $ipno) {
             $err = Html->error($G->{device_ip_already});
             goto out;
          }
        }
        $x = $#$dev + 1;
	my $wwn = Util->snmpWWN($ipno);
	my $mymodel = Agent::MCDATA->getModel($q->{ip});

        $dev->[$x]{_name}    = "device" . ($x+1);
        $dev->[$x]{type}     = "mcdata";
        $dev->[$x]{class}    = "switch.mcdata";
        $dev->[$x]{name}     = $q->{name};
        $dev->[$x]{active}   = $active;
        $dev->[$x]{ip}       = $q->{ip};
        $dev->[$x]{telnet}   = Util->encodeAll($q->{telnet});

        $dev->[$x]{wwn}      = $wwn;
        $dev->[$x]{key}      = $wwn;
	$dev->[$x]{userLabel}= $mymodel;
        $dev->[$x]{ipno}     = $ipno;
        $dev->[$x]{host}     = $q->{host};

        GUIAdmin->clearSlave($q->{host}, $host);

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print "$G->{cannot_write_config}<br>";
        } else {
           $info = Html->info($G->{device_added});
        }

        GUI::Devices::list($q);
        return;
     }
     last;
    }
  }
out:
  print GUI::Devices::add0($q);

  my($h) = Html->header("$G->{add} McDATA Switch","","",
        "Maintenance.General#adddevice", undef , {nohelp => 1});

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";

  foreach $x (@$host) {
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::MCDATA->addDevice">
<center>
$h
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$G->{device_name}:</td>
    <td><input type=text name=name size=15 maxlength=15 value="$q->{name}">

<tr><td bgcolor=$main'LIGHT width=30% align=right>$G->{telnet}:</td>
    <td><input type=password name=telnet size=20 maxlength=30 >

<tr><td bgcolor=$main'LIGHT align=right>$G->{primary_host}:</td>
    <td>$phost</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right> $G->{ip_name}:</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">

</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=\" $G->{submit_add} \">";
  }
  print "<input type=submit name=ACTION_back value=\"$G->{submit_back}\"></form>";

}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
  my $G = Labels->read();

  print "\n";
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});

    $dev->[$x]{class}= "switch.mcdata";
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->expand('device_updated',  $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change($G->expand('device_deleted', $name));
    $q->{ERR} = Html->error($G->expand('device_deleted', $name)); 
    GUI::Devices::list($q);
    return;
  }
out:

  $h1 = Html->header2("admin.gen_maint.maint_device", undef, ": McDATA Switch"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $telnet = Util->decode($h->{telnet});


  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form method=get>
 <input type=hidden name=GO value="GUIAdmin::MCDATA->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$main'LIGHT align=right>$G->{device_type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$main'LIGHT align=right>$G->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$G->{device_name}:</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$G->{ip_name}:</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$G->{ip_number}:</td>
    <td>&nbsp;$ipno</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$G->{telnet}:</td>
    <td><input type=password name=telnet size=20 maxlength=30 value="$telnet">

<tr><td bgcolor=$main'LIGHT align=right>WWN :</td>
    <td><b>$h->{wwn}</td>
<tr><td bgcolor=$main'LIGHT align=right>$G->{primary_host}:</td>
    <td><b>$ho</td>

</table>
</table>
<b>

EOF

  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">
             <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">";
  }
  print " <input type=submit name=ACTION_back value=\"$G->{submit_back}\">
  </form>";

}



1;
