package GUIAdmin::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: T3.pm,v 1.40 2002/09/19 15:44:03 ccadieux Exp $

use PDM;
use Util;
use Html;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::T3;

sub isDevice {1}
sub description {'Sun T3'};

sub ipRequired {1}

sub discover {
  my( $q, $post, $util) = @_;
  my($o, $warn);
  print "\n";
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  foreach my $h1 (@$host) {
      if (!$h1->{t300logfile}) {
        $warn .= "<b><font color=red>Warning: The T300 logfile on $h1->{hostname} has not been entered.</font></b><br>";
      }
  }

  if (!$renv->{t300logfile}) {
     $warn .= "<b><font color=red>Warning: The local T300 logfile has not been entered.".
             "</font></b>";
  } else {
     $warn .= "Local T3 logfile is called: $renv->{t300logfile}";
  }

  if ($q->{ACTION} =~ /by WWN/) {
     $q->{WWN} = 1;
     &discovert3($q, $post, $util);
     return 'DONE';

  } elsif ($q->{ACTION} =~ /Confirm/) {
     &discovert3($q, $post, $util);
     return 'DONE';
  }

  my $h = Html->header2("admin.gen_maint.discovery", undef, ": Sun T3", "discover_t3");

  my $sel = $q->{select_host} || "All Hosts";
  $o =<<EOF;
 <body bgcolor=$main'BGCOLOR>
 <center>
 $h
 <table border=0><tr><td>$warn</table>
</table>
<table border=1 cellspacing=0 cellpadding=4 width=80% bgcolor=white>
  <form method=get>
  <input type=hidden name=GO value=GUI::Discover::discover>
  <input type=hidden name=PKG value=GUIAdmin::T3::discover>
  <input type=hidden name=select_host value=\"$q->{select_host}\">
  <tr><td align=right width=25% bgcolor=#CCCCFF>Selected Host:</td>
      <td><b>$sel</td>
 </table><b>
     <input type=submit name=ACTION value="Confirm T3 Discovery">
 </form>
EOF
  print $o;
  return 0;

}

sub discovert3 {
  my( $q, $post, $util) = @_;

  my(%T, @a, $loc, $ip);
  my(%F);
  my(@NEW);

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
 
  my($log) = $renv->{t300logfile};
  my($cnt) = 0;
  foreach my $d (@$dev) {
     if ($d->{class} =~ /^storage.t3/) {
        $cnt++;
        $F{$d->{key}} = 1;
     }
  }
  print "<pre>1 - Found $cnt t3 already registered ...\n";
  my(%local, $l,  $h, $file);

  if (!$q->{select_host} || $q->{select_host} eq "local") {

    print "2 - Finding t3 in Local Message-Log file ...\n";
    print "2 - Finding t3 in $log Log file ($log)...\n";
    if (open(O, $log)) {
        while ($l = <O>) {
          @a = split(/ +/, $l);
          $loc = $a[3];
          $loc = substr($loc,1) if (substr($loc,0,1) eq "[");
          chop($loc) if (substr($loc,-1) eq "]");
          $loc = substr($loc,0, -4) if (substr($loc,-4) eq ".2.2");
          next if ($loc =~ /\:/);
          $local{$loc} = 1;
        }
        close(O);
    } else {
      print "*** Cannot open $log: $!\n";
    }
  
    foreach $l (keys %local) {
      $ip = Util->testIp($l);
      if ($ip) {
         my($key,$wwn, $wwn2, $ctrl, $t3name)  =  Agent::T3->getWWN($ip);
         if (!$key) {
           print "  - Cannot add $l: no Midplane Serial#.\n";
         } elsif ($wwn) {
           print "  - Found $ip, ";
  
           if (!$F{$key}) {
              push(@NEW, [$ip,"", $l, $wwn, $key, $wwn2, $ctrl, $t3name]);
              $F{$key} = 1;
              print " added\n";
           } else {
              print " Already there\n";
           }
         } else {
           print "  - Cannot add $l: no WWN, probably not a T3.\n";
         }
      } else {
         print "  - Cannot add $l: not accessible.\n";
      }
    }
 }

 my($url, $data, $list, $added, $name, $xx, $x, $status, $wwn, $key, $wwn2, $ctrl);
 my($t3name);
 my($TO) = 60;
 my($RASPORT) = $util->{RASPORT};

 print "3 - Finding t3 in Remote Message-Log file (will time-out in $TO secs)...\n";

  foreach $h (@$host) {
      next if ($q->{select_host} && $q->{select_host} ne $h->{hostname});

      print "  - Querying host $h->{hostname} / $h->{ipno} ...\n";
      $file = $h->{t300logfile};
      next if (!$file);

      if ( ($data = Util::Http->getCommand($h->{ip}, "device&type=t3&file=$file&WWN=$q->{WWN}", $TO)) ) {
         if (substr($data,0,3) eq "ERR") {
           print "  $data<br>";
           next;
         }  
         $list = substr($data,3);
         @a = split(/\n/, $list);
         $added = 0;
         foreach $l (@a) {
             ($status, $name, $ip, $wwn, $key, $wwn2, $ctrl, $t3name)  = split(/=/, $l);
             if ($status eq "OK") {
               $name = Util->trim($name);
               $ip = substr($ip, 0, -4) if (substr($ip, -4) eq ".2.2");
               next if (!$name);
              
               if (!$F{$key}) {
                 $F{$key} = 1;
                 push(@NEW, [$ip,$h->{hostname}, $name, $wwn, $key, $wwn2, $ctrl, $t3name]) ;
                 $added++;
                 print "   -> $name: added.\n";
               } else {
                 print "   -> $name: already there, not added.\n";
               }
             } else {
               print   "   -> $name.\n";
             }
         }
         #print         "   -> Found " . ($#a+1) . " t3(s): $added added.\n";
      } else {
         print "    - No response from $h->{hostname}-$file / $h->{ip}!\n";
      }
  }

  if ($#NEW >= 0) {
      my($new_dev) = $#$dev;
      foreach my $t (@NEW) {
#         print "  *** Adding device: $t->[0] $t->[1]\n";
         if ($t->[2] =~ /^(\w+\.\w+)\.\w+/) {
            $xx = $1;
         } else {
            $xx = $t->[2];
         }
         $xx      = $t->[2];
         my $wwn  = $t->[3];
         my $key  = $t->[4];
         my $wwn2 = $t->[5];
         my $ctrl = $t->[6];
         my $t3name = $t->[7];
         $new_dev++;
         $dev->[$new_dev]{_name}    = "device" . $x;
         $dev->[$new_dev]{type}     = 't3';
         $dev->[$new_dev]{class}    = 'storage.t3';
         $dev->[$new_dev]{wwn}      = $wwn;
         $dev->[$new_dev]{wwn2}     = $wwn2;
         $dev->[$new_dev]{key}      = $key;
         $dev->[$new_dev]{ctrl_model} = $ctrl;
         if ($q->{WWN}) {
            my $ix = rindex($t->[0],".");
            my $l = ($ix > 0) ? substr($t->[0],$ix+1) : $t->[2];
            my $n = ($t->[1]) ? Util->shortHostname($t->[1]) : "T3";
            $dev->[$new_dev]{name}     = "$n-$l";
         } elsif ($t3name) {
            $dev->[$new_dev]{name}     = $t3name;
         } else {
            $dev->[$new_dev]{name}     = $xx;
         }
         $dev->[$new_dev]{active}   = 'Y';
         $dev->[$new_dev]{ip}       = $t->[2];
         $dev->[$new_dev]{ipno}     = $t->[0];
         $dev->[$new_dev]{host}     = $t->[1];
      }
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
  } else {
    print "  *** No new devices were added ***\n";
  }
  print "</pre>";
}

#
# returns the t3 that a slave has.
# response to a http request made by a master rasagent.

sub getDevices {
  my($q, $post, $util) =@_;
  my($l, $loc, @a, $out, $t);

  my(%F);
  if (open(O, $q->{file})) {
     while ($l = <O>) { 
       @a = split(/ +/, $l);
       $loc = $a[3];
       $loc = substr($loc,1) if (substr($loc,0,1) eq "[");
       chop($loc) if (substr($loc,-1) eq "]");
       next if ($loc =~ /^\s*$/);
       next if ($loc =~ /\:/);
       $F{$loc} = 1;
     }
     close(O);
     $out = ""; 
     foreach $t (sort keys %F) {
        
        my($ip) = Util->testIp($t,5);
        my($key,$wwn, $wwn2, $ctrl, $t3name) =  Agent::T3->getWWN($ip);
        if (!$ip) {
           $out .= "ERR=cannot ping $t\n";
        } elsif (!$key) {
           $out .= "ERR=No Midplane Serial# for $t\n";
        } elsif (!$wwn) {
           $out .= "ERR=No wwn for $t, probably not a T3\n";
        } else {
           $out .= "OK=$t=$ip=$wwn=$key=$wwn2=$ctrl=$t3name\n";
        }
     }
     return "OK $out\n";
  } else {
     return "ERR $q->{file} $!";
  }
}

sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel, $warn);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::A1000")->section("add");

  require "GUI/Devices.pm";
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my($err, $dev) = Logic::T3->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($dev) {
       print Html->info($G->{device_added});
       GUI::Devices::list($q);
       return;
    }
  }

  print Html->body();
  print GUI::Devices::add0($q);

  my $h = Html->header2("admin.gen_maint.add_device", undef, "Sun T3"," ", {nocrumb => 1});

  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[Select]</option>".
              "<option value=\"\" $sel>Local</option>";
  foreach $x (@$host) {
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $x (@$host, $l1) {
    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "<option value=\"*None\">*None</option></select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::T3->addDevice">
 <input type=hidden name=ADD value=T3>
<center>
$h
$info
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{enter}</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{dev_name}:</td>
    <td><input type=text name=name size=15 maxlength=35 value="$q->{name}">

<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{telnet}:</td>
    <td><input type=password name=telnet size=20 maxlength=30 value="$q->{telnet}">

<tr><td bgcolor=$main'LIGHT align=right>$L->{primary}:</td>
    <td>$phost</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{ip}:</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">

</table>
</table>
<b>
EOF

# <tr><td bgcolor=$main'LIGHT align=right>Data-Path Host :</td> <td>$phostD</td>

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=$L->{submit_add}>";
  }
  print "<input type=submit name=ACTION_back value=$L->{submit_back}></form>";


}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print "\n";
  require "GUI/Devices.pm";
  my $L = Labels->read("GUIAdmin::A1000")->section("update");
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_re}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    my($key, $wwn, $wwn2, $ctrl, $t3name) =  
             Agent::T3->getWWN($dev->[$x]{ipno}, $q->{host});
    $dev->[$x]{key} = $key;
    $dev->[$x]{wwn} = $wwn;
    $dev->[$x]{wwn2} = $wwn2;
    $dev->[$x]{ctrl_model} = $ctrl;
    $dev->[$x]{name} = $t3name if ($t3name);
    GUIAdmin->clearSlave($q->{host}, $host);
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION_upd}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host}   = $q->{host};
    #$dev->[$x]{datahost} = $q->{datahost};
    $dev->[$x]{name}   = $q->{name};
    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});
    $dev->[$x]{class}  = "storage.t3";
    $dev->[$x]{hba}    = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION_del}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    #my($State) = State->read();
    #my $key = $dev->[$x]{key};
    #print "Clearing cache on  $key <br>";
    #$State->clearComponent("t3:$key");
    #$State->write();

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->error("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

  $h1 = Html->header2("admin.gen_maint.maint_device", undef, ": Sun T3"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $sel = ($h->{datahost})? "":"selected";
  my($dataho) = "<select name=datahost><option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $h1 (@$host, $l1 ) {
       $sel = ($h1->{ip} eq $h->{datahost}) ? "selected":"";
       $dataho .= "<option value=\"$h1->{ip}\" $sel>$h1->{hostname}</option>";
  }
  $sel = ($h->{datahost} eq "*None")? "selected":"";
  $dataho .= "<option value=\"*None\" $sel>*None</option></select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $telnet = Util->decode($h->{telnet});


  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::T3->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{title}</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$main'LIGHT align=right>$L->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{name} :</td>
    <td><input type=text name=name size=40 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{telnet} :</td>
    <td><input type=password name=telnet size=20 maxlength=40 value="$telnet)">

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{ip} :</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{ipno} :</td>
    <td>&nbsp;$ipno</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{key} :</td>
    <td>$h->{key}</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{wwn} :</td>
    <td>$h->{wwn} / $h->{wwn2}</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{primary} :</td>
    <td><b>$ho</td>


</table>
</table>
<b>

EOF

#<tr><td bgcolor=$main'LIGHT align=right>Data-Path Host :</td> <td><b>$dataho</td>

  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION_upd value=$L->{submit_update}>
             <input type=submit name=ACTION_del value=$L->{submit_delete}>
             <input type=submit name=ACTION_re value=$L->{submit_re}>";
  }
  print " <input type=submit name=ACTION_back value=$L->{submit_back}> </form>";

}


1;

