package Health::MCDATA;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2002, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: MCDATA.pm,v 1.5 2002/11/01 16:29:26 ccadieux Exp $


use base 'Health';
use NWS::MCDATA;
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.5 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::MCDATA');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_MCDATA});
  return $self;
}

#####################################################

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  my($name)    = $report->name;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my($log)     = $report->log();
  if (!$wwn) {
     Debug->err(ERROR => "This Switch \"$name\" ($ip) cannot be identified");
     return;
  }

  CIM->version("1.1");
  $DB::single = 1;

  return if ($hm->connectionEvent($wwn, $report, {method => 2} ));
  my($audit); 
  my($freq) = System->get_renv()->{audit_freq} || 7;
  if (!$oreport || ($audit = Timer->isXdays("Audit$wwn", $freq)) eq "YES" ) {  
     # new MCDATA or audit time.
     my($etype) = $audit ? "mcdata.AuditEvent" : "mcdata.DiscoveryEvent";
     my($title) = $audit ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => "mcdata:$wwn" ],
                  [ TargetName  => $id  ],
                  [ SourceIP    => $ip  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title McDATA Switch called $id"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::MCDATA->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd,  @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
     if ($audit) {  # dump stats.

        $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'mcdata.Statistics'  ],
                  [ Target      => "mcdata:$wwn" ],
                  [ TargetName  => $id  ],
                  [ SourceIP    => $ip  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "Statistics about McDATA Switch $id :"],
                  [ Data        => Util->nnl($rep->toStringP('port.\d+.stats'))],
                         ]);

        $sd = Events->sourceDetector({ event => $ev });

        my($system_key) = CIM::Key->new( ['NWS_System', 
                    'Name'            =>$rep->get('id.wwn'), 
                    CreationClassName => 'NWS_System']);

        $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $system_key ],
                    ]);

        $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL});

        $pdm->saveMessage($ed);

     }
  }
  return if (!$oreport);


  $orep = $oreport->content;
  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  my($PORTS) = $rep->get('port.count');

# check if port state has changed

  my($comp);
  for ($x=0; $x <= $PORTS; $x++) {
     $comp = "port.$x"; # . sprintf("%3.3d", $x);
     $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $comp, $wwn);
  }
#
# check sensors for changes
#
  my($type, $status, $ostatus, $val, $oval);
  foreach my $el ('fan', 'powerSupply') {
    for ($x=1; $x <= 20; $x++) {
      $type    = $rep->get("sensor.$el.$x.status");
      last if (!$type);
      $hm->alarm($report, $orep, "MCDATA", "sensor.$el.$x", "status", $id, $id, $wwn, "sensor.$el.status");
    }
  }

  $hm->portStatEvents($report, $PORTS, $rep, $orep);

  # Check switch up time
  my($olduptime) = $orep->get("system.uptime");
  my($newuptime) = $rep->get("system.uptime");
  my($oldcuptime) = $orep->get("system.calendar_uptime");
  my($newcuptime) = $rep->get("system.calendar_uptime");

  if ($olduptime > $newuptime) {
     $hm->alarmEvent("system.uptime", $report, $wwn, 
        "Switch uptime decreased on $id from $oldcuptime to $newcuptime", 
        0, "system_reboot", {severity => 1});
  }

      
}

  
sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($pdm) = $hm->{pdm};
   my($map) = $pdm->getDeviceStateMap("mcdata.availability");
   Debug->print3("mcdata: $comp");

   my($status)  = $rep->getState("$comp.state");
   my($ostatus) = $orep->getState("$comp.state");
   $status = $ostatus if ($status eq '[undefined]');
   $status      =~ s/\(\d+\)$//;
   $ostatus     =~ s/\(\d+\)$//;

   my($old)     = $map->get("state.$ostatus");
   my($new)     = $map->get("state.$status");

   return ("$ostatus", "$status",$old, $new );

}


1;

