package Health::Message;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Message.pm,v 1.13 2002/09/19 15:44:04 ccadieux Exp $


use base 'Health';
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.13 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Message');

# Registers for A5K/ T3 message Reports.
#
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_MESSAGE});
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_T3MESSAGE});
  return $self;
}

#####################################################


sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};

  my $hostid   =  $report->deviceName(); 
  my($log)     = $report->log();
  my($logErr)  = $report->logError();
  my $rep      = $report->content();
  my $renv     = System->get_renv();
  my($id)      = $report->id('display');
  $DB::single = 1;

# $log->[2]{key}{name}
# $log->[2]{key}{line}


  if ($log) {  # so far, just t3 messages, but would work for other devices with logfiles
    my($id_ip, $id_cat, $id_dev, $id_disp) = ($report->{_value}{'id.ipno'},
                                            $report->{_id}{category},
                                            $report->{_id}{deviceName},
                                            $report->{_id}{display});
    foreach my $sev (1,2) {
      my $el = $log->[$sev];
      foreach my $target (keys %$el) {
         my $text   = $el->{$target}{line};
         my $disp   = $el->{$target}{name};
         my $count  = $el->{$target}{count};
         my $ip     = $el->{$target}{ip};
         my $label  = $sev == 1? "warning" : "error";
         my ($t1, $wwn) = split(/\:/, $target); 
         $report->{_value}{'id.ipno'} = $ip;
         $report->{_id}{category}  = $t1;
         $report->{_id}{deviceName}= $target =~ /HOST/ ? $renv->{hostname} : $wwn;
         $report->{_id}{display}   = $disp;

         if ($target =~ /HOST/) {
           $report->{_id}{display}   = "";
           $hm->logEvent($text, $report, $hostid, 
             "$count ${label}(s) found in logfile: ". $report->id("logFile") . 
             " on $id:", $sev, $label);

         } else {
           $hm->logEvent($text, $report, $wwn, 
             "$count ${label}(s) found in logfile of $disp:", 
                         $sev, $label);
         }
         $report->{_value}{'id.ipno'} = $id_ip;
         $report->{_id}{category}     = $id_cat;
         $report->{_id}{deviceName}   = $id_dev;
         $report->{_id}{display}      = $id_disp;
      }
    }
  }

  my $cnt;
  my $sev = 0;  # 0,1,2 => NOTICE, WARN, ERR
  foreach my $el ('notices', 'warnings', 'errors') {
    if (exists($rep->{$el})) {
      my $WARN = $rep->{$el};
      foreach my $cat0 (keys %$WARN) {
        my($type, $enc, $cat) = split(/\:/, $cat0);
        my $target;
        if (!$enc) {
           $enc = $hostid;
           $target = $id;
           $report->{_id}{category} = "message";
        } else {
           $target = "$type:$enc";
           $report->{_id}{category} = $type;
           $report->{_id}{deviceName}= $enc;
        }
  
        my $data = $WARN->{$cat0};
        $cnt = 0;
        $data =~ s/\n/$cnt++/eg;
        my $data = $WARN->{$cat0};
        if ($cnt == 1) {
           $data =~ s/\tWWN:\t/ /;
           $hm->logEvent("", $report, $enc, "$target: $data", $sev, "driver.$cat");
        } else {
           $hm->logEvent($data, $report, $enc, 
                      "Found $cnt 'driver.$cat' ${el}(s) in logfile: ".
                      $report->id("logFile") . " on $target:", $sev, "driver.$cat");
        }
      }
    }
    $sev++;
  }
}
1;
