package Health::Slave;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Slave.pm,v 1.18 2002/09/09 17:14:51 ccadieux Exp $

 
#             CREATION
####################################################
 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Report;
use strict;
use CIM::Instance;
use Message;
use CIM::Instance;
use Events;
use Debug;
  
use base 'Health';
sub revision {'$Revision: 1.18 $'}
 
sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Slave');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {INITIAL => 1});
  return $self;
}                     


#####################################################


sub all_logic {
  my($hm ) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $sd, $x, $h, $pertains);
  my($l, $s, $rc, $url, $ed);
#
# POLL ALL SLAVES, GENERATE CommLost Events
# GET EVENTS from slaves and store in PDM.
#
  CIM->version("1.1");
  $DB::single = 1;
  
 my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

 foreach $h (@$hosts) {
   if ($h->{active} eq "N") {
      Debug->print2(" -> skipping $h->{hostname}, slave not active");
      next;
   }
   my $ip   = $h->{ip};
   my $ipno = $h->{ipno} || $h->{ip};

   if ($ip) {
      my($alive) = Util->ping($ipno) ? "Y":"N";
      my $tran  = Transition->getTransition( {   key => $ip,
                                         code => 'alive',
                                        value => $alive,
                             transition_value => "N",
                                       repeat => '8h',
                                 });
      if ($tran =~ /IN/  || $tran =~ /OUT/) {
          my($et, $desc, $sev, $nws, $avail);
          if ($tran =~ /IN/) {
            $et   = 'agent.CommunicationLostEvent';
            $desc = "Lost Communication with $h->{hostname} at $ipno (using udp ping)";
            $nws  = 'NWS_CommunicationLostEvent';
            $sev  =  Message::SEVERITY_DOWN;
            $avail= 0;

          } else {
            $et   = 'agent.CommunicationEstablishedEvent';
            $nws  = 'NWS_CommunicationEstablishedEvent';
            $desc = "Regained communication with $h->{hostname} at $ipno regained";
            $sev  =  Message::SEVERITY_NORMAL;
            $avail= 1;
          }

          $ev = CIM::Instance->new($nws, [
                  [ EventType       => $et  ],
                  [ EventId         => $pdm->getEventSequence  ],
                  [ Severity        => $sev ],
                  [ Actionable      => ($sev > 0) ],
                  [ Caption         => 'oob' ],
                  [ Description     => $desc ]
                   ]);

          State->saveState('host',  $h->{hostname}, "", 
                            Util->shortHostname($h->{hostname}), $sev, $desc,$avail , $ev);

          $sd = Events->sourceDetector({ event => $ev });
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event      => $ev  ],
                  [ Element    => $sd->[0] ],
                    ]);
          $ed = Message->new( { id   => {},
                            instances => [$ev, @$sd, $pertains ], severity  => $sev });
          $pdm->saveMessage($ed);
      }

      next if ($tran =~ /IN/ || $tran eq "LOST");

      $rc  = Util::Http->readFileDelete($ipno, "SLAVE_DATA", 20);

      if (length($rc) > 2) {
         my(@l) = split(/\n/, $rc); 
         return if ($#l < 0);
         $s = "";
         Debug->print2("Receiving $#l lines from $h->{hostname}");
         for ($x = 0; $x <= $#l; $x++) {
             if (substr($l[$x],0,2) eq "-E") {
                eval {
                    $ed = Message->fromC($s);
                    $pdm->saveMessage($ed, 1) if ($ed);
                };
                Debug->err(HTTP_ERROR => "failed to transfer from slave $@") if ($@);
                $s = "";
             } else {
               $s .= $l[$x] . "\n";
             }
         }
      } else {
         Debug->print2("No data from slave $h->{hostname}");
      }
   }
 }

}


1;
