package Health::Switch2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Switch2.pm,v 1.14 2002/11/01 16:29:27 ccadieux Exp $


use base 'Health';
use NWS::Switch2;
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.14 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Switch2');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_SWITCH2});
  return $self;
}

#####################################################

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  my($name)    = $report->name;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my($log)     = $report->log();
  if (!$wwn) {
     Debug->err(ERROR => "This Switch \"$name\" ($ip) cannot be identified");
     return;
  }

  CIM->version("1.1");
  $DB::single = 1;

  return if ($hm->connectionEvent($wwn, $report, {method => 2} ));
  my($audit); 
  my($freq) = System->get_renv()->{audit_freq} || 7;
  if (!$oreport || ($audit = Timer->isXdays("Audit$wwn", $freq)) eq "YES" ) {
     # new Switch or audit time.
     my($etype) = $audit ? "switch2.AuditEvent" : "switch2.DiscoveryEvent";
     my($title) = $audit ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => $wwn ],
                  [ TargetName  => $id  ],
                  [ SourceIP    => $ip  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title Sun Switch called $id"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::Switch2->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd,  @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
  }
  return if (!$oreport);

  $orep = $oreport->content;
  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  my($PORTS) = $rep->get('port.count');

# check if port state has changed

  my($comp);
  for ($x=0; $x <= $PORTS; $x++) {
     $comp = "port.$x"; # . sprintf("%3.3d", $x);
     $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $comp, $wwn);
  }
#
# check sensors for changes
#
  my($type, $status, $ostatus, $val, $oval);
  for ($x=1; $x <= 10; $x++) {
    next if (!$rep->get("sensor.board.$x.status"));
    $hm->alarm($report, $orep, "SWITCH2", "sensor.board.$x", "status", $id, $id, $wwn, "sensor.board.status");
  }

  my($userlabel)      = $report->value('id.device_userLabel');
  my $loop_count = 10;

  if($userlabel =~ /Switch2/){
     if($PORTS == 8){
        # 2 Gig 8 port switches don't have 2 fans/power supplies. Even though
	# snmp queries indicate so.
        $loop_count = 1;
     }
  }


  foreach my $el ('fan','power-supply') {
    for ($x=1; $x <= $loop_count; $x++) {
      next if (!$rep->get("sensor.$el.$x.status"));
      $hm->alarm($report, $orep, "SWITCH2", "sensor.$el.$x", "status", $id, $id, $wwn, "sensor.$el.status");
    }
  }


  # Check switch up time
  my($olduptime) = $orep->get("system.uptime");
  my($newuptime) = $rep->get("system.uptime");
  if ($olduptime > $newuptime) {

     $hm->alarmEvent( "", $report, $wwn, "Switch uptime decreased on $id from $olduptime to $newuptime", 0, "system_reboot", {severity => 1});
  }



}

  
sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($pdm) = $hm->{pdm};
   my($map) = $pdm->getDeviceStateMap("switch2.availability");

   my $ostate  = $orep->getState("$comp.state");
   my $state   = $rep->getState("$comp.state");
   $state = $ostate if ($state eq '[undefined]');

   my $old     = $map->get("state.$ostate");
   my $new     = $map->get("state.$state");

   return ($ostate, $state, $old, $new );

}


1;

