package Provider::NSCC_Email;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: NSCC_Email.pm,v 1.7 2002/07/31 16:46:33 ccadieux Exp $

use PDM;
use PDM::ConfigFile;
use SAF;
use Carp;
use Message;
use Util;
use System;
use Util::Http;
use strict;

use base 'Provider';
sub revision {'$Revision: 1.7 $'}

sub description {'Email'}
sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::NSCC_Email');
  return $p;
}


sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $info);
  my($renv, $dev, $host,$notifs, $address);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('nscc_email');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    $renv->{'pro.nscc_email.active'} = $q->{active}? "Y":"N";
    $renv->{'pro.nscc_email.timeout'}  = $q->{to};

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->{conf_upd});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  if ($renv->{'pro.nscc_email.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }
  $address= $renv->{'pro.nscc_email.address'};
  $to     = $renv->{'pro.nscc_email.timeout'} || 90;


 my($o) =<<EOF;
$err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=1 cellspacing=0 cellpadding=3 width=90% bgcolor=white>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{label}</td>

<tr><td bgcolor=$main'LIGHT align=right>$G->{active}:</td>
      <td><input type=checkbox name=active $active> $info</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{address}:</td>
      <td><b>nscc_transport\@sun.com

</table>
<b>
EOF
   if (!$deny) {
      $o .= "<input type=submit name=ACTION_update value=$G->{submit_update}>";
   }
   $o .= "</form>";
   return $o;

}


  

sub RUN {
  my($pro, $pdm) = @_;
  my($f, $l, $transmit);
  $DB::single = 1;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $mailer = $renv->{mailer} || "/usr/bin/mail";
  my($acronym) = $renv->{GSV_ACRONYM};

  return if ($renv->{'pro.nscc_email.active'} ne "Y");

  my($address) = $renv->{'pro.nscc_email.address'} || "nscc_transport\@sun.com";

  my($post) = "";
  my(%options, $old);
  my($allresp);

  my($newerr) = 0;
  $allresp = "";
  my $tmp = "/tmp/nscc_email$$";
  open(W, ">$tmp");
  print W "From: $acronym\nSubject: toC\n\n";

  foreach my $ed (@{ $pdm->getMessages}) {
     print W $ed->toC();
  }
  close(W);
  Util->run_command("$mailer $address < $tmp", "mail", 10);
  unlink $tmp;
  
  Debug->print2("EmailProvider done: $newerr new errors.");

}


  
1;
