package Revision::TAPE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun FC-Tape Firmware"}
sub class {"oob.Tape"}
sub type {"tape"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;

  my $rc2 = $class->checkTapeFirmware($Matrix, $InstalledPatches);

  return [@$rc2];
}

sub checkTapeFirmware {
    my($class, $Matrix, $InstalledP) = @_;
    my $tape_fw = $Matrix->{Tape};
    my $category = "FC_TAPE";
    # my $key = "drv";
    my $key;
    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $found =0;
    my $tape_drive = "Tape Drive F/W";
    my $tape_info;
    my $err;
    foreach my $dev (@$devs){
          if ( $dev->{type} =~ /tape/) {
             $found =1;
             my $tape_wwn = $dev->{wwn};
             
             ($err, $tape_info) = $class->getTapeInfo($tape_wwn);
             if ($err) {
                  my $info = $err." Please contact your SUN representative";
                  push(@L, [$category, $tape_wwn,'ERR',undef, undef,undef,undef,$info]);
                  next;
             } else {
                if ( $tape_info->{'pro_id'} =~ /T9840B/ ) {
                    $key = "drv2";
                } elsif ($tape_info->{'pro_id'} =~ /9840/){
                    $key = "drv";
                } elsif ( !$tape_info->{'pro_id'}) {
                    push(@L, [$category, $tape_wwn,'ERR',undef, undef,undef,undef,"Can not get the tape product type, please contact your SUN representative"]); 
                    next;
                }
             }        
             my $d = $tape_fw->{$key};
             my $req_fw = $d->[0];

             my $curr_fw = $tape_info->{'revision'};
             if (!$curr_fw) {
                  push(@L, [$category, $tape_wwn,'ERR',undef, undef,undef,undef,"Can not get the tape firmware revision , please contact your SUN representative"]);
             }
             my $comp;
             if ($curr_fw =~ /^E/){
                  # add character is because luxadm display chop R
                  # for example, it only shows E.28 instead of RE.28
                  $curr_fw ="R".$curr_fw;
                  my ($tem1,$new_curr_fw) = split(/\./,$curr_fw);
                  my ($tem2,$new_req_fw) = split(/\./,$req_fw);
                  $comp = $class->compareFwLevels($new_curr_fw, $new_req_fw);
             } elsif ($curr_fw =~ /1\.28/){
                  $comp =-1;
             }else {
                  $comp = $class->compareFwLevels($curr_fw, $req_fw);
             }
             if ( $comp==0) {
                   push(@L, [$category, $tape_wwn,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp>0) {
                   push(@L, [$category, $tape_wwn,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp<0){
                   push(@L, [$category, $tape_wwn,'DOWNREV',$curr_fw, $req_fw,"N/A","N/A","No patch available, please contact your SUN representative"]);
             }

          }
    }
    if ($found == 0)
    {
            push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No tape device are present, please check system"]);
    }

    return \@L;
}

sub getTapeInfo {
      my ($class, $wwn) = @_;
      my %info;
      my($lux) = System->find_luxadm;
      my ($renv) = System->get_renv();
      my($TO)   = $renv->{'timeout.luxadm'}; 
      if (!$TO) {
        $TO = 300;    # default time out 
      }
      my($err,$com) = Util->run_command("$lux display $wwn 2>&1", "tape.txt" , $TO);
      return ("Error for command ".$lux." display ".$wwn." : ".$err.". ", undef) if ($err);
      foreach my $l (@$com) {
          if ($l =~ /^ *Error:/) {
               return ("",$l, undef);
          }
          my($h1, $h2);
          if ($l =~ /(.*):\s+(.*)/) {
              $h1 = $1; $h2 = $2;
              if ($h1 =~ /Product ID/) {
                    # my $id = $h2;
                    $info{'pro_id'} = $h2;
              }
              if ($h1 =~ /Revision/) {
                    $info{'revision'} = $h2;
              }

          }
      }
    return ("",\%info);
}

1;
