package TO::HOST;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
use strict;

sub leaf { 1 }
sub portLabel {
  my($class, $port) = @_;
  return "hba-$port"
}

sub new {
  my($class, $Topo, $hostname, $info) = @_;
  my($size);
  my($name)  = "host:$hostname";
  my($hosts) = $Topo->[0];
  my $syns   = $Topo->[4];
  my $renv = System->get_renv();
  my $mgmtLevel = $renv->{solution} eq "Y" ? "C" : "D";

  if (!defined($hosts->{$name}) ) {
     my($obj) = {};
     $obj->{info}       = $info;
     $obj->{info}{type} = "Sun";
     $obj->{info}{class} = "host";
     $obj->{info}{hostid}= System->hostid();
     $obj->{info}{ipno}  = Util->name2ip($hostname);
     $obj->{info}{bitMode} = System->bitMode();
     $obj->{info}{model}   = $info->{model} || System->model();
     $obj->{info}{release} = System->os_release();
     $obj->{info}{mgmtLevel} = $mgmtLevel;
     $obj->{info}{name} = $name;
     $obj->{portInfo}   = [];
     $obj->{port}       = [];
     bless($obj, 'TO::HOST');
     $hosts->{$name} = $obj;
     $syns->{$hostname} = $name;
  }
  return $hosts->{$name};
}

sub statusFunc {
  my($class, $name, $State) = @_;

  my $Comp = $State->components();
  my $i   = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($other, $disk, $diskInfo, $otherInfo, $port, $portInfo);
  my $sp  = $Comp->value("$name:sp.ntc");
  my $lun = $Comp->value("$name:lun.status");

  $other     = "$sp->[0],$lun->[0]";
  $otherInfo = "$sp->[1],$lun->[1]";

  my (@P, $x);
  foreach my $k (keys %$Comp) {
     my($t, $key, $c) = split(/\:/, $k);
     if ("$t:$key" eq $name && substr($c,0,3) eq "hba") {
        my $po = substr($c,4) + 0;
        $P[$po] = $Comp->value($k);
     }
  }
  for ($x=0; $x <= $#P; $x++) {
     if ($P[$x]) {
       $port .= $P[$x][0] . ",";
       my $pi = $P[$x][1];
       $pi =~ s/\/devices//;
       $portInfo .= "$pi,";
     } else {
       $port .= ",";
       $portInfo .= ",";
     }
  }
  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}



sub toString {
  my($h) = @_;
  my($x, $out, $hbasI);

  $out = "HOST  : '$h->{info}{name}'\n";

  my($ports) = $h->port();
  my($hbas) = $h->portInfo();
  my($hba, $port);

  for ($x=0; $x <= $#$hbas; $x++) {
     $hba = $hbas->[$x];
     $port = $ports->[$x];
     next if ($hba->{al_pa} == -1);
     $out .= "      HBA-$x: NodeWWN=$hba->{NodeWWN} \n".
             "             Path   =$hba->{path}  \n".
             "             LGroup =$hba->{LGroup} \n".
             "             Mode   =$hba->{path}, al_pa=$hba->{al_pa},\n";
     $out .= "             LINK_TO-> $port \n";
  }
  return $out;
}

sub iconLayout {
  my($ho) = @_;
  my $gif = $ho->getGif();
  return "E0E0E0/$gif,OL,Other/Luns" ; 
}


sub diagramApplet {
  my($class, $name, $Comp, $to) = @_;

  my $node = $to->nodeByName($name);

  my $ports = $node->portInfo();

  my $o = "<table border=1 cellspacing=0 width=100% bgcolor=#303030>
  <tr><td>";
  
  

}



sub getGif {
  my($h) = @_;
  my $info = $h->{info};
  my $model = $info->{model};
  if ($model =~ /UltraAX-i2/ || $model =~ /Netra/) {
    return "netraX1.gif";
  } elsif ($model =~ /Enterprise/) {
    return "e45.gif";
  } elsif ($model =~ /Ultra/) {
    return "ultra.gif";
  }
  return "host2.gif";
}

sub type { "host"}

sub hostid {
  my($obj) = @_;
  return $obj->{info}{hostid};
}


sub boxName {
  my($obj) = @_;
  return $obj->key();
}

sub id {
  my($obj) = @_;

  my(@xx) = split(/:/, $obj->{info}{name});
  return "host '$xx[1]'";
}


sub getPortId {
  my($class, $port) = @_;   # 0 , 1 ...

  return "hba.$port";
}

1;
