package TO::MCDATA;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2002, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Agent::MCDATA;
use strict;
use TO;
use TO::FCSWITCH;
use base 'TO::FCSWITCH';
sub leaf { 1 }

sub type {"mcdata"}

sub getDevStatus {
  my($class, $dev) = @_;
  return Agent::MCDATA->getDevStatus($dev);
}

sub getLocalPortWWN {
  my($class, $V, $dev, $x) = @_;
  return $V->{"port.$x.stats.Wwn"};
}

sub getZones {
   my($class, $dev, $ZO) = @_;
   my $ip = $dev->{ipno};
   my $err = Agent::MCDATA->getZones(System->get_home() . "/snmp", $ip, $ZO , $dev);
}

sub extraPortInfo {
  my($class, $portno, $V) = @_;
  my $extra = { blade => $V->{"port.$portno.blade"}, 
           blade_port => $V->{"port.$portno.blade_port"}
              };
  return $extra;
}



sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp = $State->components();
  my $i = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo, @f1, @p1, $x);

  for ($x=1; $x <= 6; $x++) {
    push(@f1, $Comp->value("$name:sensor.fan.$x"));
  }
  for ($x=1; $x <= 2; $x++) {
    push(@p1, $Comp->value("$name:sensor.powerSupply.$x"));
  }
  my ($other, $otherInfo) = TO->valArray(\@f1, \@p1);

  my($port, $portInfo);
  my $nodePorts = $node->portInfo(); 
  my $cnt = $node->info("portCount");
  for ($x=0; $x < $cnt; $x++) {
     if ($nodePorts->[$x]{type} eq "notPresent") {
         $port .= ",";
         $portInfo .= ",";
     } else {
       my $blade;
       $blade = "[Slot:". $nodePorts->[$x]{blade} . " Port:" . 
                      $nodePorts->[$x]{blade_port} . "] "
                       if ( defined($nodePorts->[$x]{blade}) );

       $port     .= $Comp->value("$name:port.$x",0) . ",";
       $portInfo .= $blade  . $Comp->value("$name:port.$x",1) . ",";
     }
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}

sub iconLayout {
  my($sw, $orient) = @_;
  return "F0D8D8/switch2.gif,FP,Fan/Power,$orient" ; # ,h = horiz switch
}



1;
