package TO::PARENTSWITCH;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
use strict;
use TO;
use Agent::SWITCH;

sub leaf { 0 }


sub portType {
  my($class, $dinfo) = @_;

  my($p) =  $dinfo->{RegisterName};
  my($p2)=  $dinfo->{sw_PortType};

  if ($p2 eq "E_Port") {
     return "e";
  } elsif ($p2 eq "FL_Port") {
     return "ip";
  } elsif ($p2 eq "TL_Port") {
     return "dp";
  }
  my(@a) = split(/[\-\(\_]/, $p);
  return $a[3];
}


sub dport   { 
    my($h) = @_; return $h->{dport} }


sub iPort {
  my($sw, $port) = @_;
  my ($x,$d);
  my $dp = $sw->{dport}; # internal links
  for ($x=1; $x <= $#$dp; $x++) {
     $d = $dp->[$x];
     if (index("-$d", "-$port-") >= 0) {
         return $x;
     }
  }
  return undef;


}

sub toString {
  my($s) = @_;
  my($x);

  my($out) = "SWITCH: '$s->{info}{name}' ip=$s->{info}{ip}, ipName=$s->{info}{ipName}\n";

  my($ports)  = $s->port();
  my($portsI) = $s->portInfo();

  for ($x=1; $x <= $#$ports; $x++) {
     my($p) = $portsI->[$x];
     my($pi) = $ports->[$x];
     next if (!$p);
     $out .= "      PORT-$x: sw_PortNum=$p->{sw_PortNum}, NodeWWN=$p->{NodeWWN} \n";
     $out .= "              LINK_TO-> $pi \n";
  }
  return $out;
}

sub type { "UNDEFINED"};


sub isCascaded {
  my($obj) = @_;
  return ($obj->{info}{sw_remote_fcaddr} ne "0x0");
}

sub boxName {
  my($obj) = @_;

  if ( $obj->{info}{sw_ipAddr}) {
     return $obj->{info}{sw_ipAddr};

  } else {
     return substr($obj->{info}{name},7);
  }
}

sub id {
  my($obj) = @_;

  my($id) = $obj->type() . " '";
  if (lc($obj->{info}{sw_ipName}) !~ /unknown/){
    $id .= ($obj->{info}{sw_ipName} || $obj->{info}{BoxName})  . "/";
  }
  $id .= $obj->{info}{sw_ipAddr} if ($obj->{info}{sw_ipAddr});
  $id .= "'";

  return $id;
}

sub getPortLink {
  my($sw, $port) = @_;

  my $p = $sw->port();
  return undef if (!$p);
  return $p->[$port];
}


sub ip {
  my($sw) = @_;
  my $i = $sw->{info};
  if ($i->{sw_ipAddr_remote} &&
        $i->{sw_ipAddr_remote} ne $i->{sw_ipAddr}) {
     return "-f " . substr($i->{sw_remote_fcaddr},2) . " " .
            $i->{sw_ipAddr_remote};
  } else {
     return $i->{sw_ipAddr};
  }
}

sub ipAddr {
  my($sw) = @_;
  my $i = $sw->{info};
  return $i->{sw_ipAddr};
}

sub getPortId {
  my($class, $port) = @_;  # 1 , 2 ...

  return "port.$port";
}



1;


