package TO::TAPE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
use State;

sub leaf { 1 }
sub getPortId {
  my($class, $port) = @_;    # 0 / 1

  if ($port == 0) {
     return 'port.A';
  } else {
     return 'port.B';
  }
}

sub statusFunc {
  my($class, $name, $State) = @_;
  my($type);
  my $Comp = $State->components();
  my $i    = $Comp->value("$name:ib");
  my $enc  = $i->[0];
  my $encInfo = $i->[1];

  my($port, $portInfo, $other, $otherInfo);
  my($disk, $diskInfo);

  ($type, $name) = split(/:/, $name);
  $name = "tape:$name";

  my($p1)   = $Comp->value("$name:port.A");
  $port     = $p1->[0];
  $portInfo =  $p1->[1];

  return ($enc, $port, $disk, $other, $encInfo, $portInfo, $diskInfo, $otherInfo);
}


sub iconLayout {
  my($class) = @_;

  return("a,tape,1/A,0,f,,,D0F0D0/tape.gif", "TAPE", 1);
}


1;


