package TO::V880DISK;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
use State;

sub leaf { 1 }
sub portLabel {
   my($class, $port) = @_;

   return ($port==1)? "ses-B":"ses-A";
}
  

#
# used to look in the State db
#
sub getPortId {
  my($class, $port) = @_;    # 0 / 1
  if ($port == 0) {
     return 'interface_board.A';
  } else {
     return 'interface_board.B';
  }
}

sub getDiskList {
  my($node) = @_;
  my (@L, $x, $y);
  $x = 'disk';
  for ($y=0; $y <= 10; $y++) {
     push(@L, "$x.$y");
  }
  return \@L;
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;
  my($type, $port, $portInfo, $other, $otherInfo);
  my $Comp = $State->components();

  my $i = $Comp->value("$name:ib");
  my $enc = $i->[0];
  my $encInfo = $i->[1];


  my $p1 = $Comp->value("$name:SSC.base_loopB",0) ;
  my $p2 = $Comp->value("$name:SSC.exp_loopB",0);
  $other = TO->val($p1, $p2);
  $other .= ",";

  my $p1 = $Comp->value("$name:SSC.base_backplane",0) ;
  my $p2 = $Comp->value("$name:SSC.exp_backplane",0);
  $other .= TO->val($p1, $p2);
  $other .= ",";

  my $p1 = $Comp->value("$name:temperature.base",0) ;
  my $p2 = $Comp->value("$name:temperature.expansion",0);
  $other .= TO->val($p1, $p2);

  $otherInfo =  ($Comp->value("$name:SSC.base_loopB",1) ||
               $Comp->value("$name:SSC.exp_loopB",1)) . "," . 

              ($Comp->value("$name:SSC.base_backplane",1) ||
               $Comp->value("$name:SSC.exp_backplane",1) )  . "," . 

              ($Comp->value("$name:temperature.base",1) ||
               $Comp->value("$name:temperature.expansion",1) ) ;


  my($disk, $diskInfo);
  my ($map, @MAP);
  if ($node->{info}{disk_map}) {
     $map =1;
     @MAP = split(/,/, $node->{info}{disk_map});
  }
  my $o1 = 0;
  my($d);
  for ($d=0; $d <= 12; $d++) {
      if ($map && ($MAP[$d+$o1] == -1)) {
        $disk .= "-1,";
      } else {
        $disk .= $Comp->value("$name:disk.$d",0) . ",";
      }
      $diskInfo .= $Comp->value("$name:disk.$d",1) . ",";
  }

 return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}


sub iconLayout {
  my($class) = @_;

  return("a,V880DISK,2/AB,12,f,LBT,Loop/BackPlane/Temperature,E0F0F0/a5k.gif", "V880DISK", 2);
}


1;


