package TO::VE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
use strict;
use TO;
sub leaf { 1 }

sub newFromDev {
  my($class, $Topo, $host, $dev, $mode) = @_;
  my($x);
  my $name = "ve:$dev->{wwn}";
  my $new = 0;

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];
  my $renv      = System->get_renv();
  my $P = $renv->{solution_prefix} || "XX";

  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name}    = $name;
     $obj->{info}{type}    = "ve";
     $obj->{info}{BoxName} = $dev->{name};
     $obj->{info}{mgmtLevel} = $dev->{mgmtLevel} || "D";
     $obj->{info}{class}   = "switch.ve";
     $obj->{info}{sw_WWN}  = $dev->{wwn};
     if (substr($dev->{ipno},0,length($P)) eq $P && $dev->{host}) {
       $obj->{info}{proxy}   = $dev->{host};
     }
     $obj->{info}{sw_ipAddr} = $dev->{ipno};

     $obj->{port} = [];

     my $wwn1 = "2b" . substr($dev->{wwn},2);
     my $wwn2 = "29" . substr($dev->{wwn},2);

     $obj->{portInfo}[1] = { PortWWN => $wwn1, LocalPortWWN => $wwn1 };
     $obj->{portInfo}[2] = { PortWWN => $wwn2, LocalPortWWN => $wwn2 };
     $obj->{zones}{'hd'}[0] = "1 2";

     $obj->{info}{ProductID} = "VE";
     $obj->{info}{host} = $host;
     $obj->{info}{host_type} = $mode || "oob";

     bless($obj, 'TO::VE');
     $syns->{$dev->{wwn}} = $name;
     $syns->{$wwn1} = "$name:1";
     $syns->{$wwn2} = "$name:2";
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name});
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne "ve");
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     next if ($topo->nodeByName($k));
     $dev->{host} = $renv->{hostname} if (!$dev->{host});

     $class->newFromDev($topo, $renv->{hostname}, $dev);
  }
}

sub iconLayout {
  my($sw) = @_;
  return "F0D0F0/ve.gif,MV,MultiPath/VLUN";
}



sub statusFunc {
  my($class, $name, $State) = @_;

  my $Comp = $State->components();
  my $i = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo);

  my $other =  $Comp->value("$name:multipath.status",0) . "," .
               $Comp->value("$name:vlun.status",0);

  my $otherInfo =  $Comp->value("$name:multipath.status",1) . "," .
               $Comp->value("$name:vlun.status",1);


  my($x, $port, $portInfo);

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
}

sub type { "ve"};

sub revision {
  my $sw = @_;
  my $vol = $sw->volInfo();
  if ($vol) {
     foreach my $k (keys %$vol) {
         return $vol->{$k}{Revision};
     }
  }
  return undef;

}


sub ipAddr {
  my($sw) = @_;
  my $i = $sw->{info};
  return $i->{sw_ipAddr};
}


sub id {
  my($obj) = @_;

  return "ve '" . $obj->boxName() . "/" . $obj->key() . "'";
}

sub isCascaded { 0 }

sub getPortId {
  my($class, $port) = @_;  # 1 , 2 ...

  return "port.$port";
}

sub getLogicalPaths{
  my($self) = @_;
  my $volinfo =$self->volInfo();
  my @paths;
  foreach my $path (keys %$volinfo){
    push(@paths, $path);
  }
  return @paths;
}

1;


