package TO::Zone;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;

sub leaf { 1 }

sub name {
  my($z) = @_;
  return $z->{name};
}

sub type {
  my($z) = @_;
  return $z->{type};
}

sub members {
  my($z) = @_;
  return $z->{members};
}

# find all nodes attached to a zone
# $l = $z->getNodes($to);
# returns a list of "type:key"
# set withPorts to get ports ("type:key:type")

sub getNodes {
  my($z, $to , $withPorts ) = @_;
  my(@R, %RR);
  my($head, $no, $t) = split(/\:/, $z->{name});  # zone:1:hd1
  my $zt = substr($t,0,2);
  my $zno = substr($t,2) + 0;
  my $l = $z->{members};
  return if (!$l);
  foreach my $swName (@$l) {  # find nodes on that sw;
     my $sw = $to->nodeByName($swName);
     next if (!$sw);
     if (exists($sw->{zones}{$zt})) {
        my $ports = $sw->port();
        my $members = $sw->{zones}{$zt}[$zno];
        my @L = split(/ /, $members);
        foreach my $m (@L) {
            my $p = $ports->[$m];
            if ($p) {
               if ( !$withPorts ) {
                 my $ix = rindex($p,":");
                 $RR{substr($p,0,$ix)} = 1;
               } else {
                 push(@R, $ports->[$m]);
               }
            }
        }
     }
  }
  if ( !$withPorts ) {
    @R = ();
    @R = keys %RR;
  }
  return \@R;
}



1;
