/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.Timer;
import java.util.StringTokenizer;
import java.util.Vector;

public class AttachmentPoint
extends Logger {
    protected String m_LogicalID;
    protected int m_Busy;
    protected String m_ClassName;
    protected int m_Condition;
    protected int m_DomainID;
    protected String m_MiscInfo;
    protected int m_OccupantState;
    protected String m_PhysicalID;
    protected int m_ReceptacleState;
    protected String m_StatusTime;
    protected String m_Type;
    protected String m_UserName;
    protected static final int ALLDOMAINS = -1;

    public AttachmentPoint() {
        Logger.logDebug("AttachmentPoint constructor");
        this.m_LogicalID = "";
        this.m_DomainID = 0;
    }

    public AttachmentPoint(AttachmentPoint ap) {
        Logger.logDebug("AttachmentPoint copy constructor");
        this.m_LogicalID = ap.m_LogicalID;
        this.m_DomainID = ap.m_DomainID;
        this.m_Busy = ap.m_Busy;
        this.m_ClassName = ap.m_ClassName;
        this.m_Condition = ap.m_Condition;
        this.m_MiscInfo = ap.m_MiscInfo;
        this.m_OccupantState = ap.m_OccupantState;
        this.m_PhysicalID = ap.m_PhysicalID;
        this.m_ReceptacleState = ap.m_ReceptacleState;
        this.m_StatusTime = ap.m_StatusTime;
        this.m_Type = ap.m_Type;
        this.m_UserName = ap.m_UserName;
    }

    public AttachmentPoint(String userName) {
        this();
        this.m_UserName = userName;
    }

    protected Integer changeState(int targetState, Vector inParams, Vector outParams) {
        int expectedParamCnt = 4;
        int status = 12;
        Boolean force = null;
        String hardwareOptions = null;
        Integer retries = null;
        Integer retryDelaySecs = null;
        Logger.logDebug("changeState");
        if (inParams.size() != 4) {
            Logger.logErr("changeState called with the wrong number of arguments in inParams Vector");
        } else {
            StringBuffer error = new StringBuffer();
            int i = 0;
            while (i < inParams.size()) {
                Object obj = ((CIMValue)inParams.elementAt(i)).getValue();
                switch (i) {
                    case 0: {
                        force = (Boolean)obj;
                        break;
                    }
                    case 1: {
                        hardwareOptions = (String)obj;
                        break;
                    }
                    case 2: {
                        retries = (Integer)obj;
                        break;
                    }
                    case 3: {
                        retryDelaySecs = (Integer)obj;
                        break;
                    }
                }
                ++i;
            }
            status = this.changeState(targetState, force, hardwareOptions, retries, retryDelaySecs, error);
            outParams.add(new CIMValue((Object)error.toString()));
        }
        return new Integer(status);
    }

    protected int changeState(int targetState, boolean force, String hardwareOptions, int retries, int retryDelaySecs, StringBuffer error) {
        Timer nTimer = new Timer("AttachmentPoint.n_changeState");
        nTimer.start();
        int status = this.n_changeState(this.m_LogicalID, this.m_DomainID, this.m_UserName, targetState, force, hardwareOptions, retries, retryDelaySecs, error);
        nTimer.stop();
        nTimer.logInterval();
        return status;
    }

    public Integer configure(Vector inParams, Vector outParams) {
        Logger.logDebug("configure");
        return this.changeState(5, inParams, outParams);
    }

    public Integer connect(Vector inParams, Vector outParams) {
        return this.changeState(3, inParams, outParams);
    }

    public Integer disconnect(Vector inParams, Vector outParams) {
        return this.changeState(4, inParams, outParams);
    }

    public int getBusy() {
        return this.m_Busy;
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public int getCondition() {
        return this.m_Condition;
    }

    public int getDomainID() {
        return this.m_DomainID;
    }

    public String getLogicalID() {
        return this.m_LogicalID;
    }

    public String getMiscInfo() {
        return this.m_MiscInfo;
    }

    protected Vector getMiscInfoPairs() {
        Vector<String> nameValueVector = new Vector<String>();
        StringTokenizer stmtTokenizer = new StringTokenizer(this.getMiscInfo());
        while (stmtTokenizer.hasMoreTokens()) {
            String stmt = stmtTokenizer.nextToken();
            if (stmt.indexOf(61) == -1) {
                nameValueVector.add(stmt);
                continue;
            }
            StringTokenizer partTokenizer = new StringTokenizer(stmt, "=");
            while (partTokenizer.hasMoreTokens()) {
                nameValueVector.add(partTokenizer.nextToken());
                nameValueVector.add(AttachmentPoint.stripQuotes(partTokenizer.nextToken()));
            }
        }
        return nameValueVector;
    }

    public int getOccupantState() {
        return this.m_OccupantState;
    }

    public String getPhysicalID() {
        return this.m_PhysicalID;
    }

    public int getReceptacleState() {
        return this.m_ReceptacleState;
    }

    public boolean getResource(String hardwareOptions, StringBuffer error) {
        Timer nTimer = new Timer("AttachmentPoint.n_getResource");
        nTimer.start();
        boolean result = this.n_getResource(this.m_LogicalID, this.m_DomainID, this.m_UserName, hardwareOptions, error);
        nTimer.stop();
        nTimer.logInterval();
        return result;
    }

    public Vector getResources(int domainID, String hardwareOptions, String listOptions, StringBuffer error) {
        return this.n_getResources(domainID, this.m_UserName, hardwareOptions, listOptions, error);
    }

    public String getStatusTime() {
        return this.m_StatusTime;
    }

    public String getType() {
        return this.m_Type;
    }

    protected Integer hardwareFunc(int function, Vector inParams, Vector outParams) {
        int expectedParamCnt = 2;
        int status = 12;
        Boolean force = null;
        String hardwareOptions = null;
        if (inParams.size() != 2) {
            Logger.logErr("hardwareFunc called with the wrong number of arguments");
        } else {
            int i = 0;
            while (i < inParams.size()) {
                Object obj = ((CIMValue)inParams.elementAt(i)).getValue();
                switch (i) {
                    case 0: {
                        force = (Boolean)obj;
                        break;
                    }
                    case 1: {
                        hardwareOptions = (String)obj;
                        break;
                    }
                }
                ++i;
            }
            StringBuffer error = new StringBuffer();
            status = this.hardwareFunc(function, force, hardwareOptions, error);
            outParams.add(new CIMValue((Object)error.toString()));
        }
        return new Integer(status);
    }

    public int hardwareFunc(int function, boolean force, String hardwareOptions, StringBuffer error) {
        Timer nTimer = new Timer("AttachmentPoint.n_hardwareFunc");
        nTimer.start();
        int result = this.n_hardwareFunc(this.m_LogicalID, this.m_DomainID, this.m_UserName, function, force, hardwareOptions, error);
        nTimer.stop();
        nTimer.logInterval();
        return result;
    }

    public static native boolean isValidDomainID(int var0);

    protected static native boolean isValidLogicalID(String var0);

    protected native int n_changeState(String var1, int var2, String var3, int var4, boolean var5, String var6, int var7, int var8, StringBuffer var9);

    protected native boolean n_getResource(String var1, int var2, String var3, String var4, StringBuffer var5);

    protected native Vector n_getResources(int var1, String var2, String var3, String var4, StringBuffer var5);

    protected native int n_hardwareFunc(String var1, int var2, String var3, int var4, boolean var5, String var6, StringBuffer var7);

    protected native int n_test(String var1, int var2, String var3, boolean var4, String var5, StringBuffer var6);

    public void populateSubclassMembers() {
    }

    public void setBusy(int busy) {
        this.m_Busy = busy;
    }

    public void setClassName(String cls) {
        this.m_ClassName = cls;
    }

    public void setCondition(int condition) {
        this.m_Condition = condition;
    }

    public void setDomainID(int domainID) {
        this.m_DomainID = domainID;
    }

    public void setLogicalID(String logicalID) {
        this.m_LogicalID = logicalID;
    }

    public void setMiscInfo(String miscInfo) {
        this.m_MiscInfo = miscInfo;
    }

    public void setOccupantState(int state) {
        this.m_OccupantState = state;
    }

    public void setPhysicalID(String physicalID) {
        this.m_PhysicalID = physicalID;
    }

    public void setReceptacleState(int state) {
        this.m_ReceptacleState = state;
    }

    public void setStatusTime(String statusTime) {
        this.m_StatusTime = statusTime;
    }

    public void setType(String type) {
        this.m_Type = type;
    }

    private static String stripQuotes(String s) {
        s.trim();
        String strippedString = s.startsWith("\"") ? s.substring(1, s.length() - 1) : s;
        return strippedString;
    }

    public Integer test(Vector inParams, Vector outParams) {
        int expectedParamCnt = 2;
        int status = 12;
        Boolean verbose = null;
        String hardwareOptions = null;
        if (inParams.size() != 2) {
            Logger.logErr("test called with the wrong number of arguments");
        } else {
            int i = 0;
            while (i < inParams.size()) {
                Object obj = ((CIMValue)inParams.elementAt(i)).getValue();
                switch (i) {
                    case 0: {
                        verbose = (Boolean)obj;
                        break;
                    }
                    case 1: {
                        hardwareOptions = (String)obj;
                        break;
                    }
                }
                ++i;
            }
            StringBuffer error = new StringBuffer();
            status = this.test(verbose, hardwareOptions, error);
            outParams.add(new CIMValue((Object)error.toString()));
        }
        return new Integer(status);
    }

    protected int test(boolean verbose, String hardwareOptions, StringBuffer error) {
        Timer nTimer = new Timer("AttachmentPoint.n_test");
        nTimer.start();
        int result = this.n_test(this.m_LogicalID, this.m_DomainID, this.m_UserName, verbose, hardwareOptions, error);
        nTimer.stop();
        nTimer.logInterval();
        return result;
    }

    public String toString() {
        String str = "\nAttachment Point:\n-----------------\nLogicalID - " + this.m_LogicalID + "\n" + "DomainID - " + this.m_DomainID + "\n" + "Type - " + this.m_Type + "\n" + "ReceptacleState - " + this.m_ReceptacleState + "\n" + "OccupantState - " + this.m_OccupantState + "\n" + "Condition - " + this.m_Condition + "\n" + "StatusTime - " + this.m_StatusTime + "\n" + "Busy - " + this.m_Busy + "\n" + "PhysicalID - " + this.m_PhysicalID + "\n" + "ClassName - " + this.m_ClassName + "\n" + "MiscInfo - " + this.m_MiscInfo + "\n";
        return str;
    }

    public Integer unconfigure(Vector inParams, Vector outParams) {
        return this.changeState(6, inParams, outParams);
    }

    public static void validateDomainID(int domainID) throws CIMException {
        if (!AttachmentPoint.isValidDomainID(domainID)) {
            Logger.logErr("specified an invalid domain ID: " + domainID);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)new Integer(domainID));
        }
    }
}

