/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.ResourceProvider;
import com.sun.wbem.wdr.Timer;
import com.sun.wbem.wdr.UserPermission;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class AttachmentPointProvider
extends ResourceProvider {
    protected String m_ProviderClass = this.getClass().getName();

    public AttachmentPointProvider() {
        Logger.logDebug(String.valueOf(this.m_ProviderClass) + " constructor");
    }

    private void copyKeys(CIMObjectPath op, AttachmentPoint ap) {
        CIMProperty property = (CIMProperty)op.getKeys().elementAt(0);
        CIMValue value = property.getValue();
        String apID = (String)value.getValue();
        property = (CIMProperty)op.getKeys().elementAt(1);
        value = property.getValue();
        Logger.logDebug(String.valueOf(this.m_ProviderClass) + ".copyKeys: domainIDVal is of type " + value.getType());
        UnsignedInt32 domainID = (UnsignedInt32)value.getValue();
        Logger.logDebug(String.valueOf(this.m_ProviderClass) + ".copyKeys: after cast");
        ap.setLogicalID(apID);
        ap.setDomainID(domainID.intValue());
    }

    protected AttachmentPoint createAttachmentPoint() {
        return new AttachmentPoint(this.m_Provider.getCurrentUser());
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc) throws CIMException {
        Timer pTimer = new Timer("AttachmentPointProvider.enumInstances (names)");
        pTimer.start();
        Logger.logDebug("enumInstances called with out localOnly");
        Logger.logDebug("Object - " + op);
        Logger.logDebug("Deep - " + deep);
        Vector<CIMObjectPath> copVector = null;
        Vector resVector = null;
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            String hwOptions = "parsable";
            String listOptions = "class=sbd";
            StringBuffer error = new StringBuffer();
            AttachmentPoint attachPoint = this.createAttachmentPoint();
            if (!UserPermission.mayListAllAttachPoints(this.m_Provider.getCurrentUser())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissonToListAttachmentPoints", new Object[]{this.m_Provider.getCurrentUser()}));
            }
            Timer nTimer = new Timer("native AttachmentPoint.getResources");
            nTimer.start();
            resVector = attachPoint.getResources(-1, "parsable", "class=sbd", error);
            nTimer.stop();
            nTimer.logInterval();
            if (resVector == null) {
                if (error.length() == 0) {
                    Logger.logErr("getResources failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResources failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            Logger.logDebug("Number of AttachmentPoints - " + resVector.size());
            Iterator resIter = ((AbstractList)resVector).iterator();
            AttachmentPoint ap = null;
            copVector = new Vector<CIMObjectPath>(resVector.size());
            while (resIter.hasNext()) {
                ap = (AttachmentPoint)resIter.next();
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey("LogicalID", new CIMValue((Object)ap.getLogicalID()));
                cop.addKey("DomainID", new CIMValue((Object)new UnsignedInt32((long)ap.getDomainID())));
                copVector.add(cop);
            }
            Logger.logDebug("Number of attachment points - " + copVector.size());
        }
        pTimer.stop();
        pTimer.logInterval();
        return copVector;
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc, boolean localOnly) throws CIMException {
        Timer pTimer = new Timer("AttachmentPointProvider.enumInstances");
        pTimer.start();
        Logger.logDebug("enumInstances called with localOnly");
        Logger.logDebug("Object - " + op);
        Logger.logDebug("Deep - " + deep);
        Vector<CIMInstance> instVector = null;
        Vector resVector = null;
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            String hwOptions = "parsable";
            String listOptions = "class=sbd";
            StringBuffer error = new StringBuffer();
            AttachmentPoint attachPoint = this.createAttachmentPoint();
            if (!UserPermission.mayListAllAttachPoints(this.m_Provider.getCurrentUser())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissonToListAttachmentPoints", new Object[]{this.m_Provider.getCurrentUser()}));
            }
            Timer nTimer = new Timer("native AttachmentPoint.getResources");
            nTimer.start();
            resVector = attachPoint.getResources(-1, "parsable", "class=sbd", error);
            nTimer.stop();
            nTimer.logInterval();
            if (resVector == null) {
                if (error.length() == 0) {
                    Logger.logErr("getResources failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResources failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            Logger.logDebug("Number of points - " + resVector.size());
            Iterator resIter = ((AbstractList)resVector).iterator();
            AttachmentPoint ap = null;
            CIMInstance inst = null;
            instVector = new Vector<CIMInstance>(resVector.size());
            while (resIter.hasNext()) {
                ap = (AttachmentPoint)resIter.next();
                inst = cc.newInstance();
                this.updateInstance(inst, ap);
                if (localOnly) {
                    inst = inst.localElements();
                }
                instVector.add(inst);
            }
            Logger.logDebug("Number of attachment points - " + instVector.size());
        }
        pTimer.stop();
        pTimer.logInterval();
        return instVector;
    }

    public Vector enumInstancesByDomain(int domainID, CIMClass cc, boolean localOnly) throws CIMException {
        Logger.logDebug("enumInstancesByDomain called");
        Logger.logDebug("domainID - " + domainID);
        Vector<CIMInstance> instVector = null;
        Vector resVector = null;
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            String hwOptions = "parsable";
            String listOptions = "class=sbd";
            StringBuffer error = new StringBuffer();
            AttachmentPoint attachPoint = this.createAttachmentPoint();
            if (!UserPermission.mayListAttachPoints(this.m_Provider.getCurrentUser(), domainID)) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissonToListAttachmentPoints", new Object[]{this.m_Provider.getCurrentUser()}));
            }
            resVector = attachPoint.getResources(domainID, "parsable", "class=sbd", error);
            if (resVector == null) {
                if (error.length() == 0) {
                    Logger.logErr("getResourcesByDomain failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResourcesByDomain failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            Logger.logDebug("Number of points - " + resVector.size());
            Iterator resIter = ((AbstractList)resVector).iterator();
            AttachmentPoint ap = null;
            CIMInstance inst = null;
            instVector = new Vector<CIMInstance>(resVector.size());
            while (resIter.hasNext()) {
                ap = (AttachmentPoint)resIter.next();
                inst = cc.newInstance();
                this.updateInstance(inst, ap);
                if (localOnly) {
                    inst = inst.localElements();
                }
                instVector.add(inst);
            }
            Logger.logDebug("Number of attachment points - " + instVector.size());
        }
        return instVector;
    }

    public CIMInstance getInstance(CIMObjectPath op, CIMClass cc, boolean localOnly) throws CIMException {
        Timer pTimer = new Timer("AttachmentPointProvider.getInstance");
        pTimer.start();
        CIMInstance inst = null;
        Logger.logDebug("AttachmentPointProvider.getInstance called");
        Logger.logDebug("Object - " + op);
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            String hwOptions = "parsable";
            StringBuffer error = new StringBuffer();
            AttachmentPointProvider.validateAttachmentPointName(op);
            AttachmentPoint attachPoint = this.createAttachmentPoint();
            this.copyKeys(op, attachPoint);
            if (!UserPermission.mayListAttachPoints(this.m_Provider.getCurrentUser(), attachPoint.getDomainID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToGetAttachmentPoint", new Object[]{this.m_Provider.getCurrentUser(), attachPoint.getLogicalID()}));
            }
            if (!attachPoint.getResource("parsable", error)) {
                if (error.length() == 0) {
                    Logger.logErr("getResource failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResource failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            attachPoint.populateSubclassMembers();
            Logger.logDebug("AttachmentPoint - " + attachPoint.toString());
            inst = cc.newInstance();
            this.updateInstance(inst, attachPoint);
            if (localOnly) {
                inst = inst.localElements();
            }
            Logger.logDebug("Current inst - " + inst);
        }
        pTimer.stop();
        pTimer.logInterval();
        return inst;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        Timer pTimer = new Timer("AttachmentPointProvider.invokeMethod" + methodName);
        pTimer.start();
        Logger.logDebug("AttachmentPointProvider.invokeMethod called");
        Logger.logDebug("ObjectPath - " + op);
        Logger.logDebug("methodName - " + methodName);
        Integer status = new Integer(12);
        AttachmentPointProvider.validateAttachmentPointName(op);
        AttachmentPoint attachPoint = this.createAttachmentPoint();
        this.copyKeys(op, attachPoint);
        status = methodName.equalsIgnoreCase("Configure") && this.mayChangeState(attachPoint, methodName) ? attachPoint.configure(inParams, outParams) : (methodName.equalsIgnoreCase("Connect") && this.mayChangeState(attachPoint, methodName) ? attachPoint.connect(inParams, outParams) : (methodName.equalsIgnoreCase("Disconnect") && this.mayChangeState(attachPoint, methodName) ? attachPoint.disconnect(inParams, outParams) : (methodName.equalsIgnoreCase("Test") && this.mayChangeState(attachPoint, methodName) ? attachPoint.test(inParams, outParams) : (methodName.equalsIgnoreCase("Unconfigure") && this.mayChangeState(attachPoint, methodName) ? attachPoint.unconfigure(inParams, outParams) : this.invokeSubclassMethod(attachPoint, methodName, inParams, outParams)))));
        CIMValue retValue = new CIMValue((Object)status);
        pTimer.stop();
        pTimer.logInterval();
        return retValue;
    }

    protected Integer invokeSubclassMethod(AttachmentPoint attachPoint, String methodName, Vector inParams, Vector outParams) throws CIMException {
        return new Integer(3);
    }

    protected static boolean isValidAttachmentPointName(CIMObjectPath op) {
        CIMProperty property = (CIMProperty)op.getKeys().elementAt(0);
        CIMValue value = property.getValue();
        String logID = (String)value.getValue();
        property = (CIMProperty)op.getKeys().elementAt(1);
        value = property.getValue();
        int domainID = ((UnsignedInt32)value.getValue()).intValue();
        return AttachmentPoint.isValidDomainID(domainID) && AttachmentPoint.isValidLogicalID(logID);
    }

    protected boolean mayChangeState(AttachmentPoint attachPoint, String methodName) throws CIMException {
        if (!UserPermission.mayChangeAttachPointState(this.m_Provider.getCurrentUser(), attachPoint.getDomainID(), attachPoint.getLogicalID())) {
            throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToChangeState", new Object[]{this.m_Provider.getCurrentUser(), methodName, attachPoint.getLogicalID()}));
        }
        return true;
    }

    protected void updateInstance(CIMInstance inst, AttachmentPoint ap) {
        Logger.logDebug("AttachmentPoint.updateInstance");
        inst.setProperty("LogicalID", new CIMValue((Object)ap.getLogicalID()));
        inst.setProperty("DomainID", new CIMValue((Object)new UnsignedInt32((long)ap.getDomainID())));
        inst.setProperty("Busy", new CIMValue((Object)new UnsignedInt32((long)ap.getBusy())));
        inst.setProperty("ClassName", new CIMValue((Object)ap.getClassName()));
        inst.setProperty("Condition", new CIMValue((Object)new UnsignedInt32((long)ap.getCondition())));
        inst.setProperty("MiscInfo", new CIMValue((Object)ap.getMiscInfo()));
        inst.setProperty("OccupantState", new CIMValue((Object)new UnsignedInt32((long)ap.getOccupantState())));
        inst.setProperty("PhysicalID", new CIMValue((Object)ap.getPhysicalID()));
        inst.setProperty("ReceptacleState", new CIMValue((Object)new UnsignedInt32((long)ap.getReceptacleState())));
        inst.setProperty("StatusTime", new CIMValue((Object)ap.getStatusTime()));
        inst.setProperty("Type", new CIMValue((Object)ap.getType()));
        this.updateLocalProps(inst, ap);
    }

    protected void updateLocalProps(CIMInstance inst, AttachmentPoint ap) {
    }

    public static void validateAttachmentPointName(CIMObjectPath op) throws CIMException {
        if (!AttachmentPointProvider.isValidAttachmentPointName(op)) {
            Logger.logErr("specified an invalid AttachmentPoint name: " + op);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)op);
        }
    }
}

