/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.Logger;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class CHMemory
extends AttachmentPoint {
    protected UnsignedInt32 m_Deleted = null;
    protected boolean m_Interleaved;
    protected UnsignedInt32 m_Permanent = null;
    protected UnsignedInt64 m_PhysicalAddress = null;
    protected UnsignedInt32 m_Remaining = null;
    protected UnsignedInt32 m_Size = null;
    protected String m_Source = null;
    protected String m_Target = null;
    protected boolean m_Unconfigurable;

    public CHMemory() {
        Logger.logDebug("CHMemory() constructor");
    }

    public CHMemory(AttachmentPoint ap) {
        super(ap);
        Logger.logDebug("CHMemory(AttachmentPoint ap) constructor");
        this.populateSubclassMembers();
    }

    public CHMemory(String user) {
        super(user);
        Logger.logDebug("CHMemory(String user) constructor");
    }

    public UnsignedInt32 getDeleted() {
        return this.m_Deleted;
    }

    public boolean getInterleaved() {
        return this.m_Interleaved;
    }

    public UnsignedInt32 getPermanent() {
        return this.m_Permanent;
    }

    public UnsignedInt64 getPhysicalAddress() {
        return this.m_PhysicalAddress;
    }

    public UnsignedInt32 getRemaining() {
        return this.m_Remaining;
    }

    public boolean getResource(String hwOptions, StringBuffer error) {
        boolean status = super.getResource(hwOptions, error);
        if (status && this.m_Type.equals("memory")) {
            this.populateSubclassMembers();
        } else if (status) {
            Logger.logErr("CHMemory::getResource() m_LogicalID = " + this.m_LogicalID + "m_DomainID = " + this.m_DomainID + " is not of type memory");
            status = false;
        }
        return status;
    }

    public Vector getResources(int domainID, String hwOptions, String listOptions, StringBuffer error) {
        Vector<CHMemory> memVector = null;
        Vector apVector = super.getResources(domainID, hwOptions, listOptions, error);
        if (apVector != null) {
            memVector = new Vector<CHMemory>(apVector.size());
            Iterator apIter = ((AbstractList)apVector).iterator();
            CHMemory mem = null;
            while (apIter.hasNext()) {
                AttachmentPoint ap = (AttachmentPoint)apIter.next();
                if (!ap.m_Type.equals("memory")) continue;
                mem = new CHMemory(ap);
                memVector.add(mem);
            }
        }
        return memVector;
    }

    public UnsignedInt32 getSize() {
        return this.m_Size;
    }

    public String getSource() {
        return this.m_Source;
    }

    public String getTarget() {
        return this.m_Target;
    }

    public boolean getUnconfigurable() {
        return this.m_Unconfigurable;
    }

    public void populateSubclassMembers() {
        this.setInterleaved(false);
        this.setUnconfigurable(false);
        Iterator nameValueIter = ((AbstractList)this.getMiscInfoPairs()).iterator();
        while (nameValueIter.hasNext()) {
            String value;
            String name = (String)nameValueIter.next();
            if (name.equals("deleted")) {
                value = (String)nameValueIter.next();
                this.setDeleted(new UnsignedInt32(Long.parseLong(value)));
                continue;
            }
            if (name.equals("inter-board-interleave")) {
                this.setInterleaved(true);
                continue;
            }
            if (name.equals("permanent")) {
                value = (String)nameValueIter.next();
                this.setPermanent(new UnsignedInt32(Long.parseLong(value)));
                continue;
            }
            if (name.equals("address")) {
                value = (String)nameValueIter.next();
                BigInteger address = new BigInteger(value.substring(2), 16);
                this.setPhysicalAddress(new UnsignedInt64(address));
                continue;
            }
            if (name.equals("remaining")) {
                value = (String)nameValueIter.next();
                this.setRemaining(new UnsignedInt32(Long.parseLong(value)));
                continue;
            }
            if (name.equals("size")) {
                value = (String)nameValueIter.next();
                this.setSize(new UnsignedInt32(Long.parseLong(value)));
                continue;
            }
            if (name.equals("source")) {
                value = (String)nameValueIter.next();
                this.setSource(value);
                continue;
            }
            if (name.equals("target")) {
                value = (String)nameValueIter.next();
                this.setTarget(value);
                continue;
            }
            if (!name.equals("unconfigurable")) continue;
            this.setUnconfigurable(true);
        }
    }

    public void setDeleted(UnsignedInt32 deleted) {
        this.m_Deleted = deleted;
    }

    public void setInterleaved(boolean interleaved) {
        this.m_Interleaved = interleaved;
    }

    public void setPermanent(UnsignedInt32 permanent) {
        this.m_Permanent = permanent;
    }

    public void setPhysicalAddress(UnsignedInt64 physicalAddress) {
        this.m_PhysicalAddress = physicalAddress;
    }

    public void setRemaining(UnsignedInt32 remaining) {
        this.m_Remaining = remaining;
    }

    public void setSize(UnsignedInt32 size) {
        this.m_Size = size;
    }

    public void setSource(String source) {
        this.m_Source = source;
    }

    public void setTarget(String target) {
        this.m_Target = target;
    }

    public void setUnconfigurable(boolean unconfigurable) {
        this.m_Unconfigurable = unconfigurable;
    }
}

