/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.wdr.GetServiceByName;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.SGConfiguration;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

class ConfigFile
extends Logger {
    private static final String WDRCFG_FILENAME = "/var/opt/SUNWWDR/cfg/serengeti-wdr-cfg.dat";
    private static final String DEFAULT_PLATFORM_PRIVATE_COMMUNITY = "P-private";
    private static final String DEFAULT_PLATFORM_PUBLIC_COMMUNITY = "P-public";
    private static final int DEFAULT_SNMP_TRAP_PORT = 162;
    protected String platformPrivateCommunity = "P-private";
    protected String platformPublicCommunity = "P-public";
    protected String scHostName = null;
    protected int scTrapPort = 162;

    ConfigFile() throws CIMException {
        this.readConfigFiles();
    }

    public String getPlatformPrivateCommunity() {
        return this.platformPrivateCommunity;
    }

    String getPlatformPublicCommunity() {
        return this.platformPublicCommunity;
    }

    public String getScHostName() {
        return this.scHostName;
    }

    public int getScTrapPort() {
        return this.scTrapPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseConfigFileLine(String line, String configFilename) {
        StringTokenizer st = new StringTokenizer(line, ":");
        if (!st.hasMoreTokens()) {
            Logger.logErr("Configuration file " + configFilename + " contains line without a colon (:): " + line);
            return;
        }
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            Logger.logErr("Configuration file " + configFilename + " contains an line with a missing value: " + line);
            return;
        }
        String value = st.nextToken().trim();
        if (name.equals("SCIPAddress")) {
            this.scHostName = value;
            return;
        }
        if (name.equals("SCTrapPort")) {
            if (Character.isDigit(value.charAt(0))) {
                try {
                    this.scTrapPort = Integer.parseInt(value);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.logErr("SCTrapPort " + value + " is not an integer");
                    return;
                }
            }
            int p = GetServiceByName.getServiceByName(value, "udp");
            if (p >= 0) {
                this.scTrapPort = p;
                return;
            }
            Logger.logErr("SCTrapPort " + value + " service not found");
            return;
        }
        if (name.equals("platformRComm")) {
            this.platformPublicCommunity = value;
            return;
        }
        if (!name.equals("platformWComm")) return;
        this.platformPrivateCommunity = value;
    }

    private void readConfigFile(String configFilename) throws CIMException {
        try {
            String rawLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(configFilename)));
            while ((rawLine = br.readLine()) != null) {
                String line = rawLine.trim();
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                this.parseConfigFileLine(line, configFilename);
            }
            br.close();
        }
        catch (IOException iOException) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ResourceMessage.getMsg("WDR.configFileReadFailed", new Object[]{configFilename}));
        }
    }

    public void readConfigFiles() throws CIMException {
        this.platformPrivateCommunity = DEFAULT_PLATFORM_PRIVATE_COMMUNITY;
        this.platformPublicCommunity = DEFAULT_PLATFORM_PUBLIC_COMMUNITY;
        this.readConfigFile(WDRCFG_FILENAME);
        this.readSharedConfigFile();
    }

    private void readSharedConfigFile() throws CIMException {
        SGConfiguration sgConfig = new SGConfiguration();
        if (!sgConfig.read()) {
            Logger.logErr("read shared config data from native error");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ResourceMessage.getMsg("WDR.sharedConfigFilesReadFailed"));
        }
        this.scHostName = sgConfig.getSCIPAddress();
        this.platformPublicCommunity = sgConfig.getPlatformRComm();
        this.platformPrivateCommunity = sgConfig.getPlatformWComm();
    }

    public String toString() {
        return new String("\n" + this.getClass().getName() + ":\n" + "-----------------------------\n" + "platformPrivateCommunity: " + this.platformPrivateCommunity + "\n" + "platformPublicCommunity:  " + this.platformPublicCommunity + "\n" + "scHostName:               " + this.scHostName + "\n" + "scTrapPort:               " + this.scTrapPort);
    }
}

