/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class GetServiceByName {
    private static final String SERVICES_FILENAME = "/etc/inet/services";

    public static int getServiceByName(String tcpipService, String tcpipClass) {
        int port = -1;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(SERVICES_FILENAME)));
            while ((line = br.readLine()) != null && port == -1) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                port = GetServiceByName.parseServicesLine(line, tcpipService, tcpipClass);
            }
            br.close();
            return port;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static void main(String[] args) {
        int errorCount = 0;
        try {
            int pok;
            if (args.length != 0 && args.length != 2) {
                System.err.println("Test driver for this class\nUsage: java com.sun.wbem.wdr.GetServiceByName [<tcpipService> <tcpipclass>]\nExample: java com.sun.wbem.wdr.GetServiceByName ftp tcp");
                System.exit(1);
            }
            System.out.println("Testing GetServiceByName");
            if (args.length == 2) {
                pok = GetServiceByName.getServiceByName(args[0], args[1]);
                System.out.println("getServiceByName(\"" + args[0] + "\", \"" + args[1] + "\")    returned port " + pok);
            }
            if ((pok = GetServiceByName.getServiceByName("ntp", "udp")) == 123) {
                System.out.println("getServiceByName(\"ntp\", \"udp\") PASSED");
            } else {
                System.out.println("getServiceByName(\"ntp\", \"udp\") FAILED:  returned " + pok);
                ++errorCount;
            }
            int png = GetServiceByName.getServiceByName("nonexistentservicetest", "udp");
            if (png == -1) {
                System.out.println("getServiceByName() error test  PASSED");
            } else {
                System.out.println("getServiceByName()error test  FAILED:  returned " + png);
                ++errorCount;
            }
        }
        catch (Exception e) {
            System.err.println("Java Exception: " + e + " (exiting)");
            e.printStackTrace(System.err);
            ++errorCount;
        }
        System.exit(errorCount);
    }

    private static int parseServicesLine(String line, String tcpipService, String tcpipClass) {
        StringTokenizer st = new StringTokenizer(line, " \t/#");
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String portValue = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String classValue = st.nextToken().trim();
        if (!classValue.equals(tcpipClass)) {
            return -1;
        }
        if (name.equals(tcpipService)) {
            try {
                return Integer.parseInt(portValue);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }
}

