/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.Logger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class MCCPU
extends AttachmentPoint {
    protected String m_ID;
    protected int m_Speed;
    protected int m_ECache;

    public MCCPU() {
        Logger.logDebug("MCCPU() constructor");
    }

    public MCCPU(AttachmentPoint ap) {
        super(ap);
        Logger.logDebug("MCCPU(AttachmentPoint ap) constructor");
        this.populateSubclassMembers();
    }

    public MCCPU(String user) {
        super(user);
        Logger.logDebug("MCCPU(String user) constructor");
    }

    public int getECache() {
        return this.m_ECache;
    }

    public String getID() {
        return this.m_ID;
    }

    public boolean getResource(String hwOptions, StringBuffer error) {
        boolean status = super.getResource(hwOptions, error);
        if (status && this.m_Type.equals("cpu")) {
            this.populateSubclassMembers();
        } else if (status) {
            Logger.logErr("MCCPU::getResource() m_LogicalID = " + this.m_LogicalID + "m_DomainID = " + this.m_DomainID + " is not of type cpu");
            status = false;
        }
        return status;
    }

    public Vector getResources(int domainID, String hwOptions, String listOptions, StringBuffer error) {
        Vector<MCCPU> cpuVector = null;
        Vector apVector = super.getResources(domainID, hwOptions, listOptions, error);
        if (apVector != null) {
            cpuVector = new Vector<MCCPU>(apVector.size());
            Iterator apIter = ((AbstractList)apVector).iterator();
            MCCPU cpu = null;
            while (apIter.hasNext()) {
                AttachmentPoint ap = (AttachmentPoint)apIter.next();
                if (!ap.m_Type.equals("cpu")) continue;
                cpu = new MCCPU(ap);
                cpuVector.add(cpu);
            }
        }
        return cpuVector;
    }

    public int getSpeed() {
        return this.m_Speed;
    }

    public Integer getcpuiddelimeter(Vector outParams) {
        int status = 0;
        outParams.add(new CIMValue((Object)","));
        return new Integer(status);
    }

    public void populateSubclassMembers() {
        String id = "0";
        int ecache = 0;
        int speed = 0;
        Iterator nameValueIter = ((AbstractList)this.getMiscInfoPairs()).iterator();
        while (nameValueIter.hasNext()) {
            String name = (String)nameValueIter.next();
            String value = (String)nameValueIter.next();
            if (name.equals("cpuid")) {
                id = new String(value);
                continue;
            }
            if (name.equals("ecache")) {
                ecache = Integer.parseInt(value);
                continue;
            }
            if (!name.equals("speed")) continue;
            speed = Integer.parseInt(value);
        }
        this.setID(id);
        this.setECache(ecache);
        this.setSpeed(speed);
    }

    public void setECache(int eCache) {
        this.m_ECache = eCache;
    }

    public void setID(String id) {
        this.m_ID = id;
    }

    public void setSpeed(int speed) {
        this.m_Speed = speed;
    }
}

